/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.HashMap;
import java.util.Map;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.bo.service.LoadDirectlyRequiredModules;
import org.qedeq.kernel.bo.service.LoadRequiredModuleException;
import org.qedeq.kernel.se.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.se.common.DependencyState;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

public final class LoadRequiredModules {
    private static final Class CLASS = LoadRequiredModules.class;
    private final Map loadingRequiredInProgress = new HashMap();

    private LoadRequiredModules() {
    }

    public static boolean loadRequired(Plugin plugin, DefaultKernelQedeqBo prop) {
        if (prop.getDependencyState().areAllRequiredLoaded()) {
            return true;
        }
        return new LoadRequiredModules().loadAllRequired(plugin, prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadAllRequired(Plugin plugin, DefaultKernelQedeqBo prop) {
        String method = "loadRequired(DefaultQedeqBo)";
        Trace.param(CLASS, (Object)this, "loadRequired(DefaultQedeqBo)", "prop.getModuleAddress", prop.getModuleAddress());
        DefaultKernelQedeqBo defaultKernelQedeqBo = prop;
        synchronized (defaultKernelQedeqBo) {
            if (prop.getDependencyState().areAllRequiredLoaded()) {
                return true;
            }
            if (!prop.isLoaded()) {
                throw new IllegalArgumentException("Programming error BO must be loaded!");
            }
            if (this.loadingRequiredInProgress.containsKey(prop)) {
                throw new IllegalStateException("Programming error: must not be marked!");
            }
            prop.setDependencyProgressState(DependencyState.STATE_LOADING_REQUIRED_MODULES);
            this.loadingRequiredInProgress.put(prop, prop);
        }
        SourceFileExceptionList sfl = null;
        LoadDirectlyRequiredModules loader = new LoadDirectlyRequiredModules(plugin, prop);
        KernelModuleReferenceList required = null;
        try {
            required = loader.load();
            sfl = loader.getErrorList();
        }
        catch (SourceFileExceptionList e) {
            sfl = e;
        }
        if (sfl == null || sfl.size() == 0) {
            for (int i = 0; i < required.size(); ++i) {
                SourceFileException sf;
                LoadRequiredModuleException me;
                Trace.trace(CLASS, (Object)this, "loadRequired(DefaultQedeqBo)", "loading required modules of " + prop.getUrl());
                DefaultKernelQedeqBo current = null;
                current = (DefaultKernelQedeqBo)required.getKernelQedeqBo(i);
                if (this.loadingRequiredInProgress.containsKey(current)) {
                    me = new LoadRequiredModuleException(90722, "Recursive import of modules is forbidden, label: \"" + required.getLabel(i) + "\"", required.getModuleContext(i));
                    sf = prop.createSourceFileException(plugin, me);
                    if (sfl == null) {
                        sfl = new DefaultSourceFileExceptionList(sf);
                        continue;
                    }
                    sfl.add(sf);
                    continue;
                }
                if (this.loadAllRequired(plugin, current)) continue;
                me = new LoadRequiredModuleException(90723, "Import of module failed, label: \"" + required.getLabel(i) + "\", " + current.getErrors().get(0).getMessage(), required.getModuleContext(i));
                sf = prop.createSourceFileException(plugin, me);
                if (sfl == null) {
                    sfl = new DefaultSourceFileExceptionList(sf);
                    continue;
                }
                sfl.add(sf);
            }
        }
        DefaultKernelQedeqBo defaultKernelQedeqBo2 = prop;
        synchronized (defaultKernelQedeqBo2) {
            this.loadingRequiredInProgress.remove(prop);
            if (prop.getDependencyState().areAllRequiredLoaded()) {
                return true;
            }
            prop.getLabels().setModuleReferences(required);
            if (sfl == null || sfl.size() == 0) {
                prop.setLoadedRequiredModules(required);
                return true;
            }
            prop.setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, sfl);
            return false;
        }
    }
}

