/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.HashMap;
import java.util.Map;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.module.Element2Latex;
import org.qedeq.kernel.bo.module.ModuleLabels;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.dto.module.FunctionDefinitionVo;
import org.qedeq.kernel.se.dto.module.PredicateDefinitionVo;

public final class Element2LatexImpl
implements Element2Latex {
    private ModuleLabels labels;
    private final Map elementList2ListType = new HashMap();
    private final ListType unknown = new Unknown();
    private final Map backupPredicateDefinitions = new HashMap();
    private final Map backupFunctionDefinitions = new HashMap();

    public Element2LatexImpl(ModuleLabels labels) {
        this.labels = labels;
        this.elementList2ListType.put("PREDVAR", new Predvar());
        this.elementList2ListType.put("FUNVAR", new Funvar());
        this.elementList2ListType.put("PREDCON", new Predcon());
        this.elementList2ListType.put("FUNCON", new Funcon());
        this.elementList2ListType.put("VAR", new Var());
        this.elementList2ListType.put("AND", new BinaryLogical("\\land"));
        this.elementList2ListType.put("OR", new BinaryLogical("\\lor"));
        this.elementList2ListType.put("IMPL", new BinaryLogical("\\rightarrow"));
        this.elementList2ListType.put("EQUI", new BinaryLogical("\\leftrightarrow"));
        this.elementList2ListType.put("FORALL", new Quantifier("\\forall"));
        this.elementList2ListType.put("EXISTS", new Quantifier("\\exists"));
        this.elementList2ListType.put("EXISTSU", new Quantifier("\\exists!"));
        this.elementList2ListType.put("NOT", new Not());
        this.elementList2ListType.put("CLASS", new Class());
        this.elementList2ListType.put("CLASSLIST", new Classlist());
        this.elementList2ListType.put("QUANTOR_INTERSECTION", new QuantorIntersection());
        this.elementList2ListType.put("QUANTOR_UNION", new QuantorUnion());
        this.fillBackup();
    }

    private void fillBackup() {
        this.addBackupPredicate("equal", "2", "#1 \\ = \\ #2");
        this.addBackupPredicate("notEqual", "2", "#1 \\ \\neq \\ #2");
        this.addBackupPredicate("in", "2", "#1 \\in #2");
        this.addBackupPredicate("notIn", "2", "#1 \\notin #2");
        this.addBackupPredicate("isSet", "1", "\\mathfrak{M}(#1)");
        this.addBackupPredicate("subclass", "2", "#1 \\ \\subseteq \\ #2");
        this.addBackupPredicate("isOrderedPair", "1", "\\mbox{isOrderedPair}(#1)");
        this.addBackupPredicate("isRelation", "1", "\\mathfrak{Rel}(#1)");
        this.addBackupPredicate("isFunction", "1", "\\mathfrak{Funct}(#1)");
        this.addBackupFunction("RussellClass", "0", "\\mathfrak{Ru}");
        this.addBackupFunction("universalClass", "0", "\\mathfrak{V}");
        this.addBackupFunction("emptySet", "0", "\\emptyset");
        this.addBackupFunction("union", "2", "(#1 \\cup #2)");
        this.addBackupFunction("intersection", "2", "(#1 \\cap #2)");
        this.addBackupFunction("complement", "1", "\\overline{#1}");
        this.addBackupFunction("classList", "1", "\\{ #1 \\}");
        this.addBackupFunction("classList", "2", "\\{ #1, #2 \\}");
        this.addBackupFunction("setProduct", "1", "\\bigcap \\ #1");
        this.addBackupFunction("setSum", "1", "\\bigcup \\ #1");
        this.addBackupFunction("power", "1", "\\mathfrak{P}(#1)");
        this.addBackupFunction("orderedPair", "2", "\\langle #1, #2 \\rangle");
        this.addBackupFunction("cartesianProduct", "2", "( #1 \\times #2)");
        this.addBackupFunction("domain", "1", "\\mathfrak{Dom}(#1)");
        this.addBackupFunction("range", "1", "\\mathfrak{Rng}(#1)");
        this.addBackupFunction("successor", "1", "#1'");
    }

    private void addBackupPredicate(String name, String argNumber, String latexPattern) {
        String key = name + "_" + argNumber;
        PredicateDefinitionVo predicate = new PredicateDefinitionVo();
        predicate.setArgumentNumber(argNumber);
        predicate.setName(name);
        predicate.setLatexPattern(latexPattern);
        this.backupPredicateDefinitions.put(key, predicate);
    }

    private void addBackupFunction(String name, String argNumber, String latexPattern) {
        String key = name + "_" + argNumber;
        FunctionDefinitionVo function = new FunctionDefinitionVo();
        function.setArgumentNumber(argNumber);
        function.setName(name);
        function.setLatexPattern(latexPattern);
        this.backupFunctionDefinitions.put(key, function);
    }

    public String getLatex(Element element) {
        return this.getLatex(element, true);
    }

    String getLatex(Element element, boolean first) {
        if (element.isAtom()) {
            return element.getAtom().getString();
        }
        ElementList list = element.getList();
        ListType converter = (ListType)this.elementList2ListType.get(list.getOperator());
        if (converter == null) {
            converter = this.unknown;
        }
        return converter.getLatex(list, first);
    }

    Map getBackupPredicateDefinitions() {
        return this.backupPredicateDefinitions;
    }

    Map getBackupFunctionDefinitions() {
        return this.backupFunctionDefinitions;
    }

    class Unknown
    implements ListType {
        Unknown() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(list.getOperator());
            buffer.append("(");
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
            return buffer.toString();
        }
    }

    class QuantorUnion
    implements ListType {
        QuantorUnion() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "\\bigcup";
            buffer.append("\\bigcup");
            if (0 < list.size()) {
                buffer.append("{").append(Element2LatexImpl.this.getLatex(list.getElement(0), false)).append("}");
            }
            for (int i = 1; i < list.size(); ++i) {
                buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(" \\ \\ ");
            }
            buffer.append(" \\} ");
            return buffer.toString();
        }
    }

    class QuantorIntersection
    implements ListType {
        QuantorIntersection() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "\\bigcap";
            buffer.append("\\bigcap");
            if (0 < list.size()) {
                buffer.append("{").append(Element2LatexImpl.this.getLatex(list.getElement(0), false)).append("}");
            }
            for (int i = 1; i < list.size(); ++i) {
                buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(" \\ \\ ");
            }
            buffer.append(" \\} ");
            return buffer.toString();
        }
    }

    class Classlist
    implements ListType {
        Classlist() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "\\{ ";
            buffer.append("\\{ ");
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(", \\ ");
            }
            buffer.append(" \\} ");
            return buffer.toString();
        }
    }

    class Class
    implements ListType {
        Class() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "\\{ ";
            buffer.append("\\{ ");
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(" \\ | \\ ");
            }
            buffer.append(" \\} ");
            return buffer.toString();
        }
    }

    class Not
    implements ListType {
        Not() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "\\neg ";
            buffer.append("\\neg ");
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
            }
            return buffer.toString();
        }
    }

    class Quantifier
    implements ListType {
        private final String latex;

        Quantifier(String latex) {
            this.latex = latex;
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.latex + " ");
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0 || i == 0 && list.size() <= 2) {
                    buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
                }
                if (i + 1 < list.size()) {
                    buffer.append("\\ ");
                }
                if (list.size() <= 2 || i != 1) continue;
                buffer.append("\\ ");
            }
            return buffer.toString();
        }
    }

    class BinaryLogical
    implements ListType {
        private final String latex;

        BinaryLogical(String latex) {
            this.latex = latex;
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String infix = "\\ " + this.latex + "\\ ";
            if (!first) {
                buffer.append("(");
            }
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(infix);
            }
            if (!first) {
                buffer.append(")");
            }
            return buffer.toString();
        }
    }

    static class Var
    implements ListType {
        Var() {
        }

        public String getLatex(ElementList list, boolean first) {
            String text = list.getElement(0).getAtom().getString();
            try {
                int index = Integer.parseInt(text);
                String newText = "" + index;
                if (!text.equals(newText) || newText.startsWith("-")) {
                    throw new NumberFormatException("This is no allowed number: " + text);
                }
                switch (index) {
                    case 1: {
                        return "x";
                    }
                    case 2: {
                        return "y";
                    }
                    case 3: {
                        return "z";
                    }
                    case 4: {
                        return "u";
                    }
                    case 5: {
                        return "v";
                    }
                    case 6: {
                        return "w";
                    }
                }
                return "x_" + (index - 6);
            }
            catch (NumberFormatException e) {
                return text;
            }
        }
    }

    class Funcon
    implements ListType {
        Funcon() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String name = list.getElement(0).getAtom().getString();
            int arguments = list.size() - 1;
            String identifier = name + "_" + arguments;
            FunctionDefinition definition = (FunctionDefinition)Element2LatexImpl.this.labels.getFunctionDefinitions().get(identifier);
            if (definition == null) {
                try {
                    int external = name.indexOf(".");
                    if (external >= 0) {
                        String shortName = name.substring(external + 1);
                        identifier = shortName + "_" + arguments;
                        if (Element2LatexImpl.this.labels.getReferences() != null && Element2LatexImpl.this.labels.getReferences().size() > 0) {
                            String label = name.substring(0, external);
                            DefaultKernelQedeqBo newProp = (DefaultKernelQedeqBo)Element2LatexImpl.this.labels.getReferences().getQedeqBo(label);
                            if (newProp != null && newProp.getExistenceChecker().functionExists(shortName, arguments)) {
                                definition = newProp.getExistenceChecker().getFunction(shortName, arguments);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (definition == null) {
                definition = (FunctionDefinition)Element2LatexImpl.this.getBackupFunctionDefinitions().get(identifier);
            }
            if (definition != null) {
                StringBuffer define = new StringBuffer(definition.getLatexPattern());
                for (int i = list.size() - 1; i >= 1; --i) {
                    StringUtility.replace(define, "#" + i, Element2LatexImpl.this.getLatex(list.getElement(i), false));
                }
                buffer.append(define);
            } else {
                buffer.append(identifier);
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
            return buffer.toString();
        }
    }

    class Predcon
    implements ListType {
        Predcon() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String name = list.getElement(0).getAtom().getString();
            int arguments = list.size() - 1;
            String identifier = name + "_" + arguments;
            PredicateDefinition definition = (PredicateDefinition)Element2LatexImpl.this.labels.getPredicateDefinitions().get(identifier);
            if (definition == null) {
                try {
                    int external = name.indexOf(".");
                    if (external >= 0) {
                        String shortName = name.substring(external + 1);
                        identifier = shortName + "_" + arguments;
                        if (Element2LatexImpl.this.labels.getReferences() != null && Element2LatexImpl.this.labels.getReferences().size() > 0) {
                            String label = name.substring(0, external);
                            DefaultKernelQedeqBo newProp = (DefaultKernelQedeqBo)Element2LatexImpl.this.labels.getReferences().getQedeqBo(label);
                            if (newProp != null && newProp.getExistenceChecker().predicateExists(shortName, arguments)) {
                                definition = newProp.getExistenceChecker().getPredicate(shortName, arguments);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (definition == null) {
                definition = (PredicateDefinition)Element2LatexImpl.this.getBackupPredicateDefinitions().get(identifier);
            }
            if (definition != null) {
                StringBuffer define = new StringBuffer(definition.getLatexPattern());
                for (int i = list.size() - 1; i >= 1; --i) {
                    StringUtility.replace(define, "#" + i, Element2LatexImpl.this.getLatex(list.getElement(i), false));
                }
                buffer.append(define);
            } else {
                buffer.append(identifier);
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
            return buffer.toString();
        }
    }

    class Funvar
    implements ListType {
        Funvar() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String identifier = list.getElement(0).getAtom().getString();
            buffer.append(identifier);
            if (list.size() > 1) {
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
            return buffer.toString();
        }
    }

    class Predvar
    implements ListType {
        Predvar() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String identifier = list.getElement(0).getAtom().getString();
            buffer.append(identifier);
            if (list.size() > 1) {
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(Element2LatexImpl.this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
            return buffer.toString();
        }
    }

    static interface ListType {
        public String getLatex(ElementList var1, boolean var2);
    }
}

