/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.parser;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.base.io.TextInput;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.parser.MathParser;
import org.qedeq.kernel.bo.parser.MementoTextInput;
import org.qedeq.kernel.bo.parser.Operator;

public class LatexMathParser
extends MathParser {
    private static final Class CLASS = LatexMathParser.class;
    private static final String SPECIALCHARACTERS = "(),{}\\~%$&";
    private int tokenWhiteSpaceLines;

    public LatexMathParser(TextInput input, List operators) {
        super(new MementoTextInput(input), operators);
    }

    public LatexMathParser(StringBuffer buffer, List operators) {
        this(new TextInput(buffer), operators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String readToken() {
        String method = "readToken()";
        Trace.begin(CLASS, this, "readToken()");
        StringBuffer token = new StringBuffer();
        this.tokenWhiteSpaceLines = 0;
        try {
            block9: do {
                this.tokenWhiteSpaceLines += this.readPureWhitespace();
                if (this.tokenWhiteSpaceLines > 1) break;
                if (this.eof()) {
                    if (token.length() > 0) break;
                    token = null;
                    break;
                }
                int c = this.getChar();
                if (Character.isDigit((char)c)) {
                    token.append((char)this.readChar());
                    if (!Character.isDigit((char)this.getChar())) break;
                    continue;
                }
                if (SPECIALCHARACTERS.indexOf(c) >= 0) {
                    switch (c) {
                        case 36: 
                        case 37: 
                        case 38: 
                        case 126: {
                            this.readChar();
                            continue block9;
                        }
                        case 92: {
                            String t = this.readBackslashToken();
                            if (t.equals(" ") || t.equals("quad") || t.equals("qquad")) continue block9;
                            token.append(t);
                            if (95 != this.getChar() && 94 != this.getChar()) break block9;
                            token.append((char)this.readChar());
                            continue block9;
                        }
                        case 123: {
                            this.readChar();
                            token.append("(");
                            break;
                        }
                        case 125: {
                            this.readChar();
                            token.append(")");
                            break;
                        }
                        default: {
                            this.readChar();
                            token.append((char)c);
                            if (95 != this.getChar() && 94 != this.getChar()) break block9;
                            token.append((char)this.readChar());
                            continue block9;
                        }
                    }
                    break;
                }
                token.append((char)this.readChar());
                if (95 != this.getChar() && 94 != this.getChar()) break;
                token.append((char)this.readChar());
            } while (!this.eof());
            Trace.param(CLASS, (Object)this, "readToken()", "return token", token);
            String string = token != null ? token.toString() : null;
            return string;
        }
        finally {
            Trace.end(CLASS, this, "readToken()");
        }
    }

    private String readBackslashToken() {
        String method = "readBackslashToken()";
        Trace.begin(CLASS, this, "readBackslashToken()");
        if (this.getChar() != 92) {
            throw new IllegalArgumentException("\\ expected");
        }
        this.readChar();
        if (this.eof()) {
            Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", null);
            Trace.end(CLASS, this, "readBackslashToken()");
            return null;
        }
        if (!Character.isLetter((char)this.getChar())) {
            Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", (char)this.getChar());
            Trace.end(CLASS, this, "readBackslashToken()");
            return "" + (char)this.readChar();
        }
        StringBuffer buffer = new StringBuffer();
        do {
            buffer.append((char)this.readChar());
        } while (!this.eof() && Character.isLetter((char)this.getChar()));
        Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", buffer.toString());
        Trace.end(CLASS, this, "readBackslashToken()");
        return buffer.toString();
    }

    private int readPureWhitespace() {
        int lines = 0;
        while (this.getChar() != -1 && Character.isWhitespace((char)this.getChar())) {
            if ('\n' == (char)this.getChar()) {
                ++lines;
            }
            this.readChar();
        }
        return lines;
    }

    protected final Operator getOperator(String token) {
        Operator result = null;
        if (token == null) {
            return null;
        }
        for (int i = 0; i < this.getOperators().size(); ++i) {
            if (!token.equals(((Operator)this.getOperators().get(i)).getStartSymbol())) continue;
            result = (Operator)this.getOperators().get(i);
            break;
        }
        if (result != null) {
            return result;
        }
        if (SPECIALCHARACTERS.indexOf(token) < 0) {
            return new Operator(token, null, null, "VAR", token, 200, 0, 0);
        }
        return null;
    }

    protected final List getOperators(String token) {
        ArrayList result = new ArrayList();
        if (token == null) {
            return result;
        }
        for (int i = 0; i < this.getOperators().size(); ++i) {
            if (!token.equals(((Operator)this.getOperators().get(i)).getStartSymbol())) continue;
            result.add(this.getOperators().get(i));
        }
        if (result.size() <= 0 && SPECIALCHARACTERS.indexOf(token) < 0) {
            result.add(new Operator(token, null, null, "VAR", token, 200, 0, 0));
        }
        return result;
    }

    protected boolean eot(String token) {
        return token == null || token.trim().length() == 0;
    }
}

