/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.module;

import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.FormalProofList;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.dto.module.NodeVo;
import org.qedeq.kernel.se.visitor.QedeqNumbers;

public class KernelNodeBo {
    private final NodeVo node;
    private final ModuleContext context;
    private final KernelQedeqBo qedeq;
    private final QedeqNumbers data;

    public KernelNodeBo(NodeVo node, ModuleContext context, KernelQedeqBo qedeq, QedeqNumbers data) {
        this.node = node;
        this.context = new ModuleContext(context);
        this.qedeq = qedeq;
        this.data = new QedeqNumbers(data);
    }

    public NodeVo getNodeVo() {
        return this.node;
    }

    public ModuleContext getModuleContext() {
        return this.context;
    }

    public QedeqBo getParentQedeqBo() {
        return this.qedeq;
    }

    public QedeqNumbers getNumbers() {
        return this.data;
    }

    public boolean isLocalLabel(String label) {
        if (label == null || label.length() == 0) {
            return false;
        }
        Proposition theorem = this.getNodeVo().getNodeType().getProposition();
        if (theorem == null) {
            return false;
        }
        FormalProofList proofs = theorem.getFormalProofList();
        if (proofs == null) {
            return false;
        }
        for (int i = 0; i < proofs.size(); ++i) {
            FormalProofLineList list = proofs.get(i).getFormalProofLineList();
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                if (!label.equals(list.get(j).getLabel())) continue;
                return true;
            }
        }
        return false;
    }
}

