/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.wf;

import org.qedeq.kernel.bo.logic.common.Operators;
import org.qedeq.kernel.se.base.list.Atom;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.dto.list.ElementSet;

public final class FormulaUtility
implements Operators {
    private FormulaUtility() {
    }

    public static final boolean isSubjectVariable(Element element) {
        if (element == null || !element.isList() || element.getList() == null) {
            return false;
        }
        ElementList list = element.getList();
        if (list.getOperator().equals("VAR")) {
            if (list.size() != 1) {
                return false;
            }
            Element first = element.getList().getElement(0);
            if (first == null || !first.isAtom() || first.getAtom() == null) {
                return false;
            }
            Atom atom = first.getAtom();
            return atom.getString() != null && atom.getAtom().getString() != null && atom.getString().length() != 0;
        }
        return false;
    }

    public static final ElementSet getFreeSubjectVariables(Element element) {
        ElementSet free = new ElementSet();
        if (FormulaUtility.isSubjectVariable(element)) {
            free.add(element);
        } else if (element.isList()) {
            ElementList list = element.getList();
            String operator = list.getOperator();
            if (operator.equals("EXISTS") || operator.equals("EXISTSU") || operator.equals("FORALL") || operator.equals("CLASS")) {
                for (int i = 1; i < list.size(); ++i) {
                    free.union(FormulaUtility.getFreeSubjectVariables(list.getElement(i)));
                }
                free.remove(list.getElement(0));
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    free.union(FormulaUtility.getFreeSubjectVariables(list.getElement(i)));
                }
            }
        }
        return free;
    }

    public static final ElementSet getBoundSubjectVariables(Element element) {
        ElementSet bound;
        block4: {
            bound = new ElementSet();
            if (!element.isList()) break block4;
            ElementList list = element.getList();
            String operator = list.getOperator();
            if (operator.equals("EXISTS") || operator.equals("EXISTSU") || operator.equals("FORALL") || operator.equals("CLASS")) {
                bound.add(list.getElement(0));
                for (int i = 1; i < list.size(); ++i) {
                    bound.union(FormulaUtility.getBoundSubjectVariables(list.getElement(i)));
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    bound.union(FormulaUtility.getBoundSubjectVariables(list.getElement(i)));
                }
            }
        }
        return bound;
    }
}

