/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.model;

import java.util.ArrayList;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.logic.model.DynamicModel;
import org.qedeq.kernel.bo.logic.model.Entity;
import org.qedeq.kernel.bo.logic.model.Function;
import org.qedeq.kernel.bo.logic.model.FunctionConstant;
import org.qedeq.kernel.bo.logic.model.FunctionVariable;
import org.qedeq.kernel.bo.logic.model.FunctionVariableInterpreter;
import org.qedeq.kernel.bo.logic.model.HeuristicException;
import org.qedeq.kernel.bo.logic.model.Predicate;
import org.qedeq.kernel.bo.logic.model.PredicateConstant;
import org.qedeq.kernel.bo.logic.model.PredicateVariable;
import org.qedeq.kernel.bo.logic.model.PredicateVariableInterpreter;
import org.qedeq.kernel.bo.logic.model.SubjectVariable;
import org.qedeq.kernel.bo.logic.model.SubjectVariableInterpreter;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.bo.service.unicode.Latex2UnicodeParser;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.common.ModuleContext;

public class DynamicDirectInterpreter {
    private static final Class CLASS = DynamicDirectInterpreter.class;
    private KernelQedeqBo qedeq;
    private ModuleContext moduleContext;
    private final StringBuffer deepness = new StringBuffer();
    private final DynamicModel model;
    private final SubjectVariableInterpreter subjectVariableInterpreter;
    private final PredicateVariableInterpreter predicateVariableInterpreter;
    private final FunctionVariableInterpreter functionVariableInterpreter;

    public DynamicDirectInterpreter(KernelQedeqBo qedeq, DynamicModel model) {
        this(qedeq, model, new SubjectVariableInterpreter(model), new PredicateVariableInterpreter(model), new FunctionVariableInterpreter(model));
    }

    public DynamicDirectInterpreter(KernelQedeqBo qedeq, DynamicModel model, SubjectVariableInterpreter subjectVariableInterpreter, PredicateVariableInterpreter predicateVariableInterpreter, FunctionVariableInterpreter functionVariableInterpreter) {
        this.qedeq = qedeq;
        this.model = model;
        this.subjectVariableInterpreter = subjectVariableInterpreter;
        this.predicateVariableInterpreter = predicateVariableInterpreter;
        this.functionVariableInterpreter = functionVariableInterpreter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity calculateFunctionValue(FunctionDefinition constant, Entity[] entities) throws HeuristicException {
        Entity result;
        for (int i = 0; i < entities.length; ++i) {
            SubjectVariable var = new SubjectVariable(constant.getVariableList().get(i).getList().getElement(0).getAtom().getString());
            this.subjectVariableInterpreter.forceAddSubjectVariable(var, entities[i].getValue());
        }
        try {
            result = this.calculateTerm(constant.getTerm().getElement());
        }
        finally {
            for (int i = entities.length - 1; i >= 0; --i) {
                SubjectVariable var = new SubjectVariable(constant.getVariableList().get(i).getList().getElement(0).getAtom().getString());
                this.subjectVariableInterpreter.forceRemoveSubjectVariable(var);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean calculatePredicateValue(PredicateDefinition constant, Entity[] entities) throws HeuristicException {
        boolean result;
        for (int i = 0; i < entities.length; ++i) {
            SubjectVariable var = new SubjectVariable(constant.getVariableList().get(i).getList().getElement(0).getAtom().getString());
            this.subjectVariableInterpreter.forceAddSubjectVariable(var, entities[i].getValue());
        }
        try {
            result = this.calculateValue(constant.getFormula().getElement());
        }
        finally {
            for (int i = entities.length - 1; i >= 0; --i) {
                SubjectVariable var = new SubjectVariable(constant.getVariableList().get(i).getList().getElement(0).getAtom().getString());
                this.subjectVariableInterpreter.forceRemoveSubjectVariable(var);
            }
        }
        return result;
    }

    public boolean calculateValue(ModuleContext moduleContext, Element formula) throws HeuristicException {
        this.moduleContext = new ModuleContext(moduleContext);
        return this.calculateValue(formula);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calculateValue(Element formula) throws HeuristicException {
        boolean result;
        block29: {
            String method = "calculateValue(Element)";
            if (Trace.isDebugEnabled(CLASS)) {
                Trace.param(CLASS, (Object)this, "calculateValue(Element)", this.deepness.toString() + "formula", Latex2UnicodeParser.transform(null, this.qedeq.getElement2Latex().getLatex(formula), 0));
                this.deepness.append("-");
            }
            if (formula.isAtom()) {
                throw new HeuristicException(77091, "wrong calling convention, list expected", this.moduleContext);
            }
            KernelQedeqBo qedeqOld = this.qedeq;
            ModuleContext moduleContextOld = new ModuleContext(this.moduleContext);
            String context = this.getLocationWithinModule();
            try {
                ElementList list = formula.getList();
                this.setLocationWithinModule(context + ".getList()");
                String op = list.getOperator();
                if ("AND".equals(op)) {
                    result = true;
                    for (int i = 0; i < list.size() && result; result &= this.calculateValue(list.getElement(i)), ++i) {
                        this.setLocationWithinModule(context + ".getList().getElement(" + i + ")");
                    }
                    break block29;
                }
                if ("OR".equals(op)) {
                    result = false;
                    for (int i = 0; i < list.size() && !result; result |= this.calculateValue(list.getElement(i)), ++i) {
                        this.setLocationWithinModule(context + ".getList().getElement(" + i + ")");
                    }
                    break block29;
                }
                if ("EQUI".equals(op)) {
                    result = true;
                    boolean value = false;
                    for (int i = 0; i < list.size() && result; ++i) {
                        this.setLocationWithinModule(context + ".getList().getElement(" + i + ")");
                        if (i > 0) {
                            if (value == this.calculateValue(list.getElement(i))) continue;
                            result = false;
                            continue;
                        }
                        value = this.calculateValue(list.getElement(i));
                    }
                    break block29;
                }
                if ("IMPL".equals(op)) {
                    result = false;
                    for (int i = 0; i < list.size() && !result; ++i) {
                        this.setLocationWithinModule(context + ".getList().getElement(" + i + ")");
                        if (i < list.size() - 1) {
                            result |= !this.calculateValue(list.getElement(i));
                            continue;
                        }
                        result |= this.calculateValue(list.getElement(i));
                    }
                    break block29;
                }
                if ("NOT".equals(op)) {
                    result = true;
                    for (int i = 0; i < list.size() && result; result &= !this.calculateValue(list.getElement(i)), ++i) {
                        this.setLocationWithinModule(context + ".getList().getElement(" + i + ")");
                    }
                    break block29;
                }
                if ("PREDVAR".equals(op)) {
                    this.setLocationWithinModule(context + ".getList()");
                    Entity[] arguments = this.getEntities(list);
                    PredicateVariable var = new PredicateVariable(list.getElement(0).getAtom().getString(), list.size() - 1);
                    result = this.predicateVariableInterpreter.getPredicate(var).calculate(arguments);
                    break block29;
                }
                if ("FORALL".equals(op)) {
                    result = this.handleUniversalQuantifier(list);
                    break block29;
                }
                if ("EXISTS".equals(op)) {
                    result = this.handleExistentialQuantifier(list);
                    break block29;
                }
                if ("EXISTSU".equals(op)) {
                    result = this.handleUniqueExistentialQuantifier(list);
                    break block29;
                }
                if ("PREDCON".equals(op)) {
                    String label;
                    String name = label = list.getElement(0).getAtom().getString();
                    KernelQedeqBo newProp = this.qedeq;
                    while (name.indexOf(".") >= 0) {
                        name = name.substring(label.indexOf(".") + 1);
                        String external = label.substring(0, label.indexOf("."));
                        newProp = null;
                        if (this.qedeq.getKernelRequiredModules() != null) {
                            newProp = (DefaultKernelQedeqBo)this.qedeq.getKernelRequiredModules().getQedeqBo(external);
                        }
                        if (newProp != null) continue;
                        this.setLocationWithinModule(context + ".getList().getOperator()");
                        throw new HeuristicException(78082, "unknown (or not loaded) import module \"" + external + "\"" + " for " + "\"" + external + "." + name + "\"", this.moduleContext);
                    }
                    PredicateDefinition definition = newProp.getLabels().getPredicate(name, list.size() - 1);
                    if (definition != null && definition.getFormula() != null) {
                        this.setLocationWithinModule(context + ".getList()");
                        Entity[] arguments = this.getEntities(list);
                        this.setModuleContext(newProp);
                        this.moduleContext = newProp.getLabels().getPredicateContext(name, list.size() - 1);
                        this.setLocationWithinModule(this.getLocationWithinModule() + ".getFormula().getElement()");
                        try {
                            result = this.calculatePredicateValue(definition, arguments);
                            break block29;
                        }
                        catch (HeuristicException e) {
                            this.setModuleContext(qedeqOld);
                            this.moduleContext = moduleContextOld;
                            this.setLocationWithinModule(context + ".getList().getElement(1)");
                            throw new HeuristicException(40710, "calculation for predicate failed: " + definition, this.moduleContext, e.getContext());
                        }
                    }
                    PredicateConstant var = new PredicateConstant(name, list.size() - 1);
                    Predicate predicate = this.model.getPredicateConstant(var);
                    if (predicate == null) {
                        this.setLocationWithinModule(context + ".getList().getOperator()");
                        throw new HeuristicException(77082, "unknown predicate constant: " + var, this.moduleContext);
                    }
                    this.setLocationWithinModule(context + ".getList()");
                    Entity[] arguments = this.getEntities(list);
                    result = predicate.calculate(arguments);
                    break block29;
                }
                this.setLocationWithinModule(context + ".getList().getOperator()");
                throw new HeuristicException(77080, "unknown operator: " + op, this.moduleContext);
            }
            finally {
                this.setModuleContext(qedeqOld);
                this.moduleContext = moduleContextOld;
                this.setLocationWithinModule(context);
            }
        }
        if (Trace.isDebugEnabled(CLASS)) {
            this.deepness.setLength(this.deepness.length() > 0 ? this.deepness.length() - 1 : 0);
            Trace.param(CLASS, (Object)this, "calculateValue(Element)", this.deepness.toString() + Latex2UnicodeParser.transform(null, this.qedeq.getElement2Latex().getLatex(formula), 0), result);
        }
        return result;
    }

    private boolean handleUniversalQuantifier(ElementList list) throws HeuristicException {
        String method = "handleUniversalQuantifier(ElementList)";
        String context = this.getLocationWithinModule();
        boolean result = true;
        ElementList variable = list.getElement(0).getList();
        SubjectVariable var = new SubjectVariable(variable.getElement(0).getAtom().getString());
        this.subjectVariableInterpreter.addSubjectVariable(var);
        for (int i = 0; i < this.model.getEntitiesSize(); ++i) {
            if (Trace.isDebugEnabled(CLASS)) {
                Trace.param(CLASS, (Object)this, "handleUniversalQuantifier(ElementList)", this.deepness.toString() + Latex2UnicodeParser.transform(null, this.qedeq.getElement2Latex().getLatex(variable), 0), this.model.getEntity(i));
            }
            if (list.size() == 2) {
                this.setLocationWithinModule(context + ".getList().getElement(1)");
                result &= this.calculateValue(list.getElement(1));
            } else {
                this.setLocationWithinModule(context + ".getList().getElement(1)");
                boolean result1 = this.calculateValue(list.getElement(1));
                this.setLocationWithinModule(context + ".getList().getElement(2)");
                boolean result2 = this.calculateValue(list.getElement(2));
                result &= !result1 || result2;
            }
            if (!result) break;
            this.subjectVariableInterpreter.increaseSubjectVariableSelection(var);
        }
        this.subjectVariableInterpreter.removeSubjectVariable(var);
        return result;
    }

    private boolean handleExistentialQuantifier(ElementList list) throws HeuristicException {
        String method = "handleExistentialQuantifier(ElementList)";
        String context = this.getLocationWithinModule();
        boolean result = false;
        ElementList variable = list.getElement(0).getList();
        SubjectVariable var = new SubjectVariable(variable.getElement(0).getAtom().getString());
        this.subjectVariableInterpreter.addSubjectVariable(var);
        for (int i = 0; i < this.model.getEntitiesSize(); ++i) {
            if (Trace.isDebugEnabled(CLASS)) {
                Trace.param(CLASS, (Object)this, "handleExistentialQuantifier(ElementList)", this.deepness.toString() + Latex2UnicodeParser.transform(null, this.qedeq.getElement2Latex().getLatex(variable), 0), this.model.getEntity(i));
            }
            if (list.size() == 2) {
                this.setLocationWithinModule(context + ".getList().getElement(1)");
                result |= this.calculateValue(list.getElement(1));
            } else {
                this.setLocationWithinModule(context + ".getList().getElement(1)");
                boolean result1 = this.calculateValue(list.getElement(1));
                this.setLocationWithinModule(context + ".getList().getElement(2)");
                boolean result2 = this.calculateValue(list.getElement(2));
                result |= result1 && result2;
            }
            if (result) break;
            this.subjectVariableInterpreter.increaseSubjectVariableSelection(var);
        }
        this.subjectVariableInterpreter.removeSubjectVariable(var);
        return result;
    }

    private boolean handleUniqueExistentialQuantifier(ElementList list) throws HeuristicException {
        String method = "handleUniqueExistentialQuantifier(ElementList)";
        String context = this.getLocationWithinModule();
        boolean result = false;
        ElementList variable = list.getElement(0).getList();
        SubjectVariable var = new SubjectVariable(variable.getElement(0).getAtom().getString());
        this.subjectVariableInterpreter.addSubjectVariable(var);
        for (int i = 0; i < this.model.getEntitiesSize(); ++i) {
            boolean val;
            if (Trace.isDebugEnabled(CLASS)) {
                Trace.param(CLASS, (Object)this, "handleUniqueExistentialQuantifier(ElementList)", this.deepness.toString() + Latex2UnicodeParser.transform(null, this.qedeq.getElement2Latex().getLatex(variable), 0), this.model.getEntity(i));
            }
            if (list.size() == 2) {
                this.setLocationWithinModule(context + ".getList().getElement(1)");
                val = this.calculateValue(list.getElement(1));
            } else {
                this.setLocationWithinModule(context + ".getList().getElement(1)");
                boolean result1 = this.calculateValue(list.getElement(1));
                this.setLocationWithinModule(context + ".getList().getElement(2)");
                boolean result2 = this.calculateValue(list.getElement(2));
                boolean bl = val = result1 && result2;
            }
            if (val) {
                if (result) {
                    result = false;
                    break;
                }
                result = true;
            }
            this.subjectVariableInterpreter.increaseSubjectVariableSelection(var);
        }
        this.subjectVariableInterpreter.removeSubjectVariable(var);
        return result;
    }

    private Entity[] getEntities(ElementList terms) throws HeuristicException {
        String context = this.getLocationWithinModule();
        Entity[] result = new Entity[terms.size() - 1];
        for (int i = 0; i < result.length; ++i) {
            this.setLocationWithinModule(context + ".getElement(" + (i + 1) + ")");
            result[i] = this.calculateTerm(terms.getElement(i + 1));
        }
        this.setLocationWithinModule(context);
        return result;
    }

    public Entity calculateTerm(ModuleContext moduleContext, Element term) throws HeuristicException {
        this.moduleContext = moduleContext;
        return this.calculateTerm(term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entity calculateTerm(Element term) throws HeuristicException {
        Entity result;
        block24: {
            String method = "calculateTerm(Element) ";
            if (Trace.isDebugEnabled(CLASS)) {
                Trace.param(CLASS, (Object)this, "calculateTerm(Element) ", this.deepness.toString() + "term   ", Latex2UnicodeParser.transform(null, this.qedeq.getElement2Latex().getLatex(term), 0));
                this.deepness.append("-");
            }
            if (!term.isList()) {
                throw new RuntimeException("a term should be a list: " + term);
            }
            KernelQedeqBo qedeqOld = this.qedeq;
            ModuleContext moduleContextOld = new ModuleContext(this.moduleContext);
            String context = this.getLocationWithinModule();
            result = null;
            try {
                ElementList termList = term.getList();
                String op = termList.getOperator();
                if ("VAR".equals(op)) {
                    String text = termList.getElement(0).getAtom().getString();
                    SubjectVariable var = new SubjectVariable(text);
                    result = this.subjectVariableInterpreter.getEntity(var);
                    break block24;
                }
                if ("FUNVAR".equals(op)) {
                    FunctionVariable var = new FunctionVariable(termList.getElement(0).getAtom().getString(), termList.size() - 1);
                    Function function = this.functionVariableInterpreter.getFunction(var);
                    this.setLocationWithinModule(context + ".getList()");
                    result = function.map(this.getEntities(termList));
                    break block24;
                }
                if ("FUNCON".equals(op)) {
                    FunctionDefinition definition;
                    String label;
                    String name = label = termList.getElement(0).getAtom().getString();
                    KernelQedeqBo newProp = this.qedeq;
                    if (label.indexOf(".") >= 0) {
                        name = label.substring(label.indexOf(".") + 1);
                        String external = label.substring(0, label.indexOf("."));
                        newProp = null;
                        if (this.qedeq.getKernelRequiredModules() != null) {
                            newProp = (DefaultKernelQedeqBo)this.qedeq.getKernelRequiredModules().getQedeqBo(external);
                        }
                        if (newProp == null) {
                            this.setLocationWithinModule(context + ".getList().getOperator()");
                            throw new HeuristicException(78082, "unknown (or not loaded) import module \"" + external + "\"" + " for " + "\"" + label + "\"", this.moduleContext);
                        }
                    }
                    if ((definition = newProp.getLabels().getFunction(name, termList.size() - 1)) != null && definition.getTerm() != null) {
                        this.setLocationWithinModule(context + ".getList()");
                        Entity[] arguments = this.getEntities(termList);
                        this.setModuleContext(newProp);
                        this.moduleContext = newProp.getLabels().getFunctionContext(name, termList.size() - 1);
                        this.setLocationWithinModule(this.getLocationWithinModule() + ".getTerm().getElement()");
                        try {
                            result = this.calculateFunctionValue(definition, arguments);
                            break block24;
                        }
                        catch (HeuristicException e) {
                            this.setModuleContext(qedeqOld);
                            this.moduleContext = moduleContextOld;
                            this.setLocationWithinModule(context + ".getList().getElement(1)");
                            throw new HeuristicException(40710, "calculation for predicate failed: " + definition, this.moduleContext, e.getContext());
                        }
                    }
                    FunctionConstant var = new FunctionConstant(name, termList.size() - 1);
                    Function function = this.model.getFunctionConstant(var);
                    if (function == null) {
                        this.setLocationWithinModule(context + ".getList().getOperator()");
                        throw new HeuristicException(77092, "unknown function constant: " + var, this.moduleContext);
                    }
                    this.setLocationWithinModule(context + ".getList()");
                    Entity[] arguments = this.getEntities(termList);
                    result = function.map(arguments);
                    break block24;
                }
                if ("CLASS".equals(op)) {
                    PredicateDefinition isSet;
                    ArrayList<Entity> fullfillers = new ArrayList<Entity>();
                    ElementList variable = termList.getElement(0).getList();
                    SubjectVariable var = new SubjectVariable(variable.getElement(0).getAtom().getString());
                    this.subjectVariableInterpreter.addSubjectVariable(var);
                    KernelQedeqBo newProp = this.qedeq;
                    if (this.qedeq.getExistenceChecker() != null) {
                        newProp = this.qedeq.getExistenceChecker().getClassOperatorModule();
                    }
                    if ((isSet = newProp.getLabels().getPredicate("isSet", 1)) == null) {
                        throw new HeuristicException(77084, "unknown term operator: isSet(*)", this.moduleContext);
                    }
                    for (int i = 0; i < this.model.getEntitiesSize(); ++i) {
                        this.setModuleContext(qedeqOld);
                        this.moduleContext = moduleContextOld;
                        this.setLocationWithinModule(context + ".getList().getElement(1)");
                        if (this.calculateValue(termList.getElement(1))) {
                            this.setModuleContext(newProp);
                            this.moduleContext = newProp.getLabels().getPredicateContext("isSet", 1);
                            this.setLocationWithinModule(this.moduleContext.getLocationWithinModule() + ".getFormula().getElement()");
                            try {
                                if (this.calculatePredicateValue(isSet, new Entity[]{this.model.getEntity(i)})) {
                                    fullfillers.add(this.model.getEntity(i));
                                }
                            }
                            catch (HeuristicException e) {
                                this.setModuleContext(qedeqOld);
                                this.moduleContext = moduleContextOld;
                                this.setLocationWithinModule(context + ".getList().getElement(1)");
                                throw new HeuristicException(40710, "calculation for predicate failed: " + isSet, this.moduleContext, e.getContext());
                            }
                        }
                        this.subjectVariableInterpreter.increaseSubjectVariableSelection(var);
                    }
                    result = this.model.comprehension(fullfillers.toArray(new Entity[0]));
                    this.subjectVariableInterpreter.removeSubjectVariable(var);
                    break block24;
                }
                this.setLocationWithinModule(context + ".getList().getOperator()");
                throw new HeuristicException(77084, "unknown term operator: " + op, this.moduleContext);
            }
            finally {
                this.setModuleContext(qedeqOld);
                this.moduleContext = moduleContextOld;
                this.setLocationWithinModule(context);
            }
        }
        if (Trace.isDebugEnabled(CLASS)) {
            this.deepness.setLength(this.deepness.length() > 0 ? this.deepness.length() - 1 : 0);
            Trace.param(CLASS, (Object)this, "calculateTerm(Element) ", this.deepness.toString() + Latex2UnicodeParser.transform(null, this.qedeq.getElement2Latex().getLatex(term), 0), result);
        }
        return result;
    }

    private String getLocationWithinModule() {
        return this.moduleContext.getLocationWithinModule();
    }

    protected ModuleContext getModuleContext() {
        return this.moduleContext;
    }

    protected void setModuleContext(KernelQedeqBo qedeq) {
        this.qedeq = qedeq;
        this.moduleContext = new ModuleContext(qedeq.getModuleAddress());
    }

    protected void setLocationWithinModule(String localContext) {
        this.moduleContext.setLocationWithinModule(localContext);
    }

    public boolean next() {
        return this.subjectVariableInterpreter.next() || this.predicateVariableInterpreter.next() || this.functionVariableInterpreter.next();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Current interpretation:\n");
        buffer.append("\t" + this.predicateVariableInterpreter + "\n");
        buffer.append("\t" + this.subjectVariableInterpreter + "\n");
        buffer.append("\t" + this.functionVariableInterpreter);
        return buffer.toString();
    }

    public String stripReference(String operator) {
        int index = operator.lastIndexOf(".");
        if (index >= 0 && index + 1 < operator.length()) {
            return operator.substring(index + 1);
        }
        return operator;
    }

    public boolean hasPredicateConstant(PredicateConstant constant) {
        return null != this.model.getPredicateConstant(constant);
    }

    public boolean hasFunctionConstant(FunctionConstant constant) {
        return null != this.model.getFunctionConstant(constant);
    }

    public void clearVariables() {
        this.subjectVariableInterpreter.clear();
        this.predicateVariableInterpreter.clear();
        this.functionVariableInterpreter.clear();
    }

    public DynamicModel getModel() {
        return this.model;
    }
}

