/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileLock;
import java.util.Map;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.base.utility.YodaUtility;
import org.qedeq.kernel.bo.common.KernelProperties;
import org.qedeq.kernel.bo.common.KernelServices;
import org.qedeq.kernel.bo.common.KernelState;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.common.ServiceModule;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.config.QedeqConfig;

public final class KernelContext
implements KernelProperties,
KernelServices {
    private static final String KERNEL_NOT_STARTED = "Kernel not started";
    private static final String KERNEL_NOT_INITIALIZED = "Kernel not initialized";
    private static final Class CLASS = KernelContext.class;
    private static final String KERNEL_VERSION = "0.04.01";
    private static final String KERNEL_VERSION_DIRECTORY = "0.04.01".replace('.', '_');
    private static final String KERNEL_CODE_NAME = "gaffsie";
    private static final String KERNEL_DEDICATED = "dedicated to the sun and its warmth and light";
    private static final String DESCRIPTIVE_KERNEL_VERSION = "Hilbert II - Version 0.04.01 (gaffsie) [" + KernelContext.getBuildIdFromManifest() + "] " + "dedicated to the sun and its warmth and light";
    private static final String MAXIMAL_RULE_VERSION = "1.00.00";
    private static final KernelContext INSTANCE = new KernelContext();
    private File lockFile;
    private FileOutputStream lockStream;
    private final KernelState initialState = new KernelState(){

        public void init(ServiceModule moduleServices, QedeqConfig qedeqConfig) throws IOException {
            KernelContext.this.config = qedeqConfig;
            Trace.setTraceOn(KernelContext.this.config.isTraceOn());
            KernelContext.this.checkJavaVersion();
            KernelContext.this.createAllNecessaryDirectories();
            KernelContext.this.checkIfApplicationIsAlreadyRunningAndLockFile();
            KernelContext.this.services = moduleServices;
            QedeqLog.getInstance().logMessage("-----------------------------------------------------------------------------------------");
            QedeqLog.getInstance().logMessage("This is " + KernelContext.getInstance().getDescriptiveKernelVersion());
            QedeqLog.getInstance().logMessage("  see \"http://www.qedeq.org\" for more information");
            QedeqLog.getInstance().logMessage("  supports rules till version " + KernelContext.getInstance().getMaximalRuleVersion());
            QedeqLog.getInstance().logMessage("  Java version: " + StringUtility.alignRight(System.getProperty("java.version", "unknown"), 10));
            QedeqLog.getInstance().logMessage("  used memory:  " + StringUtility.alignRight(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory(), 10));
            QedeqLog.getInstance().logMessage("  free memory:  " + StringUtility.alignRight(Runtime.getRuntime().freeMemory(), 10));
            QedeqLog.getInstance().logMessage("  total memory: " + StringUtility.alignRight(Runtime.getRuntime().totalMemory(), 10));
            QedeqLog.getInstance().logMessage("  max. memory:  " + StringUtility.alignRight(Runtime.getRuntime().maxMemory(), 10));
            QedeqLog.getInstance().logMessage("  processors/cores: " + StringUtility.alignRight(Runtime.getRuntime().availableProcessors(), 6));
            KernelContext.this.currentState = KernelContext.this.initializedState;
        }

        public void startup() {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public void shutdown() {
            KernelContext.this.currentState = KernelContext.this.initialState;
            IoUtility.close(KernelContext.this.lockStream);
            KernelContext.this.lockStream = null;
        }

        public void removeAllModules() {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public void removeModule(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public void clearLocalBuffer() throws IOException {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public QedeqBo loadModule(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public boolean loadAllModulesFromQedeq() {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public boolean loadRequiredModules(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public ModuleAddress[] getAllLoadedModules() {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public QedeqBo getQedeqBo(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public ModuleAddress getModuleAddress(URL url) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public ModuleAddress getModuleAddress(String url) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public ModuleAddress getModuleAddress(File file) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public String getSource(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public boolean checkModule(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public Plugin[] getPlugins() {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public Object executePlugin(String pluginName, ModuleAddress address, Map parameters) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public void clearAllPluginResults(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }

        public ServiceProcess[] getServiceProcesses() {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_INITIALIZED);
        }
    };
    private final KernelState initializedState = new KernelState(){

        public void init(ServiceModule moduleServices, QedeqConfig qedeqConfig) throws IOException {
            throw new IllegalStateException("Kernel is already initialized");
        }

        public void startup() {
            KernelContext.this.services.startupServices();
            KernelContext.this.currentState = KernelContext.this.readyState;
            QedeqLog.getInstance().logMessage("QEDEQ kernel opened.");
        }

        public void shutdown() {
            KernelContext.this.services.shutdownServices();
            KernelContext.this.services = null;
            KernelContext.this.initialState.shutdown();
            QedeqLog.getInstance().logMessage("QEDEQ Kernel closed.");
        }

        public void removeAllModules() {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public void removeModule(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public void clearLocalBuffer() throws IOException {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public QedeqBo loadModule(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public boolean loadAllModulesFromQedeq() {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public boolean loadRequiredModules(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public ModuleAddress[] getAllLoadedModules() {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public QedeqBo getQedeqBo(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public ModuleAddress getModuleAddress(URL url) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public ModuleAddress getModuleAddress(String url) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public ModuleAddress getModuleAddress(File file) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public String getSource(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public boolean checkModule(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public Plugin[] getPlugins() {
            return KernelContext.this.services.getPlugins();
        }

        public Object executePlugin(String pluginName, ModuleAddress address, Map parameters) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public void clearAllPluginResults(ModuleAddress address) {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }

        public ServiceProcess[] getServiceProcesses() {
            throw new IllegalStateException(KernelContext.KERNEL_NOT_STARTED);
        }
    };
    private final KernelState readyState = new KernelState(){

        public void init(ServiceModule moduleServices, QedeqConfig qedeqConfig) throws IOException {
        }

        public void startup() {
        }

        public void shutdown() {
            try {
                ModuleAddress[] addresses = KernelContext.this.services.getAllLoadedModules();
                String[] buffer = new String[addresses.length];
                for (int i = 0; i < addresses.length; ++i) {
                    buffer[i] = addresses[i].toString();
                }
                KernelContext.this.config.setLoadedModules(buffer);
                KernelContext.this.config.store();
                QedeqLog.getInstance().logMessage("Current config file successfully saved.");
            }
            catch (IOException e) {
                Trace.trace(CLASS, (Object)this, "shutdown()", (Throwable)e);
                QedeqLog.getInstance().logMessage("Saving current config file failed.");
            }
            KernelContext.this.initializedState.shutdown();
        }

        public void removeAllModules() {
            KernelContext.this.services.removeAllModules();
        }

        public void removeModule(ModuleAddress address) {
            KernelContext.this.services.removeModule(address);
        }

        public void clearLocalBuffer() throws IOException {
            KernelContext.this.services.clearLocalBuffer();
        }

        public QedeqBo loadModule(ModuleAddress address) {
            return KernelContext.this.services.loadModule(address);
        }

        public boolean loadAllModulesFromQedeq() {
            return KernelContext.this.services.loadAllModulesFromQedeq();
        }

        public boolean loadRequiredModules(ModuleAddress address) {
            return KernelContext.this.services.loadRequiredModules(address);
        }

        public ModuleAddress[] getAllLoadedModules() {
            return KernelContext.this.services.getAllLoadedModules();
        }

        public QedeqBo getQedeqBo(ModuleAddress address) {
            return KernelContext.this.services.getQedeqBo(address);
        }

        public ModuleAddress getModuleAddress(URL url) throws IOException {
            return KernelContext.this.services.getModuleAddress(url);
        }

        public ModuleAddress getModuleAddress(String url) throws IOException {
            return KernelContext.this.services.getModuleAddress(url);
        }

        public ModuleAddress getModuleAddress(File file) throws IOException {
            return KernelContext.this.services.getModuleAddress(file);
        }

        public String getSource(ModuleAddress address) throws IOException {
            return KernelContext.this.services.getSource(address);
        }

        public boolean checkModule(ModuleAddress address) {
            return KernelContext.this.services.checkModule(address);
        }

        public Plugin[] getPlugins() {
            return KernelContext.this.services.getPlugins();
        }

        public Object executePlugin(String pluginName, ModuleAddress address, Map parameters) {
            return KernelContext.this.services.executePlugin(pluginName, address, parameters);
        }

        public void clearAllPluginResults(ModuleAddress address) {
            KernelContext.this.services.clearAllPluginResults(address);
        }

        public ServiceProcess[] getServiceProcesses() {
            return KernelContext.this.services.getServiceProcesses();
        }
    };
    private KernelState currentState = this.initialState;
    private QedeqConfig config;
    private ServiceModule services;
    static /* synthetic */ Class class$java$net$URLConnection;

    private KernelContext() {
    }

    public static final KernelContext getInstance() {
        return INSTANCE;
    }

    private static String getBuildIdFromManifest() {
        String build = KernelContext.class.getPackage().getImplementationVersion();
        if (build == null) {
            build = "no regular build";
        }
        return build;
    }

    public String getBuildId() {
        return KernelContext.getBuildIdFromManifest();
    }

    public final String getKernelVersion() {
        return KERNEL_VERSION;
    }

    public final String getKernelCodeName() {
        return KERNEL_CODE_NAME;
    }

    public final String getKernelVersionDirectory() {
        return KERNEL_VERSION_DIRECTORY;
    }

    public final String getDescriptiveKernelVersion() {
        return DESCRIPTIVE_KERNEL_VERSION;
    }

    public final String getDedication() {
        return KERNEL_DEDICATED;
    }

    public final String getMaximalRuleVersion() {
        return MAXIMAL_RULE_VERSION;
    }

    public final boolean isRuleVersionSupported(String ruleVersion) {
        return MAXIMAL_RULE_VERSION.equals(ruleVersion);
    }

    public boolean isSetConnectionTimeOutSupported() {
        return LazyHolderTimeoutMethods.IS_SET_CONNECTION_TIMEOUT_SUPPORTED;
    }

    public boolean isSetReadTimeoutSupported() {
        return LazyHolderTimeoutMethods.IS_SET_READ_TIMEOUT_SUSPPORTED;
    }

    public QedeqConfig getConfig() {
        return this.config;
    }

    public void init(ServiceModule moduleServices, QedeqConfig qedeqConfig) throws IOException {
        this.currentState.init(moduleServices, qedeqConfig);
    }

    public void startup() {
        this.currentState.startup();
    }

    public void shutdown() {
        this.currentState.shutdown();
    }

    public void removeAllModules() {
        this.currentState.removeAllModules();
    }

    public void removeModule(ModuleAddress address) {
        this.currentState.removeModule(address);
    }

    public void clearLocalBuffer() throws IOException {
        this.currentState.clearLocalBuffer();
    }

    public QedeqBo loadModule(ModuleAddress address) {
        return this.currentState.loadModule(address);
    }

    public boolean loadAllModulesFromQedeq() {
        return this.currentState.loadAllModulesFromQedeq();
    }

    public boolean loadRequiredModules(ModuleAddress address) {
        return this.currentState.loadRequiredModules(address);
    }

    public ModuleAddress[] getAllLoadedModules() {
        return this.currentState.getAllLoadedModules();
    }

    public QedeqBo getQedeqBo(ModuleAddress address) {
        return this.currentState.getQedeqBo(address);
    }

    public ModuleAddress getModuleAddress(URL url) throws IOException {
        return this.currentState.getModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(String url) throws IOException {
        return this.currentState.getModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(File file) throws IOException {
        return this.currentState.getModuleAddress(file);
    }

    public String getSource(ModuleAddress address) throws IOException {
        return this.currentState.getSource(address);
    }

    public boolean checkModule(ModuleAddress address) {
        return this.currentState.checkModule(address);
    }

    public Plugin[] getPlugins() {
        return this.currentState.getPlugins();
    }

    public Object executePlugin(String pluginName, ModuleAddress address, Map parameters) {
        return this.currentState.executePlugin(pluginName, address, parameters);
    }

    public void clearAllPluginResults(ModuleAddress address) {
        this.currentState.clearAllPluginResults(address);
    }

    public ServiceProcess[] getServiceProcesses() {
        return this.currentState.getServiceProcesses();
    }

    private void checkJavaVersion() throws IOException {
        String method = "checkJavaVersion";
        Trace.info(CLASS, this, "checkJavaVersion", "running on java version " + System.getProperty("java.version"));
        int[] versions = IoUtility.getJavaVersion();
        if (versions == null) {
            Trace.fatal(CLASS, this, "checkJavaVersion", "running java version unknown", null);
            return;
        }
        StringBuffer version = new StringBuffer();
        for (int i = 0; i < versions.length; ++i) {
            if (i > 0) {
                version.append(".");
            }
            version.append(versions[i]);
        }
        Trace.paramInfo(CLASS, (Object)this, "checkJavaVersion", "version", version);
        if (versions.length < 1 || versions[0] < 1) {
            throw new IOException("This application requires at least Java 1.4.2 but we got " + version);
        }
        if (versions[0] == 1) {
            if (versions.length < 2 || versions[1] < 4) {
                throw new IOException("This application requires at least Java 1.4.2 but we got " + version);
            }
            if (versions[1] == 4 && (versions.length < 3 || versions[2] < 2)) {
                throw new IOException("This application requires at least Java 1.4.2 but we got " + version);
            }
        }
    }

    void createAllNecessaryDirectories() throws IOException {
        File logFile = new File(this.config.getBasisDirectory(), this.config.getLogFile());
        File logDir = logFile.getParentFile();
        if (!logDir.exists() && !logDir.mkdirs()) {
            throw new IOException("can't create directory: " + logDir.getAbsolutePath());
        }
        File bufferDir = this.config.getBufferDirectory();
        if (!bufferDir.exists() && !bufferDir.mkdirs()) {
            throw new IOException("can't create directory: " + bufferDir.getAbsolutePath());
        }
        File generationDir = this.config.getGenerationDirectory();
        if (!generationDir.exists() && !generationDir.mkdirs()) {
            throw new IOException("can't create directory: " + generationDir.getAbsolutePath());
        }
    }

    private void checkIfApplicationIsAlreadyRunningAndLockFile() throws IOException {
        this.lockFile = new File(this.config.getBufferDirectory(), "qedeq_lock.lck");
        FileLock fl = null;
        try {
            this.lockStream = new FileOutputStream(this.lockFile);
            this.lockStream.write("LOCKED".getBytes("UTF8"));
            this.lockStream.flush();
            fl = this.lockStream.getChannel().tryLock();
        }
        catch (IOException e) {
            throw new IOException("It seems the application is already running.\nAt least accessing the file \"" + this.lockFile.getAbsolutePath() + "\" failed.");
        }
        if (fl == null) {
            throw new IOException("It seems the application is already running.\nAt least locking the file \"" + this.lockFile.getAbsolutePath() + "\" failed.");
        }
    }

    private static final class LazyHolderTimeoutMethods {
        private static final boolean IS_SET_CONNECTION_TIMEOUT_SUPPORTED = YodaUtility.existsMethod(class$java$net$URLConnection == null ? (class$java$net$URLConnection = KernelContext.class$("java.net.URLConnection")) : class$java$net$URLConnection, "setConnectTimeout", new Class[]{Integer.TYPE});
        private static final boolean IS_SET_READ_TIMEOUT_SUSPPORTED = YodaUtility.existsMethod(class$java$net$URLConnection == null ? (class$java$net$URLConnection = KernelContext.class$("java.net.URLConnection")) : class$java$net$URLConnection, "setReadTimeout", new Class[]{Integer.TYPE});

        private LazyHolderTimeoutMethods() {
        }
    }
}

