/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.utility;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;
import org.qedeq.base.utility.StringUtility;

public final class DateUtility {
    public static final FastDateFormat ISO_8601_TIMESTAMP_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final FastDateFormat ISO_8601_TIME_FORMATTER = FastDateFormat.getInstance((String)"HH:mm:ss.SSS");
    public static final FastDateFormat NICE_TIMESTAMP_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd' 'HH:mm:ss.SSS");
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    private DateUtility() {
    }

    public static final String getIsoTimestamp() {
        return ISO_8601_TIMESTAMP_FORMATTER.format(new Date());
    }

    public static final String getIsoTimestamp(Date date) {
        return ISO_8601_TIMESTAMP_FORMATTER.format(date);
    }

    public static final String getIsoTimestamp(long millis) {
        return ISO_8601_TIMESTAMP_FORMATTER.format(DateUtility.getDate(millis));
    }

    public static final String getIsoTime(long millis) {
        return ISO_8601_TIME_FORMATTER.format(DateUtility.getDate(millis));
    }

    public static final String getTimestamp() {
        return NICE_TIMESTAMP_FORMATTER.format(new Date());
    }

    public static final String getGmtTimestamp() {
        return NICE_TIMESTAMP_FORMATTER.format(DateUtility.getCurrentGmtDate());
    }

    public static final Date getCurrentGmtDate() {
        Calendar cal = Calendar.getInstance(GMT);
        GregorianCalendar gmtDate = new GregorianCalendar();
        gmtDate.set(2, cal.get(2));
        gmtDate.set(1, cal.get(1));
        gmtDate.set(5, cal.get(5));
        gmtDate.set(11, cal.get(11));
        gmtDate.set(12, cal.get(12));
        gmtDate.set(13, cal.get(13));
        return gmtDate.getTime();
    }

    public static final String getDuration(long milliseconds) {
        StringBuffer buffer = new StringBuffer();
        long factor = 86400000L;
        long rest = milliseconds;
        long mod = 0L;
        mod = rest / factor;
        rest %= factor;
        if (mod > 0L) {
            buffer.append(mod);
            buffer.append(" day");
            if (mod > 1L) {
                buffer.append("s");
            }
            buffer.append(" ");
        }
        mod = rest / (factor /= 24L);
        rest %= factor;
        buffer.append(StringUtility.format(mod, 2));
        buffer.append(":");
        mod = rest / (factor /= 60L);
        rest %= factor;
        buffer.append(StringUtility.format(mod, 2));
        buffer.append(":");
        mod = rest / (factor /= 60L);
        rest %= factor;
        buffer.append(StringUtility.format(mod, 2));
        buffer.append(".");
        mod = rest / (factor /= 1000L);
        buffer.append(StringUtility.format(mod, 3));
        return buffer.toString();
    }

    public static final Date getDate(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar.getTime();
    }
}

