/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.qedeq.base.io.AbstractOutput;

public class TextOutput
extends AbstractOutput {
    private final PrintStream output;
    private final String name;
    private long position;

    public TextOutput(String name, OutputStream output) {
        this(name, output, "ISO-8859-1");
    }

    public TextOutput(String name, OutputStream output, String encoding) {
        this.name = name;
        try {
            this.output = new PrintStream(output, false, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public final void flush() {
        super.flush();
        this.output.flush();
    }

    public final void close() {
        this.output.close();
    }

    public final boolean checkError() {
        return this.output.checkError();
    }

    public final String getName() {
        return this.name;
    }

    public final IOException getError() {
        if (this.checkError()) {
            return new IOException("Writing failed.");
        }
        return null;
    }

    public void append(String text) {
        this.position += (long)text.length();
        this.output.print(text);
    }

    public long getPosition() {
        return this.position;
    }
}

