/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.io;

import java.io.Serializable;
import org.qedeq.base.io.SourcePosition;

public final class SourceArea
implements Serializable {
    private final String address;
    private final SourcePosition startPosition;
    private final SourcePosition endPosition;

    public SourceArea(String address, SourcePosition startPosition, SourcePosition endPosition) {
        this.address = address;
        if (address == null || startPosition == null || endPosition == null) {
            throw new NullPointerException();
        }
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public SourceArea(String address) {
        this(address, SourcePosition.BEGIN, SourcePosition.BEGIN);
    }

    public final String getAddress() {
        return this.address;
    }

    public final SourcePosition getStartPosition() {
        return this.startPosition;
    }

    public final SourcePosition getEndPosition() {
        return this.endPosition;
    }

    public final int hashCode() {
        return this.getAddress().hashCode() ^ this.getStartPosition().hashCode() ^ this.getEndPosition().hashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof SourceArea)) {
            return false;
        }
        SourceArea other = (SourceArea)obj;
        return this.getAddress().equals(other.getAddress()) && this.getStartPosition().equals(other.getStartPosition()) && this.getEndPosition().equals(other.getEndPosition());
    }

    public final String getShortDescription() {
        return this.getStartPosition().getRow() + ":" + this.getStartPosition().getColumn() + " - " + this.getEndPosition().getRow() + ":" + this.getEndPosition().getColumn();
    }

    public final String toString() {
        return this.getAddress() + ":" + this.getStartPosition().getRow() + ":" + this.getStartPosition().getColumn() + ":" + this.getEndPosition().getRow() + ":" + this.getEndPosition().getColumn();
    }
}

