/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.util;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import javax.swing.JOptionPane;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.base.utility.YodaUtility;

public final class BareBonesBrowserLaunch {
    private static final String[] BROWSERS = new String[]{"google-chrome", "firefox", "opera", "epiphany", "konqueror", "conkeror", "midori", "kazehakase", "mozilla"};
    private static final String ERR_MSG = "Error attempting to launch web browser";

    private BareBonesBrowserLaunch() {
    }

    public static void openURL(String url) {
        Class[] classArray = new Class[1];
        Class clazz = classArray[0] = URI.class;
        if (YodaUtility.existsMethod((String)"java.awt.Desktop", (String)"browse", (Class[])classArray)) {
            try {
                Class<?> d = Class.forName("java.awt.Desktop");
                d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, (Object[])new Class[0]), URI.create(url));
                return;
            }
            catch (RuntimeException ignore) {
            }
            catch (ClassNotFoundException ignore) {
            }
            catch (IllegalAccessException ignore) {
            }
            catch (InvocationTargetException ignore) {
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
        }
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String browser = null;
                for (int i = 0; i < BROWSERS.length; ++i) {
                    String b = BROWSERS[i];
                    if (browser != null || Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() == -1) continue;
                    Runtime.getRuntime().exec(new String[]{b, url});
                    browser = b;
                }
                if (browser == null) {
                    throw new Exception(StringUtility.toString((Object[])BROWSERS));
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser\n" + e.toString());
        }
    }
}

