/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.tree;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.tree.ModuleElement;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.se.common.DependencyState;
import org.qedeq.kernel.se.common.LoadingState;
import org.qedeq.kernel.se.common.LogicalState;

public final class QedeqTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Class CLASS = QedeqTreeCellRenderer.class;
    private static ImageIcon webLoadingIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_web_loading.gif"));
    private static ImageIcon webLoadingErrorIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_web_loading_error.gif"));
    private static ImageIcon fileLoadingIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_file_loading.gif"));
    private static ImageIcon fileLoadingErrorIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_file_loading_error.gif"));
    private static ImageIcon memoryLoadingIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_memory_loading.gif"));
    private static ImageIcon memoryLoadingErrorIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_memory_loading_error.gif"));
    private static ImageIcon loadedIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_loaded.gif"));
    private static ImageIcon loadingRequiredIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_loading_required.gif"));
    private static ImageIcon loadingRequiredErrorIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_loading_required_error.gif"));
    private static ImageIcon loadedRequiredIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_loaded_required.gif"));
    private static ImageIcon checkingRequiredIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_checking_required.gif"));
    private static ImageIcon checkingRequiredErrorIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_checking_required_error.gif"));
    private static ImageIcon checkingIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_checking.gif"));
    private static ImageIcon checkingErrorIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_checking_error.gif"));
    private static ImageIcon checkedIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_checked.gif"));
    private static ImageIcon warningsIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_warnings.gif"));
    private static ImageIcon errorsIcon = new ImageIcon(QedeqTreeCellRenderer.class.getResource("/images/qedeq/16x16/module_errors.gif"));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String method = "getTreeCellRendererComponent";
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " is selected"), (boolean)isSelected);
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " is expanded"), (boolean)expanded);
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " hasFocus"), (boolean)hasFocus);
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " leaf"), (boolean)leaf);
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " maxSelectionRow"), (int)tree.getMaxSelectionRow());
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " selectionCount"), (int)tree.getSelectionCount());
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " rowCount"), (int)tree.getRowCount());
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " tree path"), (Object)tree.getPathForRow(row));
        super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        if (!(value instanceof DefaultMutableTreeNode)) return this;
        if (((DefaultMutableTreeNode)value).getUserObject() instanceof ModuleElement) {
            ModuleElement unit = (ModuleElement)((DefaultMutableTreeNode)value).getUserObject();
            this.setText(unit.getName());
            return this;
        } else {
            QedeqBo prop = (QedeqBo)((DefaultMutableTreeNode)value).getUserObject();
            String text = prop.getName();
            this.setText(text);
            LoadingState loadingState = prop.getLoadingState();
            DependencyState dependencyState = prop.getDependencyState();
            LogicalState logicalState = prop.getLogicalState();
            if (loadingState == LoadingState.STATE_LOADED) {
                this.setToolTipText(prop.getUrl().toString());
            } else {
                this.setToolTipText(prop.getStateDescription());
            }
            this.setIcon(null);
            if (loadingState == LoadingState.STATE_DELETED) return this;
            if (loadingState == LoadingState.STATE_LOADING_FROM_WEB) {
                this.setIcon(webLoadingIcon);
                return this;
            } else if (loadingState == LoadingState.STATE_LOADING_FROM_WEB_FAILED) {
                this.setIcon(webLoadingErrorIcon);
                return this;
            } else if (loadingState == LoadingState.STATE_LOADING_FROM_LOCAL_FILE) {
                this.setIcon(fileLoadingIcon);
                return this;
            } else if (loadingState == LoadingState.STATE_LOADING_FROM_LOCAL_FILE_FAILED) {
                this.setIcon(fileLoadingErrorIcon);
                return this;
            } else if (loadingState == LoadingState.STATE_LOADING_FROM_BUFFER) {
                this.setIcon(fileLoadingIcon);
                return this;
            } else if (loadingState == LoadingState.STATE_LOADING_FROM_BUFFER_FAILED) {
                this.setIcon(fileLoadingErrorIcon);
                return this;
            } else if (loadingState == LoadingState.STATE_LOADING_INTO_MEMORY) {
                this.setIcon(memoryLoadingIcon);
                return this;
            } else if (loadingState == LoadingState.STATE_LOADING_INTO_MEMORY_FAILED) {
                this.setIcon(memoryLoadingErrorIcon);
                return this;
            } else {
                if (loadingState != LoadingState.STATE_LOADED) throw new IllegalStateException("unknown module state: " + loadingState.getText());
                this.setPositiveIcon(prop, loadedIcon);
                if (dependencyState == DependencyState.STATE_UNDEFINED) return this;
                if (dependencyState == DependencyState.STATE_LOADING_REQUIRED_MODULES) {
                    this.setIcon(loadingRequiredIcon);
                    return this;
                } else if (dependencyState == DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED) {
                    this.setIcon(loadingRequiredErrorIcon);
                    return this;
                } else {
                    if (dependencyState != DependencyState.STATE_LOADED_REQUIRED_MODULES) throw new IllegalStateException("unknown module state: " + dependencyState.getText());
                    this.setPositiveIcon(prop, loadedRequiredIcon);
                    if (logicalState == LogicalState.STATE_UNCHECKED) return this;
                    if (logicalState == LogicalState.STATE_EXTERNAL_CHECKING) {
                        this.setPositiveIcon(prop, checkingRequiredIcon);
                        return this;
                    } else if (logicalState == LogicalState.STATE_EXTERNAL_CHECKING_FAILED) {
                        this.setIcon(checkingRequiredErrorIcon);
                        return this;
                    } else if (logicalState == LogicalState.STATE_INTERNAL_CHECKING) {
                        this.setPositiveIcon(prop, checkingIcon);
                        return this;
                    } else if (logicalState == LogicalState.STATE_INTERNAL_CHECKING_FAILED) {
                        this.setIcon(checkingErrorIcon);
                        return this;
                    } else {
                        if (logicalState != LogicalState.STATE_CHECKED) throw new IllegalStateException("unknown module state: " + logicalState.getText());
                        this.setPositiveIcon(prop, checkedIcon);
                    }
                }
            }
        }
        return this;
    }

    public void paintttttt(Graphics g) {
        String method = "paint";
        Trace.param((Class)CLASS, (Object)this, (String)"paint", (String)"label", (Object)this.getText());
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            int offset = currentI.getIconWidth() + this.getIconTextGap();
            g.setColor(this.getBackground());
            if (this.getComponentOrientation().isLeftToRight()) {
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            }
        } else {
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(g);
    }

    private void setPositiveIcon(QedeqBo qedeq, Icon icon) {
        if (qedeq.hasErrors()) {
            this.setIcon(errorsIcon);
        } else if (qedeq.hasWarnings()) {
            this.setIcon(warningsIcon);
        } else {
            this.setIcon(icon);
        }
    }
}

