/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.YodaUtility;
import org.qedeq.gui.se.pane.ProcessListPane;
import org.qedeq.gui.se.util.GuiHelper;

public class ProcessWindow
extends JFrame {
    private static final Class CLASS = ProcessWindow.class;
    private ProcessListPane processList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessWindow() {
        super("Processes");
        String method = "Constructor";
        Trace.begin((Class)CLASS, (Object)this, (String)"Constructor");
        try {
            this.setDefaultCloseOperation(2);
            this.setupView();
            this.updateView();
        }
        catch (Throwable e) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"Initalization of PreferencesDialog failed.", (String)"Constructor", (Throwable)e);
        }
        finally {
            Trace.end((Class)CLASS, (Object)this, (String)"Constructor");
        }
    }

    public final void setupView() {
        this.setIconImage(GuiHelper.readImageIcon("tango/16x16/categories/applications-system.png").getImage());
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel allOptions = new JPanel();
        allOptions.setBorder(GuiHelper.getEmptyBorder());
        allOptions.setLayout(new BoxLayout(allOptions, 1));
        this.processList = new ProcessListPane();
        allOptions.add(this.processList);
        content.add(allOptions);
        ButtonBarBuilder bbuilder = ButtonBarBuilder.createLeftToRightBuilder();
        JButton stackTrace = null;
        if (YodaUtility.existsMethod((Class)Thread.class, (String)"getStackTrace", (Class[])new Class[0])) {
            stackTrace = new JButton("Stacktrace");
            stackTrace.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ProcessWindow.this.processList.stackTraceSelected();
                }
            });
        }
        JButton stop = new JButton("Stop");
        stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProcessWindow.this.processList.stopSelected();
            }
        });
        JButton refresh = new JButton("Refresh");
        refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProcessWindow.this.processList.updateView();
            }
        });
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProcessWindow.this.dispose();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProcessWindow.this.dispose();
            }
        });
        if (stackTrace != null) {
            bbuilder.addGriddedButtons(new JButton[]{stackTrace, stop, refresh, cancel, ok});
        } else {
            bbuilder.addGriddedButtons(new JButton[]{stop, refresh, cancel, ok});
        }
        JPanel buttons = bbuilder.getPanel();
        content.add(GuiHelper.addSpaceAndAlignRight(buttons));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2, 1000, 400);
    }

    public void updateView() {
        this.invalidate();
        this.repaint();
    }
}

