/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.qedeq.base.utility.DateUtility;
import org.qedeq.gui.se.pane.ModuleErrorAndWarningListPane;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.common.ServiceProcess;

public class ProcessListModel
extends AbstractTableModel {
    private static ImageIcon errorIcon = new ImageIcon(ModuleErrorAndWarningListPane.class.getResource("/images/eclipse/error_tsk.gif"));
    private static ImageIcon runningIcon = new ImageIcon(ModuleErrorAndWarningListPane.class.getResource("/images/eclipse/progress_ok.gif"));
    private static ImageIcon waitingIcon = new ImageIcon(ModuleErrorAndWarningListPane.class.getResource("/images/eclipse/waiting.gif"));
    private static ImageIcon successIcon = new ImageIcon(ModuleErrorAndWarningListPane.class.getResource("/images/eclipse/complete_task.gif"));
    private ServiceProcess[] process = new ServiceProcess[0];

    public String getColumnName(int column) {
        if (column == 1) {
            return "Service";
        }
        if (column == 2) {
            return "Module";
        }
        if (column == 3) {
            return "Start";
        }
        if (column == 4) {
            return "Stop";
        }
        if (column == 5) {
            return "Duration";
        }
        if (column == 6) {
            return "%";
        }
        if (column == 7) {
            return "Position";
        }
        if (column == 8) {
            return "Parameters";
        }
        return "";
    }

    public int getRowCount() {
        return this.process.length;
    }

    public int getColumnCount() {
        return 9;
    }

    public Object getValueAt(int row, int col) {
        ServiceProcess sp = this.getServiceProcess(row);
        if (sp == null) {
            return "";
        }
        long current = System.currentTimeMillis();
        if (sp.getStop() != 0L) {
            current = sp.getStop();
        }
        switch (col) {
            case 0: {
                if (this.wasFailure(row)) {
                    return errorIcon;
                }
                if (this.wasSuccess(row)) {
                    return successIcon;
                }
                if (this.isWaiting(row)) {
                    return waitingIcon;
                }
                if (!this.isRunning(row)) break;
                return runningIcon;
            }
            case 1: {
                return sp.getService().getPluginName();
            }
            case 2: {
                return sp.getQedeq().getName();
            }
            case 3: {
                return DateUtility.getIsoTime((long)sp.getStart());
            }
            case 4: {
                return sp.getStop() != 0L ? DateUtility.getIsoTime((long)sp.getStop()) : "";
            }
            case 5: {
                return DateUtility.getDuration((long)(current - sp.getStart()));
            }
            case 6: {
                return "" + sp.getExecutionPercentage();
            }
            case 7: {
                return sp.getExecutionActionDescription().replace('\n', ' ');
            }
            case 8: {
                return sp.getParameterString();
            }
            default: {
                return "";
            }
        }
        return "";
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
    }

    public Class getColumnClass(int col) {
        Class clazz = col == 0 ? Icon.class : Object.class;
        return clazz;
    }

    public void fireTableDataChanged() {
        ServiceProcess[] changed = KernelContext.getInstance().getServiceProcesses();
        if (this.process.length > 0) {
            super.fireTableRowsUpdated(0, this.process.length - 1);
        }
        if (changed.length > this.process.length) {
            super.fireTableRowsInserted(this.process.length, changed.length - 1);
        }
        this.process = changed;
    }

    public ServiceProcess getServiceProcess(int row) {
        if (row < this.process.length && row >= 0) {
            return this.process[row];
        }
        return null;
    }

    public boolean wasFailure(int row) {
        if (row >= 0 && row < this.process.length) {
            return this.getServiceProcess(row).wasFailure();
        }
        return false;
    }

    public boolean wasSuccess(int row) {
        if (row >= 0 && row < this.process.length) {
            return this.getServiceProcess(row).wasSuccess();
        }
        return false;
    }

    public boolean isRunning(int row) {
        if (row >= 0 && row < this.process.length) {
            return this.getServiceProcess(row).isRunning();
        }
        return false;
    }

    public boolean isWaiting(int row) {
        if (row >= 0 && row < this.process.length) {
            return this.getServiceProcess(row).isBlocked();
        }
        return false;
    }
}

