/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.main;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.main.GuiOptions;
import org.qedeq.gui.se.pane.QedeqGuiConfig;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.gui.se.util.MenuHelper;

public class QedeqMenuBar
extends JMenuBar {
    private QedeqController controller;
    private String resolution = QedeqGuiConfig.getInstance().getIconSize();

    public QedeqMenuBar(QedeqController controller, GuiOptions options) {
        this.controller = controller;
        this.putClientProperty("jgoodies.headerStyle", options.getMenuBarHeaderStyle());
        this.putClientProperty("Plastic.borderStyle", options.getMenuBarPlasticBorderStyle());
        this.putClientProperty("jgoodies.windows.borderStyle", options.getMenuBarWindowsBorderStyle());
        this.putClientProperty("Plastic.is3D", options.getMenuBar3DHint());
        this.add(this.createFileMenu());
        this.add(this.createCheckMenu());
        this.add(this.createTransformMenu());
        this.add(this.createToolsMenu());
        this.add(this.createHelpMenu());
    }

    private JMenu createFileMenu() {
        JMenu menu = MenuHelper.createMenu("File", 'F');
        JMenuItem item = MenuHelper.createMenuItem("Load from Web", 'W');
        item.setToolTipText("Load QEDEQ module from anywhere in the Web");
        item.addActionListener(this.controller.getAddAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + this.resolution + "/actions/list-add.png"));
        menu.add(item);
        item = MenuHelper.createMenuItem("Load local File", 'F');
        item.setToolTipText("Load QEDEQ module from file system");
        item.addActionListener(this.controller.getAddFileAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + this.resolution + "/actions/document-open.png"));
        menu.add(item);
        item = MenuHelper.createMenuItem("Load all from QEDEQ.org", 'Q');
        item.setToolTipText("Load main set of QEDEQ modules from project home page");
        item.addActionListener(this.controller.getAddAllModulesFromQedeqAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + this.resolution + "/actions/go-home.png"));
        menu.add(item);
        menu.addSeparator();
        item = MenuHelper.createMenuItem("Remove module", 'R');
        item.setToolTipText("Unload selected QEDEQ modules. Changes status of dependent modules. Local module buffer is not affected.");
        item.addActionListener(this.controller.getRemoveModuleAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + this.resolution + "/actions/edit-cut.png"));
        menu.add(item);
        item = MenuHelper.createMenuItem("Clear Buffer", 'C');
        item.setToolTipText("Unload all QEDEQ modules and clear the local module buffer.");
        item.addActionListener(this.controller.getRemoveLocalBufferAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + this.resolution + "/actions/edit-delete.png"));
        menu.add(item);
        if (!MenuHelper.isQuitInOSMenu()) {
            menu.addSeparator();
            item = MenuHelper.createMenuItem("Exit", 'E');
            item.setToolTipText("Leave application");
            item.setIcon(GuiHelper.readImageIcon("tango/" + this.resolution + "/actions/system-log-out.png"));
            item.addActionListener(this.controller.getExitAction());
            menu.add(item);
        }
        return menu;
    }

    private JMenu createCheckMenu() {
        JMenu menu = MenuHelper.createMenu("Check", 'C');
        JMenuItem item = MenuHelper.createMenuItem("Check Mathematical Logic", 'M');
        item.setToolTipText("Check if all formulas are well formed within selected QEDEQ modules");
        item.addActionListener(this.controller.getCheckLogicAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + this.resolution + "/actions/run.png"));
        menu.add(item);
        return menu;
    }

    private JMenu createTransformMenu() {
        JMenu menu = MenuHelper.createMenu("Plugins", 'P');
        JMenuItem item = MenuHelper.createMenuItem("Plugin Preferences", 'S');
        item.addActionListener(this.controller.getPluginPreferencesAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + this.resolution + "/categories/preferences-desktop.png"));
        menu.add(item);
        item = MenuHelper.createMenuItem("Remove Plugin Results", 'R');
        item.addActionListener(this.controller.getRemovePluginResultsAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + this.resolution + "/actions/edit-clear.png"));
        menu.add(item);
        menu.addSeparator();
        JMenuItem[] pluginMenu = this.controller.getPluginMenuEntries();
        for (int i = 0; i < pluginMenu.length; ++i) {
            menu.add(pluginMenu[i]);
        }
        return menu;
    }

    private JMenu createToolsMenu() {
        JMenu menu = MenuHelper.createMenu("Tools", 'o');
        JMenuItem item = MenuHelper.createMenuItem("LaTeX to QEDEQ", 'L');
        item.addActionListener(this.controller.getParserAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + this.resolution + "/actions/format-indent-more.png"));
        menu.add(item);
        item = MenuHelper.createMenuItem("Preferences", 'P');
        item.addActionListener(this.controller.getPreferencesAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + this.resolution + "/categories/preferences-system.png"));
        menu.add(item);
        item = MenuHelper.createMenuItem("Threads", 'T');
        item.addActionListener(this.controller.getProcessViewAction());
        item.setIcon(GuiHelper.readImageIcon("oil/" + this.resolution + "/apps/utilities-system-monitor.png"));
        menu.add(item);
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = MenuHelper.createMenu("Help", 'H');
        JMenuItem item = MenuHelper.createMenuItem("Help Contents", GuiHelper.readImageIcon("tango/" + this.resolution + "/apps/help-browser.png"), 'H');
        item.addActionListener(this.controller.getHelpAction());
        menu.add(item);
        if (!MenuHelper.isAboutInOSMenu()) {
            menu.addSeparator();
            item = MenuHelper.createMenuItem("About", GuiHelper.readImageIcon("qedeq/" + this.resolution + "/qedeq.png"), 'a');
            item.addActionListener(this.controller.getAboutAction());
            menu.add(item);
        }
        return menu;
    }
}

