/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.element;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class CPTextArea
extends JTextArea {
    public CPTextArea() {
        ClipboardListener clipboardactivator = new ClipboardListener(this);
        this.addMouseListener(clipboardactivator);
    }

    public CPTextArea(String initialText, boolean editable) {
        this.setDragEnabled(true);
        this.setEditable(editable);
        ClipboardListener clipboardactivator = new ClipboardListener(this);
        this.addMouseListener(clipboardactivator);
        this.setText(initialText);
    }

    private static class ClipboardListener
    extends MouseAdapter
    implements ActionListener {
        private final JPopupMenu popedit;
        private final CPTextArea outer;

        ClipboardListener(CPTextArea outer) {
            this.outer = outer;
            this.popedit = new JPopupMenu();
            JMenuItem jmenuitem = new JMenuItem("Copy");
            jmenuitem.addActionListener(this);
            jmenuitem.setActionCommand("copy");
            this.popedit.add(jmenuitem);
            if (outer.isEditable()) {
                JMenuItem jmenuitem1 = new JMenuItem("Cut");
                jmenuitem1.addActionListener(this);
                jmenuitem1.setActionCommand("cut");
                this.popedit.add(jmenuitem1);
                JMenuItem jmenuitem2 = new JMenuItem("Paste");
                jmenuitem2.addActionListener(this);
                jmenuitem2.setActionCommand("paste");
                this.popedit.add(jmenuitem2);
            }
        }

        public void mousePressed(MouseEvent mouseevent) {
            if (mouseevent.getModifiers() != 16) {
                this.popedit.show(this.outer, mouseevent.getX(), mouseevent.getY());
            }
        }

        public void actionPerformed(ActionEvent actionevent) {
            String s = actionevent.getActionCommand();
            if (s.equals("copy")) {
                this.outer.copy();
            } else if (s.equals("cut")) {
                this.outer.cut();
            } else if (s.equals("paste")) {
                this.outer.paste();
            }
        }
    }
}

