/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.control;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.pane.QedeqGuiConfig;
import org.qedeq.gui.se.pane.TextPaneWindow;
import org.qedeq.gui.se.tree.NothingSelectedException;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.se.common.Plugin;

public class PluginAction
extends AbstractAction {
    private static final Class CLASS = PluginAction.class;
    private final QedeqController controller;
    private Plugin plugin;
    private String resolution = QedeqGuiConfig.getInstance().getIconSize();

    PluginAction(QedeqController controller, Plugin plugin) {
        this.controller = controller;
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        String method = "actionPerformed";
        Trace.begin((Class)CLASS, (Object)this, (String)"actionPerformed");
        try {
            QedeqBo[] props;
            try {
                props = this.controller.getSelected();
            }
            catch (NothingSelectedException ex) {
                this.controller.selectionError();
                Trace.end((Class)CLASS, (Object)this, (String)"actionPerformed");
                return;
            }
            for (int i = 0; i < props.length; ++i) {
                final QedeqBo prop = props[i];
                Thread thread = new Thread(){

                    public void run() {
                        final Object result = KernelContext.getInstance().executePlugin(PluginAction.this.plugin.getPluginId(), prop.getModuleAddress(), QedeqGuiConfig.getInstance().getPluginEntries(PluginAction.this.plugin));
                        if (result instanceof String) {
                            Runnable showTextResult = new Runnable(){

                                public void run() {
                                    new TextPaneWindow(PluginAction.this.plugin.getPluginName(), PluginAction.this.getIcon(), (String)result).setVisible(true);
                                }
                            };
                            SwingUtilities.invokeLater(showTextResult);
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
            }
        }
        finally {
            Trace.end((Class)CLASS, (Object)this, (String)"actionPerformed");
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public ImageIcon getIcon() {
        if (this.plugin.getPluginName().endsWith("LaTeX")) {
            return GuiHelper.readImageIcon("tango/" + this.resolution + "/mimetypes/x-office-document.png");
        }
        if (-1 < this.plugin.getPluginName().indexOf("euristic")) {
            return GuiHelper.readImageIcon("tango/" + this.resolution + "/apps/accessories-calculator.png");
        }
        if (this.plugin.getPluginName().endsWith("earch")) {
            return GuiHelper.readImageIcon("tango/" + this.resolution + "/categories/applications-system.png");
        }
        if (-1 < this.plugin.getPluginName().indexOf("Show")) {
            return GuiHelper.readImageIcon("tango/" + this.resolution + "/actions/edit-find.png");
        }
        if (-1 < this.plugin.getPluginName().indexOf("UTF-8")) {
            return GuiHelper.readImageIcon("tango/" + this.resolution + "/mimetypes/text-x-generic.png");
        }
        return GuiHelper.readImageIcon("tango/" + this.resolution + "/actions/edit-find.png");
    }
}

