/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.control;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.se.common.ModuleAddress;

class AddAction
extends AbstractAction {
    private static final Class CLASS = AddAction.class;
    private final QedeqController controller;

    AddAction(QedeqController controller) {
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent e) {
        ModuleAddress address;
        Trace.trace((Class)CLASS, (Object)this, (String)"actionPerformed", (Object)e);
        Object[] message = new Object[2];
        message[0] = "Please choose or enter a module URL:";
        JComboBox cb = new JComboBox();
        for (int i = 0; i < this.controller.getModuleHistory().size() && i < 10; ++i) {
            cb.addItem(this.controller.getModuleHistory().get(i));
        }
        cb.setEditable(true);
        message[1] = cb;
        Object[] options = new String[]{"Ok", "Cancel"};
        int result = JOptionPane.showOptionDialog(this.controller.getMainFrame(), message, "Loading of a module", 2, 3, null, options, options[0]);
        switch (result) {
            case 0: {
                try {
                    address = KernelContext.getInstance().getModuleAddress((String)cb.getSelectedItem());
                    this.controller.addToModuleHistory(address.toString());
                    break;
                }
                catch (IOException ie) {
                    Trace.trace((Class)CLASS, (Object)this, (String)"actionPerformed", (String)"no correct URL", (Throwable)ie);
                    JOptionPane.showMessageDialog(this.controller.getMainFrame(), "this is no valid URL: " + cb.getSelectedItem() + "\n" + ie.getMessage(), "Error", 0);
                    return;
                }
            }
            default: {
                return;
            }
        }
        Thread thread = new Thread(){

            public void run() {
                KernelContext.getInstance().loadModule(address);
            }
        };
        thread.setDaemon(true);
        thread.start();
    }
}

