/*
 * Decompiled with CFR 0.152.
 */
package com_cenqua_clover;

import com.cenqua.clover.CoverageRecording;
import com.cenqua.clover.Logger;
import com.cenqua.clover.instr.InstrumentationConfig;
import com_cenqua_clover.Clover;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class CoverageRecorder {
    private static final int MIN_INTERVAL = 200;
    private static final Class FORCE_THIS_TO_LOAD = class$com$cenqua$clover$CoverageRecording == null ? (class$com$cenqua$clover$CoverageRecording = CoverageRecorder.class$("com.cenqua.clover.CoverageRecording")) : class$com$cenqua$clover$CoverageRecording;
    public int[] E;
    public boolean D = true;
    private long dbVersion;
    private long lastFlush = -1L;
    private String dbName;
    private final String recName;
    private final String alternateRecName;
    private int flushInterval = 0;
    private boolean useAlternate = false;
    private Thread shutdownFlusher;
    private Thread activeFlusher;
    private boolean activeFlush;
    private boolean directedOnly = false;
    private boolean shutdownHookEnabled = true;
    private boolean useCurrentThreadGroup = true;
    private boolean sliceFlushingEnabled = true;
    private boolean flushInProgress;
    private boolean keepFlushing;
    private final boolean noopMode;
    private long initTS;
    private int hashcode;
    private int numElements;
    private static final long FLUSH_INTERVAL_MASK = Integer.MAX_VALUE;
    private static final int FLUSHPOLICY_MASK = 7;
    private static final int DISABLE_SHUTDOWNHOOK_MASK = 128;
    private static final int USE_CURRENT_THREADGROUP_MASK = 256;
    private static final int DISABLE_SLICE_FLUSHING_MASK = 512;
    public static final int FLUSHPOLICY_DIRECTED = 0;
    public static final int FLUSHPOLICY_INTERVAL = 1;
    public static final int FLUSHPOLICY_THREADED = 2;
    static /* synthetic */ Class class$com$cenqua$clover$CoverageRecording;

    private void processConfigBits(long cfg) {
        this.flushInterval = (int)(cfg & Integer.MAX_VALUE);
        int cfgbits = (int)(cfg >> 32);
        int flushpolicy = cfgbits & 7;
        this.activeFlush = false;
        if (flushpolicy == 0) {
            this.directedOnly = true;
        } else if (flushpolicy == 2) {
            this.activeFlush = true;
        }
        this.useCurrentThreadGroup = (cfgbits & 0x100) != 0;
        this.shutdownHookEnabled = (cfgbits & 0x80) == 0;
        this.sliceFlushingEnabled = (cfgbits & 0x200) == 0;
    }

    public static long getConfigBits(InstrumentationConfig cfg) {
        return CoverageRecorder.getConfigBits(cfg.getFlushPolicy(), cfg.getFlushInterval(), false, false, !cfg.isSliceRecording());
    }

    public static long getConfigBits(long flushPolicy, int flushInterval, boolean useCurrentThreadGroup, boolean disableShutdownHook, boolean disableSlicedFlushing) {
        long result = flushInterval;
        result += flushPolicy << 32;
        if (disableShutdownHook) {
            result += 0x8000000000L;
        }
        if (useCurrentThreadGroup) {
            result += 0x10000000000L;
        }
        if (disableSlicedFlushing) {
            result += 0x20000000000L;
        }
        return result;
    }

    public CoverageRecorder(String dbName, long dbVersion, int numElements, long cfgbits) {
        this.processConfigBits(cfgbits);
        this.numElements = numElements;
        this.E = new int[numElements];
        this.dbVersion = dbVersion;
        if (this.flushInterval < 200) {
            this.flushInterval = 200;
        }
        this.dbName = dbName;
        boolean bl = this.noopMode = this.dbName == null;
        if (!this.noopMode) {
            this.hashcode = this.hashCode();
            this.initTS = System.currentTimeMillis();
            this.recName = Clover.getRecordingName(this.hashcode, dbName, this.initTS);
            this.alternateRecName = this.recName + ".1";
        } else {
            this.sliceFlushingEnabled = false;
            this.recName = null;
            this.alternateRecName = null;
        }
    }

    public void startRun() {
        if (this.noopMode) {
            return;
        }
        int slice = Clover.getCurrentSlice();
        if (slice != -1) {
            this.sliceStart(Clover.getCurrentType(), Clover.getCurrentSliceStart(), slice);
        }
        if (this.activeFlush) {
            this.activeFlusher = new CloverFlushThread(this.getTargetThreadGroup());
            this.keepFlushing = true;
            this.activeFlusher.setDaemon(true);
            this.activeFlusher.start();
            Logger.getInstance().debug("[started active flush thread for registry at " + this.dbName + ", interval= " + this.flushInterval + "]");
        }
        if (this.shutdownHookEnabled) {
            try {
                this.shutdownFlusher = new Thread(this.getTargetThreadGroup(), "CloverShutdownFlusher"){

                    public void run() {
                        if (CoverageRecorder.this.activeFlush) {
                            CoverageRecorder.this.keepFlushing = false;
                            CoverageRecorder.this.activeFlusher.interrupt();
                        }
                        Logger.getInstance().debug("[performing shutdown flush for registry at " + CoverageRecorder.this.dbName + "]");
                        CoverageRecorder.this.forceFlush();
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownFlusher);
                Logger.getInstance().debug("[added shutdown hook for registry at " + this.dbName + "]");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Logger.getInstance().debug("[started recorder; registry at " + this.dbName + "]");
        Logger.getInstance().debug("[integer mode; size=" + this.E.length + "]");
    }

    private ThreadGroup getTargetThreadGroup() {
        ThreadGroup target = Thread.currentThread().getThreadGroup();
        if (this.useCurrentThreadGroup) {
            return target;
        }
        ThreadGroup parent = target;
        while (parent != null) {
            target = parent;
            parent = target.getParent();
        }
        return target;
    }

    String getRecordingName() {
        return this.recName;
    }

    public Thread getShutdownFlusher() {
        return this.shutdownFlusher;
    }

    public void maybeFlush() {
        if (this.directedOnly || this.activeFlush) {
            return;
        }
        if (System.currentTimeMillis() - this.lastFlush > (long)this.flushInterval) {
            this.forceFlush();
        }
    }

    public void forceFlush() {
        this.D = true;
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.noopMode || !this.D || this.flushInProgress) {
            return;
        }
        String string = this.recName;
        synchronized (string) {
            long tmp = System.currentTimeMillis();
            this.lastFlush = this.lastFlush == tmp ? tmp + 1L : tmp;
            try {
                this.flushInProgress = true;
                CoverageRecording.flushRecordingToDisk(this.useAlternate ? this.alternateRecName : this.recName, null, null, this.dbVersion, this.lastFlush, -1, null, null, this.E);
                this.useAlternate = !this.useAlternate;
                Logger.getInstance().debug("[flushed recorder (" + this.dbName + ") ]");
                this.D = false;
            }
            catch (IOException e) {
                Logger.getInstance().error(e.getClass().getName() + " flushing coverage for recorder " + this.recName + ": " + e.getMessage());
            }
            catch (RuntimeException e) {
                Logger.getInstance().error(e.getClass().getName() + " flushing coverage for recorder " + this.recName + ": " + e.getMessage());
                throw e;
            }
            catch (Error e) {
                Logger.getInstance().error(e.getClass().getName() + " flushing coverage for recorder " + this.recName + ": " + e.getMessage());
                throw e;
            }
            finally {
                this.flushInProgress = false;
            }
        }
    }

    public void globalSliceStart(Class runtimeType, int id) {
        Clover.allRecordersSliceStart(runtimeType, id);
    }

    public void globalSliceEnd(Class runtimeType, String method, int id) {
        Clover.allRecordersSliceEnd(runtimeType, method, id, -1, null);
    }

    public void globalSliceEnd(Class runtimeType, String method, int id, int exitStatus, Throwable t) {
        Clover.allRecordersSliceEnd(runtimeType, method, id, exitStatus, t);
    }

    public void sliceStart(Class runtimeType, long ts, int id) {
        this.sliceFlush(runtimeType, null, ts, id, true, -1, null);
    }

    public void sliceEnd(Class runtimeType, String method, long ts, int id, int exitStatus, Throwable t) {
        this.sliceFlush(runtimeType, method, ts, id, false, exitStatus, t);
    }

    private void sliceFlush(Class runtimeType, String method, long ts, int id, boolean start, int exitStatus, Throwable t) {
        if (this.sliceFlushingEnabled) {
            int typeID = Clover.getTypeID(runtimeType);
            if (start) {
                runtimeType = null;
            }
            String sliceRecName = Clover.getRecordingName(typeID, id, start ? 0 : 1, this.hashcode, this.dbName, this.initTS);
            try {
                String stackTrace = null;
                String exitMessage = null;
                if (t != null) {
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    stackTrace = sw.toString();
                    exitMessage = t.getMessage();
                }
                CoverageRecording.flushRecordingToDisk(sliceRecName, runtimeType, method, this.dbVersion, ts, exitStatus, exitMessage, stackTrace, this.E);
            }
            catch (IOException e) {
                Logger.getInstance().error("IO Exception flushing sliced coverage for recorder " + this.recName);
            }
        }
    }

    void growToSize(int numElements) {
        if (this.noopMode && numElements > this.numElements) {
            this.numElements = numElements;
            this.E = new int[numElements];
        }
    }

    public int getNumElements() {
        return this.numElements;
    }

    public void rethrow(Throwable t) {
        throw t;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CloverFlushThread
    extends Thread {
        public CloverFlushThread(ThreadGroup group) {
            super(group, "CloverFlushThread");
        }

        public void requestFlush() {
            CoverageRecorder.this.forceFlush();
        }

        public void run() {
            while (CoverageRecorder.this.keepFlushing) {
                try {
                    Thread.sleep(CoverageRecorder.this.flushInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!CoverageRecorder.this.keepFlushing || System.currentTimeMillis() - CoverageRecorder.this.lastFlush < (long)CoverageRecorder.this.flushInterval) continue;
                CoverageRecorder.this.flush();
            }
        }
    }
}

