/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.pdf;

import clover.com.lowagie.text.Chunk;
import clover.com.lowagie.text.Document;
import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.FontFactory;
import clover.com.lowagie.text.Image;
import clover.com.lowagie.text.Phrase;
import clover.com.lowagie.text.Rectangle;
import clover.com.lowagie.text.pdf.BaseFont;
import clover.com.lowagie.text.pdf.PdfContentByte;
import clover.com.lowagie.text.pdf.PdfPTable;
import clover.com.lowagie.text.pdf.PdfPageEventHelper;
import clover.com.lowagie.text.pdf.PdfTemplate;
import clover.com.lowagie.text.pdf.PdfWriter;
import com.cenqua.clover.CloverLicenseInfo;
import com.cenqua.clover.reporters.pdf.PDFColours;
import com.cenqua.clover.util.Formatting;
import com.cenqua.clover.util.format.PDFFormatter;
import java.io.IOException;
import java.util.Date;

public class PageFooterRenderer
extends PdfPageEventHelper {
    private PdfContentByte cb;
    private PdfTemplate footerTmpl;
    private PdfTemplate totalPageTmpl;
    private BaseFont pageNumFont = null;
    private BaseFont licenseFont = null;
    private float footerWidth;
    private static final int SCALED_LOGO_SIZE = 32;
    private static final int FOOTER_FONT_SIZE = 8;
    private final String timestamp;
    private final Rectangle pgsize;
    private final PDFColours colours;

    public PageFooterRenderer(Rectangle size, long generatedTS, PDFColours colours) {
        this.pgsize = size;
        this.timestamp = Formatting.formatDate(new Date(generatedTS));
        this.colours = colours;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        try {
            this.pageNumFont = BaseFont.createFont("Helvetica", "Cp1252", false);
            this.licenseFont = BaseFont.createFont("Helvetica-Oblique", "Cp1252", false);
            this.cb = writer.getDirectContent();
            this.footerWidth = this.pgsize.width() - 25.0f - 25.0f;
            this.footerTmpl = this.cb.createTemplate(this.footerWidth, 32.0f);
            Image logo = Image.getInstance(this.getClass().getClassLoader().getResource("pdf_res/logo1.png"));
            this.footerTmpl.addImage(logo, 32.0f, 0.0f, 0.0f, 32.0f, 0.0f, 0.0f);
            this.footerTmpl.setLineWidth(0.5f);
            this.footerTmpl.setColorStroke(this.colours.COL_TABLE_BORDER);
            this.footerTmpl.moveTo(0.0f, 32.0f);
            this.footerTmpl.lineTo(this.footerWidth, 32.0f);
            this.footerTmpl.stroke();
            PdfPTable footerTab = new PdfPTable(2);
            footerTab.setTotalWidth(this.footerWidth - 32.0f - 60.0f);
            footerTab.setWidths(new int[]{30, 70});
            footerTab.getDefaultCell().setBorder(8);
            footerTab.getDefaultCell().setBorderWidth(0.5f);
            footerTab.getDefaultCell().setBorderColor(this.colours.COL_TABLE_BORDER);
            footerTab.getDefaultCell().setPadding(2.0f);
            footerTab.getDefaultCell().setLeading(2.0f, 0.9f);
            Phrase licText = new Phrase("Report generated by ", FontFactory.getFont("Helvetica", 8.0f, 2));
            licText.add(new Chunk("Clover v2.3.1", FontFactory.getFont("Helvetica", 8.0f, 2, this.colours.COL_LINK_TEXT)).setAnchor("http://www.atlassian.com/software/clover"));
            licText.add(new Phrase("\n" + this.timestamp, FontFactory.getFont("Helvetica", 8.0f, 2)));
            footerTab.addCell(licText);
            footerTab.getDefaultCell().setBorder(0);
            footerTab.getDefaultCell().setPaddingRight(2.0f);
            footerTab.getDefaultCell().setPaddingLeft(6.0f);
            String stmt = CloverLicenseInfo.OWNER_STMT;
            if (CloverLicenseInfo.VERBOSE) {
                stmt = !CloverLicenseInfo.EXPIRED ? stmt + " " + CloverLicenseInfo.PRE_EXPIRY_STMT : stmt + " " + CloverLicenseInfo.POST_EXPIRY_STMT;
            }
            footerTab.addCell(PDFFormatter.format(stmt, "Helvetica", 8, this.colours.COL_LINK_TEXT));
            footerTab.writeSelectedRows(0, -1, 34.0f, 30.0f, this.footerTmpl);
            this.totalPageTmpl = this.cb.createTemplate(25.0f, 25.0f);
        }
        catch (DocumentException de) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        int pageN = writer.getPageNumber();
        String text = "Page " + pageN + " of ";
        float len = this.pageNumFont.getWidthPoint(text, 8.0f);
        float max = this.pageNumFont.getWidthPoint("99", 8.0f);
        int FROM_BOTTOM = 0;
        this.cb.beginText();
        this.cb.setFontAndSize(this.pageNumFont, 8.0f);
        this.cb.setTextMatrix(25.0f + this.footerWidth - len - max, FROM_BOTTOM + 32 - 8 - 2);
        this.cb.showText(text);
        this.cb.endText();
        this.cb.addTemplate(this.footerTmpl, 25.0f, FROM_BOTTOM);
        this.cb.addTemplate(this.totalPageTmpl, 25.0f + this.footerWidth - max, FROM_BOTTOM + 32 - 8 - 2);
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.totalPageTmpl.beginText();
        this.totalPageTmpl.setFontAndSize(this.pageNumFont, 8.0f);
        this.totalPageTmpl.showText(String.valueOf(writer.getPageNumber() - 1));
        this.totalPageTmpl.endText();
    }
}

