/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.StackTraceInfo;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporting.util.JavaSourceRenderer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HtmlSourceRenderer
extends JavaSourceRenderer {
    private static final String CLOSE_SPAN = "</span>";
    private static final String OPEN_KEYWORD = "<span class=\"keyword\">";
    private static final String CLOSE_KEYWORD = "</span>";
    private static final String OPEN_STRING = "<span class=\"string\">";
    private static final String CLOSE_STRING = "</span>";
    private static final String OPEN_JDOCTAG = "<span class=\"javadoc\">";
    private static final String CLOSE_JDOCTAG = "</span>";
    private static final String OPEN_COMMENT = "<span class=\"comment\">";
    private static final String CLOSE_COMMENT = "</span>";
    private StringBuffer out = new StringBuffer();
    private ProjectInfo project;
    private PackageInfo pkg;
    private List lineInfo;
    private HtmlRenderingSupport helper;
    private String tab;
    private String space;
    private Set pkgsInScope = new HashSet();
    private Map classesInScope = new HashMap();

    HtmlSourceRenderer(FileInfo finfo, List info, HtmlRenderingSupport helper, String tab, String space) {
        this.lineInfo = info;
        this.helper = helper;
        this.tab = tab;
        this.space = space;
        this.pkg = (PackageInfo)finfo.getContainingPackage();
        this.project = (ProjectInfo)this.pkg.getContainingProject();
    }

    protected void addImportScope(String imp) {
        if (imp.endsWith("*")) {
            String pkg = imp.substring(0, imp.lastIndexOf(46));
            PackageInfo pkgInfo = (PackageInfo)this.project.getNamedPackage(pkg);
            if (pkgInfo != null) {
                this.pkgsInScope.add(pkgInfo);
            }
        } else {
            ClassInfo cInfo = (ClassInfo)this.project.findClass(imp);
            if (cInfo != null) {
                this.classesInScope.put(cInfo.getName(), cInfo);
            }
        }
    }

    private ClassInfo searchInScope(String ident) {
        ClassInfo cInfo = (ClassInfo)this.classesInScope.get(ident);
        if (cInfo == null && (cInfo = (ClassInfo)this.project.findClass(this.pkg.getName() + "." + ident)) == null) {
            Iterator it = this.pkgsInScope.iterator();
            while (it.hasNext()) {
                PackageInfo pkgInfo = (PackageInfo)it.next();
                cInfo = (ClassInfo)this.project.findClass(pkgInfo.getName() + "." + ident);
                if (cInfo == null) continue;
                this.classesInScope.put(ident, cInfo);
            }
        }
        return cInfo;
    }

    protected void renderStringLiteral(String s) {
        this.out.append(OPEN_STRING);
        this.out.append(this.helper.htmlEscapeStr(s, this.tab, this.space));
        this.out.append("</span>");
    }

    protected void renderKeyword(String s) {
        this.out.append(OPEN_KEYWORD);
        this.out.append(s);
        this.out.append("</span>");
    }

    protected void renderCommentChunk(String s) {
        this.out.append(OPEN_COMMENT);
        this.out.append(this.helper.htmlEscapeStr(s, this.tab, this.space));
        this.out.append("</span>");
    }

    protected void renderJavadocTag(String s) {
        this.out.append(OPEN_JDOCTAG);
        this.out.append(s);
        this.out.append("</span>");
    }

    protected void renderChunk(String s) {
        this.out.append(this.helper.htmlEscapeStr(s, this.tab, this.space));
    }

    protected void renderPackageSegment(String accum, String seg) {
        if (this.project.getNamedPackage(accum) != null) {
            this.out.append("<a href=\"").append(this.helper.getPackageRelPath(accum, this.pkg.getName())).append("pkg-summary.html\">");
            this.out.append(seg);
            this.out.append("</a>");
        } else {
            this.out.append(seg);
        }
    }

    protected void renderImportSegment(String accum, String seg) {
        if (this.project.getNamedPackage(accum) != null) {
            this.out.append("<a href=\"").append(this.helper.getPackageRelPath(accum, this.pkg.getName())).append("pkg-summary.html\">");
            this.out.append(seg);
            this.out.append("</a>");
        } else {
            ClassInfo clazz = (ClassInfo)this.project.findClass(accum);
            if (clazz != null) {
                this.out.append("<a href=\"").append(this.helper.getRootRelPath(this.pkg.getName())).append(this.helper.getSrcFileLink(true, clazz)).append("\">");
                this.out.append(seg);
                this.out.append("</a>");
            } else {
                this.out.append(seg);
            }
        }
    }

    protected void renderIdentifier(String id) {
        ClassInfo cInfo = this.searchInScope(id);
        if (cInfo != null) {
            this.out.append("<a href=\"").append(this.helper.getRootRelPath(this.pkg.getName())).append(this.helper.getSrcFileLink(true, cInfo)).append("\">");
            this.out.append(id);
            this.out.append("</a>");
        } else {
            this.out.append(id);
        }
    }

    protected void renderNewLine() {
        this.newLine();
    }

    protected void endDocument() {
        if (this.out.length() > 0) {
            this.newLine();
        }
    }

    private void newLine() {
        LineRenderInfo thisLine = new LineRenderInfo();
        thisLine.src = this.out.toString();
        this.lineInfo.add(thisLine);
        this.out = new StringBuffer();
    }

    public static class LineRenderInfo {
        public boolean hilight;
        public ClassInfo classStart;
        public MethodInfo methodStart;
        public List testHits;
        public String coverageStr;
        public String msg;
        public String src;
        public String lineNumberCSS;
        public String coverageCountCSS;
        public String sourceCSS;
        public boolean filtered;
        public String testHitCSS = "";
        public StackTraceInfo.TraceEntry[] failedStackEntries;

        public boolean getHilight() {
            return this.hilight;
        }

        public String getCoverageStr() {
            return this.coverageStr;
        }

        public String getMsg() {
            return this.msg;
        }

        public ClassInfo getClassStart() {
            return this.classStart;
        }

        public MethodInfo getMethodStart() {
            return this.methodStart;
        }

        public StackTraceInfo.TraceEntry[] getFailedStackEntries() {
            return this.failedStackEntries;
        }

        public String getSrc() {
            return this.src;
        }

        public String getLineNumberCSS() {
            return this.lineNumberCSS;
        }

        public String getCoverageCountCSS() {
            return this.coverageCountCSS;
        }

        public String getSourceCSS() {
            return this.sourceCSS;
        }

        public String getTestHitCSS() {
            return this.testHitCSS;
        }

        public List getTestHits() {
            return this.testHits;
        }

        public boolean isFiltered() {
            return this.filtered;
        }
    }
}

