/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters;

import cloverantlr.CommonAST;
import cloverantlr.RecognitionException;
import cloverantlr.TokenStreamException;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.reporters.CalcLexer;
import com.cenqua.clover.reporters.CalcParser;
import com.cenqua.clover.reporters.CalcTreeWalker;
import java.io.ByteArrayInputStream;

public class ExpressionEvaluator {
    public static double eval(String expr, BlockMetrics metrics, String title) throws CloverException {
        CalcParser parser = ExpressionEvaluator.parse(expr, title);
        CommonAST t = (CommonAST)parser.getAST();
        if (Logger.isDebug()) {
            Logger.getInstance().debug(t.toStringTree());
        }
        CalcTreeWalker walker = new CalcTreeWalker();
        try {
            double r = walker.expr(t, metrics);
            Logger.getInstance().debug("expression result " + r);
            return r;
        }
        catch (RecognitionException e) {
            Logger.getInstance().debug(e.getMessage(), e);
            throw ExpressionEvaluator.wrapException(expr, e);
        }
    }

    public static CalcParser parse(String expr, String title) throws CloverException {
        ByteArrayInputStream in = new ByteArrayInputStream(expr.getBytes());
        CalcLexer lexer = new CalcLexer(in);
        lexer.setFilename(title);
        CalcParser parser = new CalcParser(lexer);
        parser.setFilename(title);
        try {
            parser.expr();
            return parser;
        }
        catch (RecognitionException e) {
            Logger.getInstance().debug(e.getMessage(), e);
            throw ExpressionEvaluator.wrapException(expr, e);
        }
        catch (TokenStreamException e) {
            Logger.getInstance().debug(e.getMessage(), e);
            throw ExpressionEvaluator.wrapException(expr, e);
        }
    }

    public static void validate(String expr, String title) throws CloverException {
        try {
            new CalcTreeWalker().validate(ExpressionEvaluator.parse(expr, title).getAST());
        }
        catch (RecognitionException e) {
            Logger.getInstance().debug(e.getMessage(), e);
            throw ExpressionEvaluator.wrapException(expr, e);
        }
    }

    private static CloverException wrapException(String expr, Exception e) {
        return new CloverException(e.getMessage() + " in expression '" + expr + "'", e);
    }
}

