/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextRegistry;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;

public class Clover2Registry {
    private static final long REG_MAGIC = -889258259L;
    private static final int REG_FORMAT_VERSION = 200;
    private static final int MODE_READWRITE = 0;
    private static final int MODE_READONLY = 1;
    private File registryFile;
    private ProjectInfo model;
    private PackageInfo currentPackage;
    private FileInfo currentFile;
    private LinkedList classStack = new LinkedList();
    private LinkedList methodStack = new LinkedList();
    private int dataLength = 0;
    private int currentGlobalIndex = 0;
    private int currentRelativeIndex = 0;
    private long version = 0L;
    private boolean readOnly = false;
    private String encoding;
    private ContextRegistry contexts;
    private InstrumentationInfo currentInstrInfo;
    private List instrumentationHistory;
    private CoverageData coverageData;
    private static final String READONLY_ERROR_MSG = "This database can only be used for reporting because it is the result of a merge. It does not support further coverage gathering.";

    public Clover2Registry(File registryFile, String name) {
        this(registryFile, new ProjectInfo(name), new ArrayList(), new ContextRegistry());
    }

    private Clover2Registry(File registryFile, ProjectInfo model, List instrumentationHistory, ContextRegistry contexts) {
        this.registryFile = registryFile;
        this.model = model;
        this.instrumentationHistory = instrumentationHistory;
        this.contexts = contexts;
        this.version = model.getVersion();
    }

    public static Clover2Registry fromInitString(String initstring, String name) throws IOException {
        File regFile = new File(initstring);
        Clover2Registry reg = Clover2Registry.fromFile(regFile);
        if (reg == null) {
            reg = new Clover2Registry(regFile, name);
        }
        return reg;
    }

    public static Clover2Registry fromFile(File registryFile) throws IOException {
        return Clover2Registry.fromFile(registryFile, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Clover2Registry fromFile(File registryFile, HasMetricsFilter filter) throws IOException {
        Clover2Registry clover2Registry;
        DataInputStream in;
        block11: {
            if (!registryFile.exists()) {
                return null;
            }
            in = null;
            ObjectInputStream cmp = null;
            String deserialisationErrorMsg = "Problem reading Clover database " + registryFile.getAbsolutePath() + ". This database is either corrupt or incompatible with this version of Clover. Please regenerate.";
            try {
                try {
                    in = new DataInputStream(new FileInputStream(registryFile));
                    Clover2Registry.readRegistryHeader(in);
                    boolean readOnly = Clover2Registry.readRegistryMode(in);
                    boolean containsData = in.readBoolean();
                    cmp = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(in)));
                    ProjectInfo model = (ProjectInfo)cmp.readObject();
                    if (filter != null) {
                        model = model.copy(filter);
                    }
                    List instrHistory = (List)cmp.readObject();
                    ContextRegistry contexts = (ContextRegistry)cmp.readObject();
                    Clover2Registry reg = new Clover2Registry(registryFile, model, instrHistory, contexts);
                    reg.setReadOnly(readOnly);
                    if (containsData) {
                        CoverageData data = (CoverageData)cmp.readObject();
                        reg.setCoverageData(data);
                    }
                    clover2Registry = reg;
                    Object var13_15 = null;
                    if (cmp == null) break block11;
                }
                catch (ZipException e) {
                    Logger.getInstance().debug("Exception deserializing " + registryFile.getAbsolutePath(), e);
                    throw new IOException(deserialisationErrorMsg);
                }
                catch (ObjectStreamException e) {
                    Logger.getInstance().debug("Exception deserializing " + registryFile.getAbsolutePath(), e);
                    throw new IOException(deserialisationErrorMsg);
                }
                catch (ClassNotFoundException e) {
                    Logger.getInstance().debug("Exception deserializing " + registryFile.getAbsolutePath(), e);
                    throw new IOException(deserialisationErrorMsg);
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (cmp != null) {
                    cmp.close();
                    throw throwable;
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            cmp.close();
            return clover2Registry;
        }
        if (in == null) return clover2Registry;
        in.close();
        return clover2Registry;
    }

    public static Clover2Registry createOrLoad(File registryFile, String projectName) throws IOException {
        Clover2Registry registry;
        if (registryFile.exists()) {
            Logger.getInstance().info("Updating existing database at '" + registryFile + "'.");
            registry = Clover2Registry.fromFile(registryFile);
        } else {
            Logger.getInstance().info("Creating new database at '" + registryFile + "'.");
            File parentDir = registryFile.getParentFile();
            if (parentDir != null) {
                boolean dirCreated = parentDir.mkdirs();
            }
            registry = new Clover2Registry(registryFile, projectName);
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readRegistryHeaderAndModeOnly(File registryFile) throws IOException {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(registryFile));
            int length = Clover2Registry.readRegistryHeader((DataInput)((Object)in));
            boolean readOnly = Clover2Registry.readRegistryMode((DataInput)((Object)in));
            if (readOnly) {
                throw new IOException(READONLY_ERROR_MSG);
            }
            int n = length;
            return n;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static int readRegistryHeader(DataInput in) throws IOException {
        if (-889258259L != in.readLong()) {
            throw new IOException("Not a valid Clover database file. Please regenerate.");
        }
        if (200 != in.readInt()) {
            throw new IOException("Not a valid Clover database file. Please regenerate.");
        }
        return in.readInt();
    }

    private static boolean readRegistryMode(DataInput in) throws IOException {
        return 1 == in.readInt();
    }

    private void writeRegistryHeader(DataOutput out) throws IOException {
        out.writeLong(-889258259L);
        out.writeInt(200);
        out.writeInt(this.dataLength);
        out.writeInt(this.readOnly ? 1 : 0);
        out.writeBoolean(this.readOnly && this.coverageData != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException {
        File tmpfile;
        block14: {
            DataOutputStream out;
            block12: {
                tmpfile = new File(this.registryFile.getParentFile(), this.registryFile.getName() + ".tmp");
                out = null;
                ObjectOutputStream cmp = null;
                try {
                    tmpfile.delete();
                    out = new DataOutputStream(new FileOutputStream(tmpfile));
                    this.writeRegistryHeader(out);
                    cmp = new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(out)));
                    cmp.writeObject(this.model);
                    cmp.writeObject(this.instrumentationHistory);
                    cmp.writeObject(this.contexts);
                    if (this.isReadOnly() && this.coverageData != null) {
                        cmp.writeObject(this.coverageData);
                    }
                    Object var5_4 = null;
                    if (cmp == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (cmp != null) {
                        cmp.close();
                    } else if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                cmp.close();
                break block14;
            }
            if (out != null) {
                out.close();
            }
        }
        try {
            if (this.registryFile.exists() && !this.registryFile.delete()) {
                throw new IOException("Can't delete existing registry file " + this.registryFile);
            }
            if (!tmpfile.renameTo(this.registryFile)) {
                throw new IOException("Problem moving tmp file " + tmpfile + " to registry file");
            }
            this.registryFile.setLastModified(this.version);
        }
        finally {
            tmpfile.delete();
        }
    }

    public File getRegistryFile() {
        return this.registryFile;
    }

    public String getProjectName() {
        return this.model.getName();
    }

    public void setProjectName(String name) {
        this.model.setName(name);
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
        this.model.setVersion(version);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setCoverageData(CoverageData data) {
        this.coverageData = data;
    }

    public CoverageData getCoverageData() {
        return this.coverageData;
    }

    public boolean isOutOfDate() {
        return this.registryFile.lastModified() == 0L || FileUtils.compareLastModified(this.version, this.registryFile) < 0;
    }

    public void startInstr() throws CloverException {
        if (this.isReadOnly()) {
            throw new CloverException(READONLY_ERROR_MSG);
        }
        this.currentGlobalIndex = 0;
        this.dataLength = this.model.getDataLength();
        this.setVersion(System.currentTimeMillis());
        this.currentInstrInfo = new InstrumentationInfo(System.currentTimeMillis());
    }

    public void endInstr() {
        if (this.currentPackage != null) {
            this.exitPackage(this.currentPackage);
        }
        this.model.setDataLength(this.dataLength);
        this.currentInstrInfo.setEndTS(System.currentTimeMillis());
        this.instrumentationHistory.add(this.currentInstrInfo);
    }

    public void enterSubProject(String name) {
    }

    public void exitSubProject() {
    }

    public int getCurrentIndex() {
        return this.currentGlobalIndex;
    }

    public FileInfo enterFile(String pkg, File file, int lineCount, int ncLineCount, long timestamp, long filesize, long checksum) {
        this.currentInstrInfo.incNumFiles();
        this.currentRelativeIndex = 0;
        this.enterPackage(pkg);
        FileInfo finfo = (FileInfo)this.currentPackage.getFileInPackage(file.getName());
        Set prevDbVersions = Collections.EMPTY_SET;
        if (finfo != null) {
            if (finfo.getChecksum() == checksum && finfo.getFilesize() == filesize) {
                this.currentGlobalIndex = finfo.getDataIndex();
                prevDbVersions = finfo.getVersions();
            } else {
                this.currentGlobalIndex = this.dataLength;
            }
        } else {
            this.currentGlobalIndex = this.dataLength;
        }
        finfo = new FileInfo(this.currentPackage, file, this.encoding, this.currentGlobalIndex, lineCount, ncLineCount, timestamp, filesize, checksum);
        finfo.addVersions(prevDbVersions);
        finfo.addVersion(this.getVersion());
        this.currentFile = finfo;
        this.currentPackage.addFile(finfo);
        return finfo;
    }

    public void exitFile() {
        this.currentGlobalIndex += this.currentRelativeIndex;
        this.currentFile.setDataLength(this.currentGlobalIndex - this.currentFile.getDataIndex());
        this.dataLength = Math.max(this.dataLength, this.currentGlobalIndex);
    }

    public ClassInfo enterClass(String name, SourceRegion region, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        ClassInfo clazz = new ClassInfo(this.currentPackage, this.currentFile, this.currentRelativeIndex, name, region, typeInterface, typeEnum, typeAnnotation);
        this.currentFile.addClass(clazz);
        this.pushCurrentClass(clazz);
        return clazz;
    }

    public ClassInfo exitClass(int endLine, int endCol) {
        ClassInfo clazz = this.popCurrentClass();
        clazz.setEndLine(endLine);
        clazz.setEndColumn(endCol);
        clazz.setDataLength(this.currentRelativeIndex - clazz.getRelativeDataIndex());
        return this.getCurrentClass();
    }

    public MethodInfo enterMethod(ContextSet context, SourceRegion region, MethodSignature signature, boolean test) {
        ClassInfo currentClass = this.getCurrentClass();
        MethodInfo method = new MethodInfo(currentClass, this.currentRelativeIndex, context, region, signature, test);
        this.currentRelativeIndex += method.getDataLength();
        currentClass.addMethod(method);
        this.pushCurrentMethod(method);
        return method;
    }

    public void exitMethod(int endLine, int endCol) {
        MethodInfo method = this.popCurrentMethod();
        method.setEndLine(endLine);
        method.setEndColumn(endCol);
        method.setDataLength(this.currentRelativeIndex - method.getRelativeDataIndex());
    }

    public StatementInfo addStatement(ContextSet context, SourceRegion region, int complexity) {
        MethodInfo currentMethod = this.getCurrentMethod();
        StatementInfo stmt = new StatementInfo(currentMethod, this.currentRelativeIndex, context, region, complexity);
        this.currentRelativeIndex += stmt.getDataLength();
        currentMethod.addStatement(stmt);
        return stmt;
    }

    public BranchInfo addBranch(ContextSet context, SourceRegion region, int complexity, boolean instrumented) {
        MethodInfo currentMethod = this.getCurrentMethod();
        BranchInfo branch = null;
        if (currentMethod != null) {
            branch = new BranchInfo(currentMethod, this.currentRelativeIndex, context, region, complexity, instrumented);
            this.currentRelativeIndex += branch.getDataLength();
            currentMethod.addBranch(branch);
        }
        return branch;
    }

    public ProjectInfo getModel() {
        return this.model;
    }

    public List getInstrHistory() {
        return this.instrumentationHistory;
    }

    public ContextRegistry getContextRegistry() {
        return this.contexts;
    }

    public void setContextRegistry(ContextRegistry contexts) {
        this.contexts = contexts;
    }

    public void setCurrentEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getInitString() {
        return this.registryFile.getAbsolutePath();
    }

    private PackageInfo enterPackage(String name) {
        PackageInfo pkg;
        if (this.currentPackage != null) {
            if (this.currentPackage.getName().equals(name)) {
                return this.currentPackage;
            }
            this.exitPackage(this.currentPackage);
        }
        if ((pkg = (PackageInfo)this.model.getNamedPackage(name)) == null) {
            pkg = new PackageInfo(this.model, name, this.currentGlobalIndex);
            this.model.addPackage(pkg);
        }
        this.currentPackage = pkg;
        return this.currentPackage;
    }

    private void exitPackage(PackageInfo pkg) {
        pkg.setDataLength(this.currentGlobalIndex - pkg.getDataIndex());
    }

    private ClassInfo getCurrentClass() {
        if (this.classStack.size() > 0) {
            return (ClassInfo)this.classStack.getLast();
        }
        return null;
    }

    private void pushCurrentClass(ClassInfo clazz) {
        this.classStack.add(clazz);
    }

    private ClassInfo popCurrentClass() {
        if (this.classStack.size() > 0) {
            return (ClassInfo)this.classStack.removeLast();
        }
        return null;
    }

    private MethodInfo getCurrentMethod() {
        if (this.methodStack.size() > 0) {
            return (MethodInfo)this.methodStack.getLast();
        }
        return null;
    }

    private void pushCurrentMethod(MethodInfo clazz) {
        this.methodStack.add(clazz);
    }

    private MethodInfo popCurrentMethod() {
        if (this.methodStack.size() > 0) {
            return (MethodInfo)this.methodStack.removeLast();
        }
        return null;
    }

    public static class InstrumentationInfo
    implements Serializable {
        static final long serialVersionUID = -7699262701616121133L;
        private long startTS = 0L;
        private long endTS = 0L;
        private int numFiles = 0;

        public InstrumentationInfo(long startTS) {
            this.startTS = startTS;
        }

        public long getStartTS() {
            return this.startTS;
        }

        public void setStartTS(long startTS) {
            this.startTS = startTS;
        }

        public long getEndTS() {
            return this.endTS;
        }

        public void setEndTS(long endTS) {
            this.endTS = endTS;
        }

        public int getNumFiles() {
            return this.numFiles;
        }

        public void setNumFiles(int numFiles) {
            this.numFiles = numFiles;
        }

        public void incNumFiles() {
            ++this.numFiles;
        }
    }
}

