/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.CoverageRecording;
import com.cenqua.clover.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RecordingFile
implements Comparable {
    private boolean slice = false;
    private boolean startSlice = false;
    private boolean endSlice = false;
    private long typedSliceId = -1L;
    private long hash;
    private long timestamp;
    private File datafile;
    private static final String NUM_R36 = "([0-9a-z]+)";
    private static final String STD_REC_SUFFIX = "([0-9a-z]+)_([0-9a-z]+)";
    private static final String SLICE_SUFFIX = "([0-9a-z]+)_(X|Y)([0-9a-z]+)_([0-9a-z]+)";
    private static Pattern stdRecordingSuffix = Pattern.compile("([0-9a-z]+)_([0-9a-z]+)");
    private static Pattern sliceRecordingSuffix = Pattern.compile("([0-9a-z]+)_(X|Y)([0-9a-z]+)_([0-9a-z]+)");

    public static RecordingFile fromFile(File dir, String filename, String dbname) {
        int baselength = dbname.length();
        try {
            if (filename.startsWith(dbname) && filename.length() > baselength) {
                int tsMarker = filename.lastIndexOf("_");
                if (tsMarker < baselength || tsMarker == filename.length() - 1 || filename.endsWith(".1")) {
                    return null;
                }
                RecordingFile recfile = new RecordingFile();
                String suffix = filename.substring(baselength);
                Matcher m = sliceRecordingSuffix.matcher(suffix);
                recfile.datafile = new File(dir, filename);
                if (m.matches()) {
                    recfile.slice = true;
                    recfile.typedSliceId = Long.parseLong(m.group(1), 36);
                    if ("X".equals(m.group(2))) {
                        recfile.startSlice = true;
                    } else {
                        recfile.endSlice = true;
                    }
                    recfile.hash = Long.parseLong(m.group(3), 36);
                    recfile.timestamp = Long.parseLong(m.group(4), 36);
                    return recfile;
                }
                m = stdRecordingSuffix.matcher(suffix);
                if (m.matches()) {
                    recfile.hash = Long.parseLong(m.group(1), 36);
                    recfile.timestamp = Long.parseLong(m.group(2), 36);
                    return recfile;
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return null;
    }

    public CoverageRecording readData(CoverageDataSpec spec) throws IOException {
        return CoverageRecording.readFromDisk(this.getDatafile().getParentFile(), this.getDatafile().getName(), spec);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RecordingFile other = (RecordingFile)object;
        if (this.endSlice != other.endSlice) {
            return false;
        }
        if (this.hash != other.hash) {
            return false;
        }
        if (this.slice != other.slice) {
            return false;
        }
        if (this.startSlice != other.startSlice) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.typedSliceId != other.typedSliceId) {
            return false;
        }
        return this.datafile.equals(other.datafile);
    }

    public int hashCode() {
        int result = this.slice ? 1 : 0;
        result = 31 * result + (this.startSlice ? 1 : 0);
        result = 31 * result + (this.endSlice ? 1 : 0);
        result = 31 * result + (int)(this.typedSliceId ^ this.typedSliceId >>> 32);
        result = 31 * result + (int)(this.hash ^ this.hash >>> 32);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.datafile.hashCode();
        return result;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return 1;
        }
        RecordingFile other = (RecordingFile)object;
        if (this.datafile.compareTo(other.datafile) != 0) {
            return this.datafile.compareTo(other.datafile);
        }
        if (this.timestamp > other.timestamp) {
            return 1;
        }
        if (this.timestamp < other.timestamp) {
            return -1;
        }
        if (this.hash > other.hash) {
            return 1;
        }
        if (this.hash < other.hash) {
            return -1;
        }
        if (this.slice != other.slice) {
            return this.slice ? 1 : -1;
        }
        if (this.typedSliceId > other.typedSliceId) {
            return 1;
        }
        if (this.typedSliceId < other.typedSliceId) {
            return -1;
        }
        if (this.endSlice != other.endSlice) {
            return this.endSlice ? 1 : -1;
        }
        if (this.startSlice != other.startSlice) {
            return this.startSlice ? 1 : -1;
        }
        return 0;
    }

    public boolean isSlice() {
        return this.slice;
    }

    public boolean isStartSlice() {
        return this.startSlice;
    }

    public boolean isEndSlice() {
        return this.endSlice;
    }

    public long getTypedSliceId() {
        return this.typedSliceId;
    }

    public int getSliceId() {
        return (int)this.typedSliceId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public File getDatafile() {
        return this.datafile;
    }

    public long getHash() {
        return this.hash;
    }

    public static class RecordingFileFilter
    implements FilenameFilter {
        private String basename;
        private long from;
        private long to;
        private Map incompleteSliceData = new HashMap();
        private Map slicePairs = new HashMap();
        private List recordingFiles = new LinkedList();

        public RecordingFileFilter(String basename) {
            this(basename, 0L, Long.MAX_VALUE);
        }

        public RecordingFileFilter(String basename, long from, long to) {
            this.basename = basename;
            this.from = from;
            this.to = to;
        }

        public void processDir(File dir) {
            dir.list(this);
            this.incompleteSliceData.clear();
        }

        public Map getSlicePairs() {
            return this.slicePairs;
        }

        public List getMatchingRecordingFiles() {
            return this.recordingFiles;
        }

        public boolean accept(File d, String name) {
            RecordingFile recfile = RecordingFile.fromFile(d, name, this.basename);
            if (recfile != null) {
                if (recfile.getTimestamp() >= this.from && recfile.getTimestamp() <= this.to) {
                    if (recfile.isSlice()) {
                        String key = recfile.getTypedSliceId() + ":" + recfile.getHash() + ":" + recfile.getTimestamp();
                        SliceFilePair pair = (SliceFilePair)this.incompleteSliceData.get(key);
                        if (pair == null) {
                            pair = new SliceFilePair();
                            pair.id = recfile.getTypedSliceId();
                            pair.hash = recfile.getHash();
                            pair.timestamp = recfile.getTimestamp();
                            this.incompleteSliceData.put(key, pair);
                        }
                        if (recfile.isStartSlice()) {
                            pair.start = recfile;
                        } else {
                            pair.end = recfile;
                        }
                        if (pair.start != null && pair.end != null) {
                            LinkedList<SliceFilePair> pairsForId = (LinkedList<SliceFilePair>)this.slicePairs.get(new Long(pair.id));
                            if (pairsForId == null) {
                                pairsForId = new LinkedList<SliceFilePair>();
                                this.slicePairs.put(new Long(pair.id), pairsForId);
                            }
                            pairsForId.add(pair);
                            this.incompleteSliceData.remove(key);
                        }
                    } else {
                        this.recordingFiles.add(recfile);
                    }
                    return true;
                }
                Logger.getInstance().debug("ignoring out of date coverage recording file: " + name + ", timestamp " + (this.to < Long.MAX_VALUE ? "not in range " + this.from + "-" + this.to : "< " + this.from));
            }
            return false;
        }

        public long getFrom() {
            return this.from;
        }

        public long getTo() {
            return this.to;
        }
    }

    public static class SliceFilePair {
        public long id;
        public long hash;
        public long timestamp;
        public RecordingFile start;
        public RecordingFile end;
    }
}

