/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import clover.it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import clover.it.unimi.dsi.fastutil.floats.FloatCollection;
import clover.it.unimi.dsi.fastutil.floats.FloatIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import clover.it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractReference2FloatMap
implements Reference2FloatMap,
Serializable {
    protected float defRetValue;

    protected AbstractReference2FloatMap() {
    }

    public void setDefRetValue(float rv) {
        this.defaultReturnValue(rv);
    }

    public float getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(float rv) {
        this.defRetValue = rv;
    }

    public float defaultReturnValue() {
        return this.defRetValue;
    }

    public float put(Object key, float value) {
        throw new UnsupportedOperationException();
    }

    public float removeFloat(Object key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        Object k = ok;
        return this.containsKey(k) ? new Float(this.getFloat(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        Object k = ok;
        float v = this.put(k, ((Float)ov).floatValue());
        return this.containsKey(k) ? new Float(v) : null;
    }

    public Object remove(Object ok) {
        Object k = ok;
        float v = this.removeFloat(k);
        return this.containsKey(k) ? new Float(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue(((Float)ov).floatValue());
    }

    public boolean containsValue(float v) {
        return ((FloatCollection)this.values()).contains(v);
    }

    public boolean containsKey(Object k) {
        return ((ReferenceSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Reference2FloatMap) {
            while (n-- != 0) {
                Reference2FloatMap.Entry e = (Reference2FloatMap.Entry)i.next();
                this.put(e.getKey(), e.getFloatValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractReferenceSet(){

            public boolean contains(Object k) {
                return AbstractReference2FloatMap.this.containsKey(k);
            }

            public int size() {
                return AbstractReference2FloatMap.this.size();
            }

            public ObjectIterator objectIterator() {
                return new AbstractObjectIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractReference2FloatMap.this.entrySet().iterator();
                    }

                    public Object next() {
                        return ((Reference2FloatMap.Entry)this.i.next()).getKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractFloatCollection(){

            public boolean contains(float k) {
                return AbstractReference2FloatMap.this.containsValue(k);
            }

            public int size() {
                return AbstractReference2FloatMap.this.size();
            }

            public FloatIterator floatIterator() {
                return new AbstractFloatIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractReference2FloatMap.this.entrySet().iterator();
                    }

                    public float nextFloat() {
                        return ((Reference2FloatMap.Entry)this.i.next()).getFloatValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean bl = true;
        s.append("{");
        while (n-- != 0) {
            if (bl) {
                bl = false;
            } else {
                s.append(", ");
            }
            Reference2FloatMap.Entry first = (Reference2FloatMap.Entry)i.next();
            if (this == first.getKey()) {
                s.append("(this map)");
            } else {
                s.append(String.valueOf(first.getKey()));
            }
            s.append("=>");
            s.append(String.valueOf(first.getFloatValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Reference2FloatMap.Entry {
        protected Object key;
        protected float value;

        public BasicEntry(Object key, Object value) {
            this.key = key;
            this.value = ((Float)value).floatValue();
        }

        public BasicEntry(Object key, float value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return new Float(this.value);
        }

        public float getFloatValue() {
            return this.value;
        }

        public float setValue(float value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Float(this.setValue(((Float)value).floatValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == e.getKey() && this.value == ((Float)e.getValue()).floatValue();
        }

        public int hashCode() {
            return System.identityHashCode(this.key) ^ HashCommon.float2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

