/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongListIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import clover.it.unimi.dsi.fastutil.longs.LongArrays;
import clover.it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.longs.LongCollection;
import clover.it.unimi.dsi.fastutil.longs.LongComparator;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongIterators;
import clover.it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class LongRBTreeSet
extends AbstractLongSortedSet
implements Serializable,
Cloneable,
LongSortedSet {
    protected transient Entry tree;
    protected int count;
    protected transient Entry firstEntry;
    protected transient Entry lastEntry;
    protected Comparator storedComparator;
    protected transient LongComparator actualComparator;
    public static final long serialVersionUID = -7046029254386353130L;
    private static final boolean ASSERTS = false;
    private transient boolean[] dirPath;
    private transient Entry[] nodePath;

    public LongRBTreeSet() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = this.storedComparator == null || this.storedComparator instanceof LongComparator ? (LongComparator)this.storedComparator : new LongComparator(){

            public int compare(long k1, long k2) {
                return LongRBTreeSet.this.storedComparator.compare(new Long(k1), new Long(k2));
            }

            public int compare(Object ok1, Object ok2) {
                return LongRBTreeSet.this.storedComparator.compare(ok1, ok2);
            }
        };
    }

    public LongRBTreeSet(Comparator c) {
        this();
        this.storedComparator = c;
        this.setActualComparator();
    }

    public LongRBTreeSet(Collection c) {
        this();
        this.addAll(c);
    }

    public LongRBTreeSet(SortedSet s) {
        this(s.comparator());
        this.addAll((Collection)s);
    }

    public LongRBTreeSet(LongCollection c) {
        this();
        this.addAll(c);
    }

    public LongRBTreeSet(LongSortedSet s) {
        this(s.comparator());
        this.addAll(s);
    }

    public LongRBTreeSet(LongIterator i) {
        this.allocatePaths();
        while (i.hasNext()) {
            this.add(i.nextLong());
        }
    }

    public LongRBTreeSet(Iterator i) {
        this(LongIterators.asLongIterator(i));
    }

    public LongRBTreeSet(long[] a, int offset, int length, Comparator c) {
        this(c);
        LongArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public LongRBTreeSet(long[] a, int offset, int length) {
        this(a, offset, length, null);
    }

    public LongRBTreeSet(long[] a) {
        this();
        int i = a.length;
        while (i-- != 0) {
            this.add(a[i]);
        }
    }

    public LongRBTreeSet(long[] a, Comparator c) {
        this(c);
        int i = a.length;
        while (i-- != 0) {
            this.add(a[i]);
        }
    }

    final int compare(long k1, long k2) {
        return this.actualComparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.actualComparator.compare(k1, k2);
    }

    private Entry findKey(long k) {
        int cmp;
        Entry e = this.tree;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            e = cmp < 0 ? e.left() : e.right();
        }
        return e;
    }

    final Entry locateKey(long k) {
        Entry e = this.tree;
        Entry last = this.tree;
        int cmp = 0;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            last = e;
            e = cmp < 0 ? e.left() : e.right();
        }
        return cmp == 0 ? e : last;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[64];
        this.nodePath = new Entry[64];
    }

    /*
     * WARNING - void declaration
     */
    public boolean add(long k) {
        if (this.tree == null) {
            ++this.count;
            this.lastEntry = this.firstEntry = new Entry(k);
            this.tree = this.firstEntry;
        } else {
            void e;
            Entry p = this.tree;
            int n = 0;
            while (true) {
                Entry i;
                int cmp;
                if ((cmp = this.compare(k, p.key)) == 0) {
                    return false;
                }
                this.nodePath[n] = p;
                this.dirPath[n++] = cmp > 0;
                if (this.dirPath[n++]) {
                    if (p.succ()) {
                        ++this.count;
                        i = new Entry(k);
                        if (p.right == null) {
                            this.lastEntry = i;
                        }
                        i.left = p;
                        i.right = p.right;
                        p.right(i);
                        break;
                    }
                    p = p.right;
                    continue;
                }
                if (p.pred()) {
                    ++this.count;
                    i = new Entry(k);
                    if (p.left == null) {
                        this.firstEntry = i;
                    }
                    i.right = p;
                    i.left = p.left;
                    p.left(i);
                    break;
                }
                p = p.left;
            }
            --e;
            while (e > 0 && !this.nodePath[e].black()) {
                Entry x;
                Entry y;
                if (!this.dirPath[e - true]) {
                    Entry x2;
                    y = this.nodePath[e - true].right;
                    if (!this.nodePath[e - true].succ() && !y.black()) {
                        this.nodePath[e].black(true);
                        y.black(true);
                        this.nodePath[e - true].black(false);
                        e -= 2;
                        continue;
                    }
                    if (!this.dirPath[e]) {
                        y = this.nodePath[e];
                    } else {
                        x2 = this.nodePath[e];
                        y = x2.right;
                        x2.right = y.left;
                        y.left = x2;
                        this.nodePath[e - true].left = y;
                        if (y.pred()) {
                            y.pred(false);
                            x2.succ(y);
                        }
                    }
                    x2 = this.nodePath[e - true];
                    x2.black(false);
                    y.black(true);
                    x2.left = y.right;
                    y.right = x2;
                    if (e < 2) {
                        this.tree = y;
                    } else if (this.dirPath[e - 2]) {
                        this.nodePath[e - 2].right = y;
                    } else {
                        this.nodePath[e - 2].left = y;
                    }
                    if (!y.succ()) break;
                    y.succ(false);
                    x2.pred(y);
                    break;
                }
                y = this.nodePath[e - true].left;
                if (!this.nodePath[e - true].pred() && !y.black()) {
                    this.nodePath[e].black(true);
                    y.black(true);
                    this.nodePath[e - true].black(false);
                    e -= 2;
                    continue;
                }
                if (this.dirPath[e]) {
                    y = this.nodePath[e];
                } else {
                    x = this.nodePath[e];
                    y = x.left;
                    x.left = y.right;
                    y.right = x;
                    this.nodePath[e - true].right = y;
                    if (y.succ()) {
                        y.succ(false);
                        x.pred(y);
                    }
                }
                x = this.nodePath[e - true];
                x.black(false);
                y.black(true);
                x.right = y.left;
                y.left = x;
                if (e < 2) {
                    this.tree = y;
                } else if (this.dirPath[e - 2]) {
                    this.nodePath[e - 2].right = y;
                } else {
                    this.nodePath[e - 2].left = y;
                }
                if (!y.pred()) break;
                y.pred(false);
                x.succ(y);
                break;
            }
        }
        this.tree.black(true);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean remove(long k) {
        void cmp;
        Entry p;
        block59: {
            void s;
            Entry j;
            boolean r;
            block65: {
                block60: {
                    Entry color;
                    block64: {
                        block62: {
                            block63: {
                                block57: {
                                    block58: {
                                        if (this.tree == null) {
                                            return false;
                                        }
                                        p = this.tree;
                                        boolean bl = false;
                                        do {
                                            int i;
                                            if ((i = this.compare(k, p.key)) == 0) {
                                                if (p.left != null) break block57;
                                                break block58;
                                            }
                                            this.dirPath[cmp] = i > 0;
                                            this.nodePath[cmp] = p;
                                        } while (!(this.dirPath[++cmp] ? (p = p.right()) == null : (p = p.left()) == null));
                                        return false;
                                    }
                                    this.firstEntry = p.next();
                                }
                                if (p.right == null) {
                                    this.lastEntry = p.prev();
                                }
                                if (!p.succ()) break block62;
                                if (!p.pred()) break block63;
                                if (cmp == false) {
                                    this.tree = p.left;
                                    break block59;
                                } else if (this.dirPath[cmp - true]) {
                                    this.nodePath[cmp - true].succ(p.right);
                                    break block59;
                                } else {
                                    this.nodePath[cmp - true].pred(p.left);
                                }
                                break block59;
                            }
                            p.prev().right = p.right;
                            if (cmp == false) {
                                this.tree = p.left;
                                break block59;
                            } else if (this.dirPath[cmp - true]) {
                                this.nodePath[cmp - true].right = p.left;
                                break block59;
                            } else {
                                this.nodePath[cmp - true].left = p.left;
                            }
                            break block59;
                        }
                        Entry entry = p.right;
                        if (!entry.pred()) break block64;
                        entry.left = p.left;
                        entry.pred(p.pred());
                        if (!entry.pred()) {
                            entry.prev().right = entry;
                        }
                        if (cmp == false) {
                            this.tree = entry;
                        } else if (this.dirPath[cmp - true]) {
                            this.nodePath[cmp - true].right = entry;
                        } else {
                            this.nodePath[cmp - true].left = entry;
                        }
                        r = entry.black();
                        color.black(p.black());
                        p.black(r);
                        this.dirPath[cmp] = true;
                        this.nodePath[cmp++] = color;
                        break block59;
                    }
                    void var8_9 = cmp++;
                    while (true) {
                        this.dirPath[cmp] = false;
                        this.nodePath[cmp++] = color;
                        j = color.left;
                        if (j.pred()) {
                            this.dirPath[s] = true;
                            this.nodePath[s] = j;
                            if (j.succ()) {
                                break;
                            }
                            break block60;
                        }
                        color = j;
                    }
                    color.pred(j);
                    break block65;
                }
                color.left = j.right;
            }
            j.left = p.left;
            if (!p.pred()) {
                p.prev().right = j;
                j.pred(false);
            }
            j.right(p.right);
            r = j.black();
            j.black(p.black());
            p.black(r);
            if (s == false) {
                this.tree = j;
            } else if (this.dirPath[s - true]) {
                this.nodePath[s - true].right = j;
            } else {
                this.nodePath[s - true].left = j;
            }
        }
        if (p.black()) {
            while (cmp > 0) {
                block61: {
                    Entry y;
                    Entry w;
                    if (this.dirPath[cmp - true] && !this.nodePath[cmp - true].succ() || !this.dirPath[cmp - true] && !this.nodePath[cmp - true].pred()) {
                        Entry r;
                        Entry entry = r = this.dirPath[cmp - true] ? this.nodePath[cmp - true].right : this.nodePath[cmp - true].left;
                        if (!r.black()) {
                            r.black(true);
                            break;
                        }
                    }
                    if (!this.dirPath[cmp - true]) {
                        Entry r = this.nodePath[cmp - true].right;
                        if (!r.black()) {
                            r.black(true);
                            this.nodePath[cmp - true].black(false);
                            this.nodePath[cmp - true].right = r.left;
                            r.left = this.nodePath[cmp - true];
                            if (cmp < 2) {
                                this.tree = r;
                            } else if (this.dirPath[cmp - 2]) {
                                this.nodePath[cmp - 2].right = r;
                            } else {
                                this.nodePath[cmp - 2].left = r;
                            }
                            this.nodePath[cmp] = this.nodePath[cmp - true];
                            this.dirPath[cmp] = false;
                            this.nodePath[cmp - true] = r;
                            r = this.nodePath[++cmp - true].right;
                        }
                        if ((r.pred() || r.left.black()) && (r.succ() || r.right.black())) {
                            r.black(false);
                            break block61;
                        } else {
                            if (r.succ() || r.right.black()) {
                                w = r.left;
                                w.black(true);
                                y.black(false);
                                y.left = w.right;
                                w.right = y;
                                y = this.nodePath[cmp - true].right = w;
                                if (y.succ()) {
                                    y.succ(false);
                                    y.right.pred(y);
                                }
                            }
                            y.black(this.nodePath[cmp - true].black());
                            this.nodePath[cmp - true].black(true);
                            y.right.black(true);
                            this.nodePath[cmp - true].right = y.left;
                            y.left = this.nodePath[cmp - true];
                            if (cmp < 2) {
                                this.tree = y;
                            } else if (this.dirPath[cmp - 2]) {
                                this.nodePath[cmp - 2].right = y;
                            } else {
                                this.nodePath[cmp - 2].left = y;
                            }
                            if (!y.pred()) break;
                            y.pred(false);
                            this.nodePath[cmp - true].succ(y);
                            break;
                        }
                    }
                    y = this.nodePath[cmp - true].left;
                    if (!y.black()) {
                        y.black(true);
                        this.nodePath[cmp - true].black(false);
                        this.nodePath[cmp - true].left = y.right;
                        y.right = this.nodePath[cmp - true];
                        if (cmp < 2) {
                            this.tree = y;
                        } else if (this.dirPath[cmp - 2]) {
                            this.nodePath[cmp - 2].right = y;
                        } else {
                            this.nodePath[cmp - 2].left = y;
                        }
                        this.nodePath[cmp] = this.nodePath[cmp - true];
                        this.dirPath[cmp] = true;
                        this.nodePath[cmp - true] = y;
                        y = this.nodePath[++cmp - true].left;
                    }
                    if ((y.pred() || y.left.black()) && (y.succ() || y.right.black())) {
                        y.black(false);
                    } else {
                        void var7_8;
                        if (y.pred() || y.left.black()) {
                            w = y.right;
                            w.black(true);
                            y.black(false);
                            y.right = w.left;
                            w.left = y;
                            y = this.nodePath[cmp - true].left = w;
                            if (y.pred()) {
                                y.pred(false);
                                y.left.succ(y);
                            }
                        }
                        var7_8.black(this.nodePath[cmp - true].black());
                        this.nodePath[cmp - true].black(true);
                        var7_8.left.black(true);
                        this.nodePath[cmp - true].left = var7_8.right;
                        var7_8.right = this.nodePath[cmp - true];
                        if (cmp < 2) {
                            this.tree = var7_8;
                        } else if (this.dirPath[cmp - 2]) {
                            this.nodePath[cmp - 2].right = var7_8;
                        } else {
                            this.nodePath[cmp - 2].left = var7_8;
                        }
                        if (!var7_8.succ()) break;
                        var7_8.succ(false);
                        this.nodePath[cmp - true].pred((Entry)var7_8);
                        break;
                    }
                }
                --cmp;
            }
            if (this.tree != null) {
                this.tree.black(true);
            }
        }
        --this.count;
        return true;
    }

    public boolean contains(long k) {
        return this.findKey(k) != null;
    }

    public void clear() {
        this.count = 0;
        this.tree = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public long firstLong() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    public long lastLong() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    public LongIterator longIterator() {
        return new SetIterator();
    }

    public LongBidirectionalIterator iterator(long from) {
        return new SetIterator(from);
    }

    public Comparator comparator() {
        return this.storedComparator;
    }

    public LongSortedSet headSet(long to) {
        return new Subset(0L, true, to, false);
    }

    public LongSortedSet tailSet(long from) {
        return new Subset(from, false, 0L, true);
    }

    public LongSortedSet subSet(long from, long to) {
        return new Subset(from, false, to, false);
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        LongRBTreeSet c;
        try {
            c = (LongRBTreeSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.allocatePaths();
        if (this.count != 0) {
            void q;
            void p;
            Entry entry = new Entry();
            Entry entry2 = new Entry();
            Entry rp = entry;
            p.left(this.tree);
            Entry rq = entry2;
            q.pred(null);
            while (true) {
                Entry e;
                if (!rp.pred()) {
                    e = (Entry)rp.left.clone();
                    e.pred(rq.left);
                    e.succ(rq);
                    rq.left(e);
                    rp = rp.left;
                    rq = rq.left;
                } else {
                    while (rp.succ()) {
                        rp = rp.right;
                        if (rp == null) {
                            rq.right = null;
                            c.firstEntry = c.tree = q.left;
                            while (c.firstEntry.left != null) {
                                c.firstEntry = c.firstEntry.left;
                            }
                            c.lastEntry = c.tree;
                            while (c.lastEntry.right != null) {
                                c.lastEntry = c.lastEntry.right;
                            }
                            return c;
                        }
                        rq = rq.right;
                    }
                    rp = rp.right;
                    rq = rq.right;
                }
                if (rp.succ()) continue;
                e = (Entry)rp.right.clone();
                e.succ(rq.right);
                e.pred(rq);
                rq.right(e);
            }
        }
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int n = this.count;
        SetIterator i = new SetIterator();
        s.defaultWriteObject();
        while (n-- != 0) {
            s.writeLong(i.nextLong());
        }
    }

    private Entry readTree(ObjectInputStream s, int n, Entry pred, Entry succ) throws IOException, ClassNotFoundException {
        if (n == 1) {
            Entry top = new Entry(s.readLong());
            top.pred(pred);
            top.succ(succ);
            top.black(true);
            return top;
        }
        if (n == 2) {
            Entry top = new Entry(s.readLong());
            top.black(true);
            top.right(new Entry(s.readLong()));
            top.right.pred(top);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n / 2;
        int leftN = n - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s, leftN, pred, top));
        top.key = s.readLong();
        top.black(true);
        top.right(this.readTree(s, rightN, top, succ));
        if (n + 2 == (n + 2 & -(n + 2))) {
            top.right.black(false);
        }
        return top;
    }

    private int checkTree(Entry e, int d, int D) {
        if (e == null) {
            return 0;
        }
        if (e.black()) {
            ++d;
        }
        if (e.left() != null) {
            D = this.checkTree(e.left(), d, D);
        }
        if (e.right() != null) {
            D = this.checkTree(e.right(), d, D);
        }
        if (e.left() == null && e.right() == null) {
            if (D == -1) {
                D = d;
            } else if (D != d) {
                throw new AssertionError((Object)("Mismatch between number of black nodes (" + D + " and " + d + ")"));
            }
        }
        return D;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            Entry e = this.tree = this.readTree(s, this.count, null, null);
            while (e.left() != null) {
                e = e.left();
            }
            this.firstEntry = e;
            e = this.tree;
            while (e.right() != null) {
                e = e.right();
            }
            this.lastEntry = e;
        }
    }

    private final class Subset
    extends AbstractLongSortedSet
    implements Serializable,
    LongSortedSet {
        long from;
        long to;
        boolean bottom;
        boolean top;

        public Subset(long from, boolean bottom, long to, boolean top) {
            if (!bottom && !top && LongRBTreeSet.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start element (" + from + ") is larger than end element (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
        }

        public void clear() {
            SubsetIterator i = new SubsetIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        final boolean in(long k) {
            return !(!this.bottom && LongRBTreeSet.this.compare(k, this.from) < 0 || !this.top && LongRBTreeSet.this.compare(k, this.to) >= 0);
        }

        public boolean contains(long k) {
            return this.in(k) && LongRBTreeSet.this.contains(k);
        }

        public boolean add(long k) {
            if (!this.in(k)) {
                throw new IllegalArgumentException("Element (" + k + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            return LongRBTreeSet.this.add(k);
        }

        public boolean remove(long k) {
            if (!this.in(k)) {
                return false;
            }
            return LongRBTreeSet.this.remove(k);
        }

        public int size() {
            SubsetIterator i = new SubsetIterator();
            int n = 0;
            while (i.hasNext()) {
                ++n;
                i.next();
            }
            return n;
        }

        public boolean isEmpty() {
            return !new SubsetIterator().hasNext();
        }

        public Comparator comparator() {
            return LongRBTreeSet.this.storedComparator;
        }

        public LongIterator longIterator() {
            return new SubsetIterator();
        }

        public LongBidirectionalIterator iterator(long from) {
            return new SubsetIterator(from);
        }

        public LongSortedSet headSet(long to) {
            if (this.top) {
                return new Subset(this.from, this.bottom, to, false);
            }
            return LongRBTreeSet.this.compare(to, this.to) < 0 ? new Subset(this.from, this.bottom, to, false) : this;
        }

        public LongSortedSet tailSet(long from) {
            if (this.bottom) {
                return new Subset(from, false, this.to, this.top);
            }
            return LongRBTreeSet.this.compare(from, this.from) > 0 ? new Subset(from, false, this.to, this.top) : this;
        }

        public LongSortedSet subSet(long from, long to) {
            if (this.top && this.bottom) {
                return new Subset(from, false, to, false);
            }
            if (!this.top) {
                long l = to = LongRBTreeSet.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                long l = from = LongRBTreeSet.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Subset(from, false, to, false);
        }

        public Entry firstEntry() {
            Entry e;
            if (LongRBTreeSet.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e = LongRBTreeSet.this.firstEntry;
            } else {
                e = LongRBTreeSet.this.locateKey(this.from);
                if (LongRBTreeSet.this.compare(e.key, this.from) < 0) {
                    e = e.next();
                }
            }
            if (e == null || !this.top && LongRBTreeSet.this.compare(e.key, this.to) >= 0) {
                return null;
            }
            return e;
        }

        public Entry lastEntry() {
            Entry e;
            if (LongRBTreeSet.this.tree == null) {
                return null;
            }
            if (this.top) {
                e = LongRBTreeSet.this.lastEntry;
            } else {
                e = LongRBTreeSet.this.locateKey(this.to);
                if (LongRBTreeSet.this.compare(e.key, this.to) >= 0) {
                    e = e.prev();
                }
            }
            if (e == null || !this.bottom && LongRBTreeSet.this.compare(e.key, this.from) < 0) {
                return null;
            }
            return e;
        }

        public long firstLong() {
            Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public long lastLong() {
            Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        private final class SubsetIterator
        extends SetIterator {
            SubsetIterator() {
                this.next = Subset.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubsetIterator(long k) {
                this();
                if (this.next == null) return;
                if (!subset.bottom && subset.LongRBTreeSet.this.compare(k, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!subset.top) {
                    this.prev = subset.lastEntry();
                    if (subset.LongRBTreeSet.this.compare(k, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = subset.LongRBTreeSet.this.locateKey(k);
                if (subset.LongRBTreeSet.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Subset.this.bottom && this.prev != null && LongRBTreeSet.this.compare(this.prev.key, Subset.this.from) < 0) {
                    this.prev = null;
                }
            }

            void updateNext() {
                this.next = this.next.next();
                if (!Subset.this.top && this.next != null && LongRBTreeSet.this.compare(this.next.key, Subset.this.to) >= 0) {
                    this.next = null;
                }
            }
        }
    }

    private class SetIterator
    extends AbstractLongListIterator {
        Entry prev;
        Entry next;
        Entry curr;
        int index = 0;

        SetIterator() {
            this.next = LongRBTreeSet.this.firstEntry;
        }

        SetIterator(long k) {
            this.next = LongRBTreeSet.this.locateKey(k);
            if (this.next != null) {
                if (LongRBTreeSet.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev = this.next;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        public long nextLong() {
            return this.nextEntry().key;
        }

        public long previousLong() {
            return this.previousEntry().key;
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next = this.prev;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.next = this.prev = this.curr;
            this.updatePrevious();
            this.updateNext();
            LongRBTreeSet.this.remove(this.curr.key);
            this.curr = null;
        }
    }

    private static final class Entry
    implements Cloneable {
        private static final int BLACK_MASK = 1;
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        long key;
        Entry left;
        Entry right;
        int info;

        Entry() {
        }

        Entry(Object k) {
            this.key = (Long)k;
            this.info = -1073741824;
        }

        Entry(long k) {
            this.key = k;
            this.info = -1073741824;
        }

        Entry left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        boolean black() {
            return (this.info & 1) != 0;
        }

        void black(boolean black) {
            this.info = black ? (this.info |= 1) : (this.info &= 0xFFFFFFFE);
        }

        Entry next() {
            Entry next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry prev() {
            Entry prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object clone() {
            Entry c;
            try {
                c = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c.key = this.key;
            c.info = this.info;
            return c;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.key == e.key;
        }

        public int hashCode() {
            return HashCommon.long2int(this.key);
        }

        public String toString() {
            return "" + this.key;
        }
    }
}

