/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import clover.it.unimi.dsi.fastutil.floats.FloatCollection;
import clover.it.unimi.dsi.fastutil.floats.FloatIterator;
import clover.it.unimi.dsi.fastutil.floats.FloatListIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLong2FloatSortedMap;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import clover.it.unimi.dsi.fastutil.longs.Long2FloatMap;
import clover.it.unimi.dsi.fastutil.longs.Long2FloatSortedMap;
import clover.it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongListIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import clover.it.unimi.dsi.fastutil.longs.LongSortedSet;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Long2FloatLinkedOpenHashMap
extends AbstractLong2FloatSortedMap
implements Serializable,
Cloneable,
Hash,
Long2FloatSortedMap {
    protected transient long[] key;
    protected transient float[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient LongSet keys;
    protected volatile transient FloatCollection values;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Long2FloatLinkedOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new long[this.free];
        this.value = new float[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public Long2FloatLinkedOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Long2FloatLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Long2FloatLinkedOpenHashMap(Map m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2FloatLinkedOpenHashMap(Map m) {
        this(m, 0.75f);
    }

    public Long2FloatLinkedOpenHashMap(Long2FloatMap m, float f) {
        this(m.size(), f);
        this.putAll((Map)m);
    }

    public Long2FloatLinkedOpenHashMap(Long2FloatMap m) {
        this(m, 0.75f);
    }

    public Long2FloatLinkedOpenHashMap(long[] k, float[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Long2FloatLinkedOpenHashMap(long[] k, float[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(long k) {
        long[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(long k) {
        long[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public float put(long k, float v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            float oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        float v = ((Float)ov).floatValue();
        long k = (Long)ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            float oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return new Float(oldValue);
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    public boolean containsValue(float v) {
        float[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill((byte[])this.state, (byte)0);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    public long firstLongKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    public long lastLongKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    public Comparator comparator() {
        return null;
    }

    public Long2FloatSortedMap tailMap(long from) {
        throw new UnsupportedOperationException();
    }

    public Long2FloatSortedMap headMap(long to) {
        throw new UnsupportedOperationException();
    }

    public Long2FloatSortedMap subMap(long from, long to) {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(long k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public float get(long k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public float remove(long k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return this.value[i];
    }

    public Object get(Object ok) {
        int i = this.findKey((Long)ok);
        return i < 0 ? null : new Float(this.value[i]);
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        int i = this.findKey(k);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return new Float(this.value[i]);
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Long2FloatLinkedOpenHashMap.this.findKey((Long)e.getKey());
                    return i >= 0 && Long2FloatLinkedOpenHashMap.this.value[i] == ((Float)e.getValue()).floatValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Long2FloatLinkedOpenHashMap.this.findKey((Long)e.getKey());
                    if (i >= 0) {
                        Long2FloatLinkedOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Long2FloatLinkedOpenHashMap.this.count;
                }

                public void clear() {
                    Long2FloatLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractFloatCollection(){

                public FloatIterator floatIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Long2FloatLinkedOpenHashMap.this.count;
                }

                public boolean contains(float v) {
                    return Long2FloatLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Long2FloatLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int n = PRIMES[newP];
        long[] lArray = this.key;
        long[] lArray2 = new long[n];
        float[] fArray = this.value;
        float[] fArray2 = new float[n];
        byte[] byArray = this.state;
        byte[] byArray2 = new byte[n];
        int[] newN = this.link;
        int[] key = new int[n];
        this.first = -1;
        while (j-- != 0) {
            void v;
            while (byArray[i] != -1) {
                ++i;
            }
            long newKey = lArray[i];
            float newValue = fArray[i];
            int state = HashCommon.long2int(newKey) & Integer.MAX_VALUE;
            int newState = state % n;
            int link = state % (n - 2) + 1;
            if (v[newState] != false) {
                link = state % (n - 2) + 1;
                while (v[newState = (newState + link) % n] != false) {
                }
            }
            v[newState] = -1;
            h1[newState] = newKey;
            k[newState] = newValue;
            int newLink = i;
            i = newN[i] ^ prev;
            prev = newLink;
            if (this.first != -1) {
                int n2 = newPrev;
                key[n2] = key[n2] ^ newState;
                key[newState] = newPrev;
                newPrev = newState;
                continue;
            }
            newPrev = this.first = newState;
            key[newState] = -1;
        }
        this.p = newP;
        this.free = n - this.count;
        this.maxFill = (int)((float)n * this.f);
        this.key = lArray2;
        this.value = fArray2;
        this.state = byArray2;
        this.link = key;
        this.last = newPrev;
        if (newPrev != -1) {
            int n3 = newPrev;
            key[n3] = ~key[n3];
        }
    }

    public Object clone() {
        Long2FloatLinkedOpenHashMap c;
        try {
            c = (Long2FloatLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (long[])this.key.clone();
        c.value = (float[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        int h = 0;
        int n = 0;
        int i = this.count;
        while (i-- != 0) {
            void t;
            while (this.state[n] != -1) {
                ++n;
            }
            int j = 0;
            j = HashCommon.long2int(this.key[t]);
            h += (j ^= HashCommon.float2int(this.value[t]));
            ++t;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        long[] key = this.key;
        float[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int n = this.count;
        s.defaultWriteObject();
        while (n-- != 0) {
            int j = i.nextEntry();
            s.writeLong(key[j]);
            s.writeFloat(value[j]);
        }
    }

    private void checkTable() {
        long k;
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
        LongBidirectionalIterator i = (LongBidirectionalIterator)this.keySet().iterator();
        n = this.size();
        while (n-- != 0) {
            k = i.nextLong();
            if (!this.containsKey(k)) {
                throw new AssertionError((Object)("Linked hash table forward enumerates key " + k + ", but the key does not belong to the table"));
            }
        }
        if (i.hasNext()) {
            throw new AssertionError((Object)"Forward iterator not exhausted");
        }
        n = this.size();
        if (n > 0) {
            i = ((LongSortedSet)this.keySet()).iterator(this.lastLongKey());
            while (n-- != 0) {
                k = i.previousLong();
                if (!this.containsKey(k)) {
                    throw new AssertionError((Object)("Linked hash table backward enumerates key " + k + ", but the key does not belong to the table"));
                }
            }
            if (i.hasPrevious()) {
                throw new AssertionError((Object)"Previous iterator not exhausted");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new long[n];
        long[] key = this.key;
        this.value = new float[n];
        float[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            void k2i;
            long l = s.readLong();
            float f = s.readFloat();
            int k = HashCommon.long2int(l) & Integer.MAX_VALUE;
            int n2 = k % n;
            if (state[n2] != 0) {
                int v = k % (n - 2) + 1;
                while (state[n2 = (n2 + v) % n] != 0) {
                }
            }
            state[n2] = -1;
            key[n2] = k2i;
            value[n2] = f;
            if (this.first != -1) {
                int n3 = prev;
                link[n3] = link[n3] ^ n2;
                link[n2] = prev;
                prev = n2;
                continue;
            }
            prev = this.first = n2;
            link[n2] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n4 = prev;
            link[n4] = ~link[n4];
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements FloatListIterator {
        public float previousFloat() {
            return Long2FloatLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Object previous() {
            return new Float(Long2FloatLinkedOpenHashMap.this.value[this.previousEntry()]);
        }

        public float nextFloat() {
            return Long2FloatLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public Object next() {
            return new Float(Long2FloatLinkedOpenHashMap.this.value[this.nextEntry()]);
        }

        public void set(float v) {
            throw new UnsupportedOperationException();
        }

        public void add(float v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractLongSortedSet
    implements LongSortedSet {
        private KeySet() {
        }

        public LongBidirectionalIterator iterator(long from) {
            return new KeyIterator(from);
        }

        public LongIterator longIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Long2FloatLinkedOpenHashMap.this.count;
        }

        public boolean contains(long k) {
            return Long2FloatLinkedOpenHashMap.this.containsKey(k);
        }

        public boolean remove(long k) {
            int oldCount = Long2FloatLinkedOpenHashMap.this.count;
            Long2FloatLinkedOpenHashMap.this.remove(k);
            return Long2FloatLinkedOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Long2FloatLinkedOpenHashMap.this.clear();
        }

        public long firstLong() {
            if (Long2FloatLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Long2FloatLinkedOpenHashMap.this.key[Long2FloatLinkedOpenHashMap.this.first];
        }

        public long lastLong() {
            if (Long2FloatLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Long2FloatLinkedOpenHashMap.this.key[Long2FloatLinkedOpenHashMap.this.last];
        }

        public Comparator comparator() {
            return null;
        }

        public final LongSortedSet tailSet(long from) {
            throw new UnsupportedOperationException();
        }

        public final LongSortedSet headSet(long to) {
            throw new UnsupportedOperationException();
        }

        public final LongSortedSet subSet(long from, long to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements LongListIterator {
        public KeyIterator(long k) {
            super(k);
        }

        public long previousLong() {
            return Long2FloatLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public Object previous() {
            return new Long(Long2FloatLinkedOpenHashMap.this.key[this.previousEntry()]);
        }

        public KeyIterator() {
        }

        public long nextLong() {
            return Long2FloatLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        public Object next() {
            return new Long(Long2FloatLinkedOpenHashMap.this.key[this.nextEntry()]);
        }

        public void set(long k) {
            throw new UnsupportedOperationException();
        }

        public void add(long k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectListIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        MapIterator() {
            this.next = Long2FloatLinkedOpenHashMap.this.first;
        }

        MapIterator(long from) {
            if (Long2FloatLinkedOpenHashMap.this.key[Long2FloatLinkedOpenHashMap.this.last] == from) {
                this.prev = Long2FloatLinkedOpenHashMap.this.last;
                this.index = Long2FloatLinkedOpenHashMap.this.count;
            } else {
                int e;
                if (!Long2FloatLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Long2FloatLinkedOpenHashMap.this.first;
                while (Long2FloatLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = Long2FloatLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = Long2FloatLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public Object previous() {
            return new MapEntry(this.previousEntry());
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            Long2FloatLinkedOpenHashMap.this.state[this.curr] = 1;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Long2FloatLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Long2FloatLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Long2FloatLinkedOpenHashMap.this.count;
            if (this.prev == -1) {
                Long2FloatLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Long2FloatLinkedOpenHashMap.this.link[n] = Long2FloatLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Long2FloatLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Long2FloatLinkedOpenHashMap.this.link[n] = Long2FloatLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private final class MapEntry
    implements Long2FloatMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return new Long(Long2FloatLinkedOpenHashMap.this.key[this.index]);
        }

        public long getLongKey() {
            return Long2FloatLinkedOpenHashMap.this.key[this.index];
        }

        public Object getValue() {
            return new Float(Long2FloatLinkedOpenHashMap.this.value[this.index]);
        }

        public float getFloatValue() {
            return Long2FloatLinkedOpenHashMap.this.value[this.index];
        }

        public float setValue(float v) {
            float oldValue = Long2FloatLinkedOpenHashMap.this.value[this.index];
            Long2FloatLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public Object setValue(Object v) {
            return new Float(this.setValue(((Float)v).floatValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Long2FloatLinkedOpenHashMap.this.key[this.index] == (Long)e.getKey() && Long2FloatLinkedOpenHashMap.this.value[this.index] == ((Float)e.getValue()).floatValue();
        }

        public int hashCode() {
            return HashCommon.long2int(Long2FloatLinkedOpenHashMap.this.key[this.index]) ^ HashCommon.float2int(Long2FloatLinkedOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Long2FloatLinkedOpenHashMap.this.key[this.index] + "->" + Long2FloatLinkedOpenHashMap.this.value[this.index];
        }
    }
}

