/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.ExceptionConverter;
import clover.com.lowagie.text.pdf.ByteBuffer;
import clover.com.lowagie.text.pdf.PdfContentByte;
import clover.com.lowagie.text.pdf.PdfDictionary;
import clover.com.lowagie.text.pdf.PdfLiteral;
import clover.com.lowagie.text.pdf.PdfName;
import clover.com.lowagie.text.pdf.PdfNumber;
import java.security.MessageDigest;

public class PdfEncryption {
    static final byte[] pad = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    byte[] state = new byte[256];
    int x;
    int y;
    byte[] key;
    int keySize;
    byte[] mkey;
    byte[] extra = new byte[5];
    MessageDigest md5;
    byte[] ownerKey = new byte[32];
    byte[] userKey = new byte[32];
    int permissions;
    byte[] documentID;

    public PdfEncryption() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void setupAllKeys(byte[] byArray, byte[] byArray2, int n, boolean bl) {
        int n2;
        int n3;
        Object object;
        long l;
        long l2;
        n = bl ? (n |= 0xFFFFF0C0) : (n |= 0xFFFFFFC0);
        this.permissions = n &= 0xFFFFFFFC;
        byte[] byArray3 = new byte[32];
        if (byArray == null) {
            System.arraycopy(pad, 0, byArray3, 0, 32);
        } else {
            System.arraycopy(byArray, 0, byArray3, 0, Math.min(byArray.length, 32));
            if (byArray.length < 32) {
                System.arraycopy(pad, 0, byArray3, byArray.length, 32 - byArray.length);
            }
        }
        byte[] byArray4 = new byte[32];
        if (byArray2 == null || byArray2.length == 0) {
            System.arraycopy(pad, 0, byArray4, 0, 32);
            l2 = System.currentTimeMillis();
            l = Runtime.getRuntime().freeMemory();
            object = l2 + "-" + l;
            System.arraycopy(this.md5.digest(((String)object).getBytes()), 0, byArray4, 0, 16);
        } else {
            System.arraycopy(byArray2, 0, byArray4, 0, Math.min(byArray2.length, 32));
            if (byArray2.length < 32) {
                System.arraycopy(pad, 0, byArray4, byArray2.length, 32 - byArray2.length);
            }
        }
        this.mkey = new byte[bl ? 16 : 5];
        object = this.md5.digest(byArray4);
        if (bl) {
            int n4 = 0;
            while (n4 < 50) {
                object = this.md5.digest((byte[])object);
                ++n4;
            }
            System.arraycopy(byArray3, 0, this.ownerKey, 0, 32);
            n3 = 0;
            while (n3 < 20) {
                n2 = 0;
                while (n2 < this.mkey.length) {
                    this.mkey[n2] = (byte)(object[n2] ^ n3);
                    ++n2;
                }
                this.prepareRC4Key(this.mkey);
                this.encryptRC4(this.ownerKey);
                ++n3;
            }
        } else {
            this.prepareRC4Key((byte[])object, 0, this.mkey.length);
            this.encryptRC4(byArray3, this.ownerKey);
        }
        l2 = System.currentTimeMillis();
        l = Runtime.getRuntime().freeMemory();
        String string = l2 + "+" + l;
        this.documentID = this.md5.digest(string.getBytes());
        this.md5.update(byArray3);
        this.md5.update(this.ownerKey);
        this.extra[0] = (byte)n;
        this.extra[1] = (byte)(n >> 8);
        this.extra[2] = (byte)(n >> 16);
        this.extra[3] = (byte)(n >> 24);
        this.md5.update(this.extra, 0, 4);
        object = this.md5.digest(this.documentID);
        if (bl) {
            n3 = 0;
            while (n3 < 50) {
                object = this.md5.digest((byte[])object);
                ++n3;
            }
        }
        System.arraycopy(object, 0, this.mkey, 0, this.mkey.length);
        if (bl) {
            this.md5.update(pad);
            object = this.md5.digest(this.documentID);
            System.arraycopy(object, 0, this.userKey, 0, 16);
            n3 = 16;
            while (n3 < 32) {
                this.userKey[n3] = 0;
                ++n3;
            }
            n2 = 0;
            while (n2 < 20) {
                int n5 = 0;
                while (n5 < this.mkey.length) {
                    object[n5] = (byte)(this.mkey[n5] ^ n2);
                    ++n5;
                }
                this.prepareRC4Key((byte[])object, 0, this.mkey.length);
                this.encryptRC4(this.userKey, 0, 16);
                ++n2;
            }
        } else {
            this.prepareRC4Key(this.mkey);
            this.encryptRC4(pad, this.userKey);
        }
    }

    public void prepareKey() {
        this.prepareRC4Key(this.key, 0, this.keySize);
    }

    public void setHashKey(int n, int n2) {
        this.extra[0] = (byte)n;
        this.extra[1] = (byte)(n >> 8);
        this.extra[2] = (byte)(n >> 16);
        this.extra[3] = (byte)n2;
        this.extra[4] = (byte)(n2 >> 8);
        this.md5.update(this.mkey);
        this.key = this.md5.digest(this.extra);
        this.keySize = this.mkey.length + 5;
        if (this.keySize > 16) {
            this.keySize = 16;
        }
    }

    public PdfLiteral getFileID() {
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer.append('[');
        byteBuffer.append(PdfContentByte.escapeString(this.documentID));
        byteBuffer.append(PdfContentByte.escapeString(this.documentID));
        byteBuffer.append(']');
        return new PdfLiteral(byteBuffer.toByteArray());
    }

    public PdfDictionary getEncryptionDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.FILTER, PdfName.STANDARD);
        pdfDictionary.put(PdfName.O, new PdfLiteral(PdfContentByte.escapeString(this.ownerKey)));
        pdfDictionary.put(PdfName.U, new PdfLiteral(PdfContentByte.escapeString(this.userKey)));
        pdfDictionary.put(PdfName.P, new PdfNumber(this.permissions));
        if (this.mkey.length > 5) {
            pdfDictionary.put(PdfName.V, new PdfNumber(2));
            pdfDictionary.put(PdfName.R, new PdfNumber(3));
            pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
        } else {
            pdfDictionary.put(PdfName.V, new PdfNumber(1));
            pdfDictionary.put(PdfName.R, new PdfNumber(2));
        }
        return pdfDictionary;
    }

    public void prepareRC4Key(byte[] byArray) {
        this.prepareRC4Key(byArray, 0, byArray.length);
    }

    public void prepareRC4Key(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 256) {
            this.state[n5] = (byte)n5;
            ++n5;
        }
        this.x = 0;
        this.y = 0;
        int n6 = 0;
        while (n6 < 256) {
            n4 = byArray[n3 + n] + this.state[n6] + n4 & 0xFF;
            byte by = this.state[n6];
            this.state[n6] = this.state[n4];
            this.state[n4] = by;
            n3 = (n3 + 1) % n2;
            ++n6;
        }
    }

    public void encryptRC4(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = n2 + n;
        int n4 = n;
        while (n4 < n3) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.state[this.x] + this.y & 0xFF;
            byte by = this.state[this.x];
            this.state[this.x] = this.state[this.y];
            this.state[this.y] = by;
            byArray2[n4] = (byte)(byArray[n4] ^ this.state[this.state[this.x] + this.state[this.y] & 0xFF]);
            ++n4;
        }
    }

    public void encryptRC4(byte[] byArray, int n, int n2) {
        this.encryptRC4(byArray, n, n2, byArray);
    }

    public void encryptRC4(byte[] byArray, byte[] byArray2) {
        this.encryptRC4(byArray, 0, byArray.length, byArray2);
    }

    public void encryptRC4(byte[] byArray) {
        this.encryptRC4(byArray, 0, byArray.length, byArray);
    }
}

