/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.parser;

import java.util.Stack;
import org.qedeq.base.io.SourceArea;
import org.qedeq.base.io.SourcePosition;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.common.SourceFileException;
import org.qedeq.kernel.xml.common.XmlSyntaxException;
import org.qedeq.kernel.xml.parser.AbstractSimpleHandler;
import org.qedeq.kernel.xml.parser.SimpleAttributes;
import org.qedeq.kernel.xml.parser.SimpleHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SaxDefaultHandler
extends SimpleHandler {
    private static final Class CLASS = SaxDefaultHandler.class;
    private AbstractSimpleHandler currentHandler;
    private Stack handlerStack = new Stack();
    private AbstractSimpleHandler basisHandler;
    private DefaultSourceFileExceptionList errorList;
    private StringBuffer buffer = new StringBuffer(2000);
    private int level;
    private Stack levelStack = new Stack();
    private String currentElementName;
    private final Plugin plugin;

    public SaxDefaultHandler(Plugin plugin) {
        this.plugin = plugin;
    }

    public void setExceptionList(DefaultSourceFileExceptionList errorList) {
        this.errorList = errorList;
    }

    public final void setBasisDocumentHandler(AbstractSimpleHandler handler) {
        this.basisHandler = handler;
        this.currentHandler = handler;
        this.handlerStack.clear();
        this.level = 0;
    }

    public final void startDocument() throws SAXException {
        this.sendCharacters();
        this.currentHandler = this.basisHandler;
        this.handlerStack.clear();
        this.level = 0;
        this.currentElementName = null;
    }

    public final void endDocument() throws SAXException {
        this.sendCharacters();
        this.currentElementName = null;
    }

    public final void startElement(String uri, String localName, String qName, Attributes amap) throws SAXException {
        String method = "startElement";
        try {
            Trace.param(CLASS, (Object)this, "startElement", "currentHandler", this.currentHandler.getClass().getName());
            Trace.param(CLASS, (Object)this, "startElement", "localName", localName);
            Trace.param(CLASS, (Object)this, "startElement", "qName", qName);
            if (this.handlerStack.empty() && this.level == 0) {
                this.currentHandler.init();
            }
            ++this.level;
            Trace.param(CLASS, (Object)this, "startElement", "level", this.level);
            this.sendCharacters();
            this.currentElementName = localName;
            SimpleAttributes attributes = new SimpleAttributes();
            for (int i = 0; i < amap.getLength(); ++i) {
                attributes.add(amap.getQName(i), amap.getValue(i));
            }
            Trace.param(CLASS, (Object)this, "startElement", "attributes", attributes);
            this.currentHandler.startElement(qName, attributes);
        }
        catch (XmlSyntaxException e) {
            Trace.trace(CLASS, (Object)this, "startElement", (Throwable)e);
            this.errorList.add(new SourceFileException(this.plugin, e, this.createSourceArea(), null));
        }
        catch (RuntimeException e) {
            Trace.trace(CLASS, (Object)this, "startElement", (Throwable)e);
            XmlSyntaxException ex = XmlSyntaxException.createByRuntimeException(e);
            SourceFileException sfe = new SourceFileException(this.plugin, ex.getErrorCode(), ex.getMessage(), ex, this.createSourceArea(), null);
            this.errorList.add(sfe);
        }
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        XmlSyntaxException ex;
        this.sendCharacters();
        String method = "endElement";
        try {
            Trace.param(CLASS, (Object)this, "endElement", "currentHandler", this.currentHandler.getClass().getName());
            Trace.param(CLASS, (Object)this, "endElement", "localName", localName);
            this.currentHandler.endElement(localName);
        }
        catch (XmlSyntaxException e) {
            Trace.trace(CLASS, (Object)this, "endElement", (Throwable)e);
            this.errorList.add(new SourceFileException(this.plugin, e, this.createSourceArea(), null));
        }
        catch (RuntimeException e) {
            Trace.trace(CLASS, (Object)this, "endElement", (Throwable)e);
            ex = XmlSyntaxException.createByRuntimeException(e);
            this.errorList.add(new SourceFileException(this.plugin, ex, this.createSourceArea(), null));
        }
        try {
            this.currentElementName = null;
            --this.level;
            Trace.param(CLASS, (Object)this, "endElement", "level", this.level);
            if (this.level <= 0) {
                this.restoreHandler(localName);
            }
        }
        catch (XmlSyntaxException e) {
            Trace.trace(CLASS, (Object)this, "endElement", (Throwable)e);
            SourceFileException sfe = new SourceFileException(this.plugin, e.getErrorCode(), e.getMessage(), e, this.createSourceArea(), null);
            this.errorList.add(sfe);
        }
        catch (RuntimeException e) {
            Trace.trace(CLASS, (Object)this, "endElement", (Throwable)e);
            ex = XmlSyntaxException.createByRuntimeException(e);
            this.errorList.add(new SourceFileException(this.plugin, ex, this.createSourceArea(), null));
        }
    }

    public final void characters(char[] ch, int start, int length) {
        this.buffer.append(ch, start, length);
    }

    private void sendCharacters() {
        try {
            if (this.buffer.length() > 0) {
                String str = this.buffer.toString();
                this.buffer.setLength(0);
                if (str.trim().length() > 0) {
                    this.currentHandler.characters(this.currentElementName, str);
                }
            }
        }
        catch (XmlSyntaxException e) {
            Trace.trace(CLASS, (Object)this, "sendCharacters", (Throwable)e);
            this.errorList.add(new SourceFileException(this.plugin, e, this.createSourceArea(), null));
        }
        catch (RuntimeException e) {
            Trace.trace(CLASS, (Object)this, "sendCharacters", (Throwable)e);
            XmlSyntaxException ex = XmlSyntaxException.createByRuntimeException(e);
            this.errorList.add(new SourceFileException(this.plugin, ex, this.createSourceArea(), null));
        }
    }

    public final void changeHandler(AbstractSimpleHandler newHandler, String elementName, SimpleAttributes attributes) throws XmlSyntaxException {
        this.handlerStack.push(this.currentHandler);
        this.levelStack.push(new Integer(this.level));
        this.currentHandler = newHandler;
        this.level = 0;
        ++this.level;
        Trace.param(CLASS, (Object)this, "changeHandler", "level", this.level);
        this.currentHandler.init();
        this.currentHandler.startElement(elementName, attributes);
    }

    private final void restoreHandler(String elementName) throws XmlSyntaxException {
        while (this.level <= 0 && !this.handlerStack.empty()) {
            this.currentHandler = (AbstractSimpleHandler)this.handlerStack.pop();
            Trace.param(CLASS, (Object)this, "restoreHandler", "currentHandler", this.currentHandler);
            this.level = (Integer)this.levelStack.pop();
            this.currentHandler.endElement(elementName);
            --this.level;
            Trace.param(CLASS, (Object)this, "restoreHandler", "level", this.level);
        }
        if (this.handlerStack.empty()) {
            Trace.trace(CLASS, (Object)this, "restoreHandler", "no handler to restore");
        }
    }

    public final int getLevel() {
        return this.level;
    }

    public final SAXParseException createSAXParseException(Exception e) {
        return new SAXParseException(null, this.getLocator(), e);
    }

    public final SAXParseException createSAXParseException(String message) {
        return new SAXParseException(message, this.getLocator());
    }

    protected final SourceArea createSourceArea() {
        if (this.getLocator() != null && this.getUrl() != null) {
            return new SourceArea(this.getUrl(), new SourcePosition(this.getLocator().getLineNumber(), 1), new SourcePosition(this.getLocator().getLineNumber(), this.getLocator().getColumnNumber()));
        }
        return new SourceArea(this.getUrl(), SourcePosition.BEGIN, SourcePosition.BEGIN);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

