/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.parser;

import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.xml.common.XmlSyntaxException;
import org.qedeq.kernel.xml.parser.SaxDefaultHandler;
import org.qedeq.kernel.xml.parser.SimpleAttributes;

public abstract class AbstractSimpleHandler {
    private final SaxDefaultHandler defaultHandler;
    private final String startTag;

    public AbstractSimpleHandler(SaxDefaultHandler defaultHandler, String startTag) {
        this.defaultHandler = defaultHandler;
        this.startTag = startTag;
    }

    public AbstractSimpleHandler(SaxDefaultHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
        this.startTag = null;
    }

    public AbstractSimpleHandler(AbstractSimpleHandler handler, String startTag) {
        this.defaultHandler = handler.defaultHandler;
        this.startTag = startTag;
    }

    public AbstractSimpleHandler(AbstractSimpleHandler handler) {
        this.defaultHandler = handler.defaultHandler;
        this.startTag = null;
    }

    public abstract void init();

    public abstract void startElement(String var1, SimpleAttributes var2) throws XmlSyntaxException;

    public abstract void endElement(String var1) throws XmlSyntaxException;

    public void characters(String elementName, String value) throws XmlSyntaxException {
        throw XmlSyntaxException.createUnexpectedTextDataException(elementName, value);
    }

    public final void changeHandler(AbstractSimpleHandler newHandler, String elementName, SimpleAttributes attributes) throws XmlSyntaxException {
        if (newHandler.getStartTag() != null && !newHandler.getStartTag().equals(elementName)) {
            throw new RuntimeException(newHandler.getClass().getName() + " has start tag \"" + newHandler.getStartTag() + "\", but should start with tag \"" + elementName + "\"");
        }
        this.defaultHandler.changeHandler(newHandler, elementName, attributes);
    }

    public final Plugin getPlugin() {
        return this.defaultHandler.getPlugin();
    }

    public final int getLevel() {
        return this.defaultHandler.getLevel();
    }

    public final String getStartTag() {
        return this.startTag;
    }
}

