/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.dao;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.TextOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.context.KernelContext;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.common.ModuleAddress;
import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.xml.dao.Qedeq2Xml;

public final class Xml2Xml
implements Plugin {
    private static final Class CLASS = Xml2Xml.class;

    private Xml2Xml() {
    }

    public static String generate(InternalKernelServices services, File from, File to) throws SourceFileExceptionList {
        String method = "generate(File, File)";
        try {
            File destination;
            if (to != null) {
                destination = to.getCanonicalFile();
            } else {
                String xml = from.getName();
                if (xml.toLowerCase(Locale.US).endsWith(".xml")) {
                    xml = xml.substring(0, xml.length() - 4);
                }
                destination = new File(from.getParentFile(), xml + "_.xml").getCanonicalFile();
            }
            return Xml2Xml.generate(IoUtility.toUrl(from), destination);
        }
        catch (IOException e) {
            Trace.fatal(CLASS, "Reading or writing failed", "generate(File, File)", e);
            throw services.createSourceFileExceptionList(to + "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generate(URL from, File to) throws SourceFileExceptionList, IOException {
        String method = "generate(URL, File)";
        Trace.begin(CLASS, "generate(URL, File)");
        Trace.param(CLASS, "generate(URL, File)", "from", from);
        Trace.param(CLASS, "generate(URL, File)", "to", to);
        TextOutput printer = null;
        try {
            ModuleAddress address = KernelContext.getInstance().getModuleAddress(from);
            KernelQedeqBo prop = (KernelQedeqBo)KernelContext.getInstance().loadModule(address);
            if (prop.getLoadingState().isFailure()) {
                throw prop.getErrors();
            }
            IoUtility.createNecessaryDirectories(to);
            FileOutputStream outputStream = new FileOutputStream(to);
            printer = new TextOutput(to.getName(), outputStream, "UTF-8");
            Qedeq2Xml.print(new Xml2Xml(), prop, printer);
            String string = to.getCanonicalPath();
            return string;
        }
        finally {
            if (printer != null) {
                printer.close();
            }
            Trace.end(CLASS, "generate(URL, File)");
        }
    }

    public String getPluginId() {
        return CLASS.getName();
    }

    public String getPluginName() {
        return "Xml2Xml";
    }

    public String getPluginDescription() {
        return "transform XML QEDEQ module in a new XML file";
    }
}

