/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.visitor;

public class QedeqNumbers {
    private int imports;
    private int chapters;
    private int sections;
    private int subsectionsAndNodes;
    private int importNumber;
    private boolean chapterNumbering;
    private int chapterNumber;
    private int absoluteChapterNumber;
    private boolean sectionNumbering;
    private int sectionNumber;
    private int absoluteSectionNumber;
    private int subsectionNumber;
    private int nodeNumber;
    private int axiomNumber;
    private int functionDefinitionNumber;
    private int predicateDefinitionNumber;
    private int propositionNumber;
    private int ruleNumber;
    private boolean finished;

    public QedeqNumbers(int imports, int chapters) {
        this.imports = imports;
        this.chapters = chapters;
    }

    public QedeqNumbers(QedeqNumbers original) {
        this.imports = original.imports;
        this.chapters = original.chapters;
        this.sections = original.sections;
        this.subsectionsAndNodes = original.subsectionsAndNodes;
        this.importNumber = original.importNumber;
        this.chapterNumbering = original.chapterNumbering;
        this.chapterNumber = original.chapterNumber;
        this.absoluteChapterNumber = original.absoluteChapterNumber;
        this.sectionNumbering = original.sectionNumbering;
        this.nodeNumber = original.nodeNumber;
        this.sectionNumber = original.sectionNumber;
        this.absoluteSectionNumber = original.absoluteSectionNumber;
        this.subsectionNumber = original.subsectionNumber;
        this.axiomNumber = original.axiomNumber;
        this.functionDefinitionNumber = original.functionDefinitionNumber;
        this.predicateDefinitionNumber = original.predicateDefinitionNumber;
        this.propositionNumber = original.propositionNumber;
        this.ruleNumber = original.ruleNumber;
        this.finished = original.finished;
    }

    public int getImportNumber() {
        return this.importNumber;
    }

    public void increaseImportNumber() {
        ++this.importNumber;
    }

    public int getChapterNumber() {
        return this.chapterNumber;
    }

    public void increaseChapterNumber(int sections, boolean chapterNumbering) {
        this.chapterNumbering = chapterNumbering;
        ++this.absoluteChapterNumber;
        if (chapterNumbering) {
            ++this.chapterNumber;
        }
        this.sections = sections;
        this.subsectionsAndNodes = 0;
        this.sectionNumber = 0;
        this.absoluteSectionNumber = 0;
        this.sectionNumbering = true;
        this.subsectionNumber = 0;
        this.nodeNumber = 0;
    }

    public boolean isChapterNumbering() {
        return this.chapterNumbering;
    }

    public int getAbsoluteChapterNumber() {
        return this.absoluteChapterNumber;
    }

    public int getSectionNumber() {
        return this.sectionNumber;
    }

    public void increaseSectionNumber(int subsectionsAndNodes, boolean sectionNumbering) {
        this.subsectionsAndNodes = subsectionsAndNodes;
        this.sectionNumbering = sectionNumbering;
        ++this.absoluteSectionNumber;
        if (sectionNumbering) {
            ++this.sectionNumber;
        }
        this.subsectionNumber = 0;
        this.nodeNumber = 0;
    }

    public int getAbsoluteSectionNumber() {
        return this.absoluteSectionNumber;
    }

    public boolean isSectionNumbering() {
        return this.sectionNumbering;
    }

    public int getSubsectionNumber() {
        return this.subsectionNumber;
    }

    public void increaseSubsectionNumber() {
        ++this.subsectionNumber;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public void increaseNodeNumber() {
        ++this.nodeNumber;
    }

    public int getAxiomNumber() {
        return this.axiomNumber;
    }

    public void increaseAxiomNumber() {
        ++this.axiomNumber;
    }

    public int getFunctionDefinitionNumber() {
        return this.functionDefinitionNumber;
    }

    public void increaseFunctionDefinitionNumber() {
        ++this.functionDefinitionNumber;
    }

    public int getPredicateDefinitionNumber() {
        return this.predicateDefinitionNumber;
    }

    public void increasePredicateDefinitionNumber() {
        ++this.predicateDefinitionNumber;
    }

    public int getPropositionNumber() {
        return this.propositionNumber;
    }

    public void increasePropositionNumber() {
        ++this.propositionNumber;
    }

    public int getRuleNumber() {
        return this.ruleNumber;
    }

    public void increaseRuleNumber() {
        ++this.ruleNumber;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public double getVisitPercentage() {
        if (this.finished) {
            return 100.0;
        }
        double result = (double)this.importNumber / (double)(this.imports + 1) / (double)(this.chapters + 3);
        result += (double)this.absoluteChapterNumber / (double)(this.chapters + 3);
        result += (double)this.absoluteSectionNumber / (double)(this.sections + 2) / (double)(this.chapters + 3);
        return 100.0 * (result += (double)(this.subsectionNumber + this.nodeNumber) / (double)(this.subsectionsAndNodes + 2) / (double)(this.sections + 2) / (double)(this.chapters + 3));
    }

    public boolean equals(Object compare) {
        if (!(compare instanceof QedeqNumbers)) {
            return false;
        }
        QedeqNumbers other = (QedeqNumbers)compare;
        return this.imports == other.imports && this.importNumber == other.importNumber && this.chapterNumbering == other.chapterNumbering && this.absoluteChapterNumber == other.absoluteChapterNumber && this.sectionNumbering == other.sectionNumbering && this.sections == other.sections && this.absoluteSectionNumber == other.absoluteSectionNumber && this.subsectionNumber == other.subsectionNumber && this.nodeNumber == other.nodeNumber && this.axiomNumber == other.axiomNumber && this.propositionNumber == other.propositionNumber && this.predicateDefinitionNumber == other.predicateDefinitionNumber && this.functionDefinitionNumber == other.functionDefinitionNumber && this.ruleNumber == other.ruleNumber;
    }

    public int hashCode() {
        return this.imports ^ this.importNumber * 4 ^ this.chapters * 16 ^ this.absoluteChapterNumber * 64 ^ this.sections * 256 ^ this.absoluteSectionNumber * 1024 ^ this.subsectionsAndNodes * 4096 ^ this.nodeNumber * 16384 ^ this.subsectionNumber * 65536 ^ this.axiomNumber * 262144 ^ this.propositionNumber * 0x100000 ^ this.predicateDefinitionNumber * 0x400000 ^ this.functionDefinitionNumber * 0x1000000 ^ this.ruleNumber * 0x4000000;
    }

    public String toString() {
        return "(" + this.importNumber + "/" + this.imports + " I) " + "(" + this.absoluteChapterNumber + "/" + this.chapters + " C) " + "(" + this.absoluteSectionNumber + "/" + this.sections + " S) " + "(" + (this.subsectionNumber + this.nodeNumber) + "/" + this.subsectionsAndNodes + ")";
    }
}

