/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.dto.list;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.qedeq.kernel.base.list.Element;
import org.qedeq.kernel.base.list.ElementList;

public final class ElementSet {
    private final Set elements;

    public ElementSet() {
        this.elements = new HashSet();
    }

    public ElementSet(Element[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException("NullPointer as element array is not allowed");
        }
        this.elements = new HashSet<Element>(Arrays.asList(elements));
    }

    public ElementSet(ElementSet set) {
        if (set == null) {
            throw new IllegalArgumentException("NullPointer as set is not allowed");
        }
        this.elements = new HashSet(set.elements);
    }

    public ElementSet(ElementList element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer as element is not allowed");
        }
        if (element.isAtom()) {
            throw new IllegalArgumentException("text as element is not allowed");
        }
        this.elements = new HashSet(element.getElements());
    }

    public final boolean contains(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer as element is not allowed");
        }
        return this.elements.contains(element);
    }

    public final boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public final boolean isSubset(ElementSet set) {
        if (set == null) {
            throw new IllegalArgumentException("NullPointer as set is not allowed");
        }
        return this.elements.containsAll(set.elements);
    }

    public final ElementSet add(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer as element is not allowed");
        }
        this.elements.add(element);
        return this;
    }

    public final ElementSet union(ElementSet set) {
        if (set == null) {
            throw new IllegalArgumentException("NullPointer as set is not allowed");
        }
        this.elements.addAll(set.elements);
        return this;
    }

    public final ElementSet remove(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer as element is not allowed");
        }
        this.elements.remove(element);
        return this;
    }

    public final ElementSet minus(ElementSet set) {
        if (set == null) {
            throw new IllegalArgumentException("NullPointer as set is not allowed");
        }
        this.elements.removeAll(set.elements);
        return this;
    }

    public final ElementSet intersection(ElementSet set) {
        if (set == null) {
            throw new IllegalArgumentException("NullPointer as set is not allowed");
        }
        this.elements.retainAll(set.elements);
        return this;
    }

    public final ElementSet newIntersection(ElementSet set) {
        if (set == null) {
            throw new IllegalArgumentException("NullPointer as set is not allowed");
        }
        ElementSet result = new ElementSet(this);
        result.elements.retainAll(set.elements);
        return result;
    }

    public final ElementSet newDelta(ElementSet set) {
        if (set == null) {
            throw new IllegalArgumentException("NullPointer as set is not allowed");
        }
        ElementSet union = new ElementSet(this);
        union.union(set);
        ElementSet intersection = new ElementSet(this);
        intersection.intersection(set);
        union.minus(intersection);
        return union;
    }

    public final int size() {
        return this.elements.size();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == ElementSet.class) {
            return ((Object)this.elements).equals(((ElementSet)obj).elements);
        }
        return false;
    }

    public final int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            result.append(iterator.next());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        result.append("}");
        return result.toString();
    }
}

