/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.config;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.qedeq.base.io.IoUtility;
import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.config.ConfigAccess;

public class QedeqConfig {
    private static final String DEFAULT_LOCAL_MODULES_DIRECTORY = "local";
    private static final String DEFAULT_LOCAL_BUFFER = "buffer";
    private static final String DEFAULT_GENERATED = "generated";
    private static final String DEFAULT_LOG_FILE = "log/log.txt";
    private final ConfigAccess configAccess;
    private final File basisDirectory;

    public QedeqConfig(File configFile, String description, File basisDirectory) throws IOException {
        this.configAccess = new ConfigAccess(configFile, description);
        this.basisDirectory = basisDirectory;
    }

    public final void store() throws IOException {
        this.configAccess.store();
    }

    public final File getGenerationDirectory() {
        String location = this.getKeyValue("generationLocation");
        if (location == null) {
            location = DEFAULT_GENERATED;
        }
        return this.createAbsolutePath(location);
    }

    public final void setGenerationDirectory(File location) {
        String relative = this.createRelativePath(location);
        this.setKeyValue("generationLocation", relative);
    }

    public final File getBufferDirectory() {
        String location = this.getKeyValue("bufferLocation");
        if (location == null) {
            location = DEFAULT_LOCAL_BUFFER;
        }
        return this.createAbsolutePath(location);
    }

    public final void setBufferDirectory(File location) {
        String relative = this.createRelativePath(location);
        this.setKeyValue("bufferLocation", relative);
    }

    public final File getLocalModulesDirectory() {
        String location = this.getKeyValue("localModulesDirectory");
        if (location == null) {
            location = DEFAULT_LOCAL_MODULES_DIRECTORY;
        }
        return this.createAbsolutePath(location);
    }

    public final void setLocalModulesDirectory(File location) {
        String relative = this.createRelativePath(location);
        this.setKeyValue("localModulesDirectory", relative);
    }

    public final String getLogFile() {
        String location = this.getKeyValue("logLocation");
        if (location == null) {
            return DEFAULT_LOG_FILE;
        }
        return location;
    }

    public final String[] getModuleHistory() {
        return this.configAccess.getStringProperties("moduleHistory.");
    }

    public final void saveModuleHistory(List modules) {
        this.configAccess.removeProperties("moduleHistory.");
        for (int i = 0; i < modules.size(); ++i) {
            this.setKeyValue("moduleHistory." + (i + 101), modules.get(i).toString());
        }
    }

    public final String[] getPreviouslyCheckedModules() {
        return this.configAccess.getStringProperties("checkedModule.");
    }

    public final void setLoadedModules(String[] moduleAddresses) {
        this.configAccess.removeProperties("checkedModule.");
        for (int i = 0; i < moduleAddresses.length; ++i) {
            this.setKeyValue("checkedModule." + (i + 1), moduleAddresses[i]);
        }
    }

    public final File getBasisDirectory() {
        return this.basisDirectory;
    }

    public final File createAbsolutePath(String path) {
        File result = new File(this.getBasisDirectory(), path);
        try {
            result = result.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private final String createRelativePath(File path) {
        return IoUtility.createRelativePath(this.getBasisDirectory(), path);
    }

    public boolean isAutoReloadLastSessionChecked() {
        return "true".equals(this.getKeyValue("sessionAutoReload", "true"));
    }

    public final void setAutoReloadLastSessionChecked(boolean mode) {
        this.setKeyValue("sessionAutoReload", mode ? "true" : "false");
    }

    public final boolean isTraceOn() {
        return "true".equals(this.getKeyValue("traceOn", "false"));
    }

    public final void setTraceOn(boolean traceOn) {
        this.setKeyValue("traceOn", traceOn ? "true" : "false");
    }

    public int getConnectTimeout() {
        return this.getKeyValue("connectionTimeout", 2000);
    }

    public final void setConnectionTimeout(int timeout) {
        this.setKeyValue("connectionTimeout", timeout);
    }

    public int getReadTimeout() {
        return this.getKeyValue("readTimeout", 1000);
    }

    public final void setReadTimeout(int timeout) {
        this.setKeyValue("readTimeout", timeout);
    }

    public final void setHttpProxyHost(String httpProxyHost) {
        this.setKeyValue("http.proxyHost", httpProxyHost);
    }

    public final String getHttpProxyHost() {
        String def = System.getProperty("http.proxyHost");
        if (def != null) {
            return this.getKeyValue("http.proxyHost", def);
        }
        return this.getKeyValue("http.proxyHost");
    }

    public final void setHttpProxyPort(String httpProxyPort) {
        this.setKeyValue("http.proxyPort", httpProxyPort);
    }

    public final String getHttpProxyPort() {
        String def = System.getProperty("http.proxyPort");
        if (def != null) {
            return this.getKeyValue("http.proxyPort", def);
        }
        return this.getKeyValue("http.proxyPort");
    }

    public final void setHttpNonProxyHosts(String httpNonProxyHosts) {
        this.setKeyValue("http.nonProxyHosts", httpNonProxyHosts);
    }

    public final String getHttpNonProxyHosts() {
        String def = System.getProperty("http.nonProxyHosts");
        if (def != null) {
            return this.getKeyValue("http.nonProxyHosts", def);
        }
        return this.getKeyValue("http.nonProxyHosts");
    }

    protected synchronized String getKeyValue(String key) {
        return this.configAccess.getString(key);
    }

    protected synchronized String getKeyValue(String key, String defaultValue) {
        return this.configAccess.getString(key, defaultValue);
    }

    protected synchronized void setKeyValue(String key, String value) {
        this.configAccess.setString(key, value);
    }

    protected synchronized int getKeyValue(String key, int defaultValue) {
        return this.configAccess.getInteger(key, defaultValue);
    }

    protected synchronized void setKeyValue(String key, int value) {
        this.configAccess.setInteger(key, value);
    }

    protected synchronized boolean getKeyValue(String key, boolean defaultValue) {
        return "true".equals(this.getKeyValue(key, defaultValue ? "true" : "false"));
    }

    protected void setKeyValue(String key, boolean value) {
        this.setKeyValue(key, value ? "true" : "false");
    }

    public Map getPluginEntries(Plugin plugin) {
        return this.configAccess.getProperties(plugin.getPluginId() + "$");
    }

    public String getPluginKeyValue(Plugin plugin, String key, String defaultValue) {
        return this.getKeyValue(plugin.getPluginId() + "$" + key, defaultValue);
    }

    public void setPluginKeyValue(Plugin plugin, String key, String value) {
        this.setKeyValue(plugin.getPluginId() + "$" + key, value);
    }

    public int getPluginKeyValue(Plugin plugin, String key, int defaultValue) {
        return this.getKeyValue(plugin.getPluginId() + "$" + key, defaultValue);
    }

    public void setPluginKeyValue(Plugin plugin, String key, int value) {
        this.setKeyValue(plugin.getPluginId() + "$" + key, value);
    }

    public boolean getPluginKeyValue(Plugin plugin, String key, boolean defaultValue) {
        return this.getKeyValue(plugin.getPluginId() + "$" + key, defaultValue);
    }

    public void setPluginKeyValue(Plugin plugin, String key, boolean value) {
        this.setKeyValue(plugin.getPluginId() + "$" + key, value);
    }
}

