/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.utf8;

import java.io.IOException;
import org.qedeq.base.io.AbstractOutput;
import org.qedeq.base.io.SourcePosition;
import org.qedeq.base.io.TextOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.DateUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.base.list.Element;
import org.qedeq.kernel.base.list.ElementList;
import org.qedeq.kernel.base.module.Author;
import org.qedeq.kernel.base.module.AuthorList;
import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.Chapter;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.Header;
import org.qedeq.kernel.base.module.Import;
import org.qedeq.kernel.base.module.ImportList;
import org.qedeq.kernel.base.module.Latex;
import org.qedeq.kernel.base.module.LatexList;
import org.qedeq.kernel.base.module.LinkList;
import org.qedeq.kernel.base.module.LiteratureItem;
import org.qedeq.kernel.base.module.LiteratureItemList;
import org.qedeq.kernel.base.module.LocationList;
import org.qedeq.kernel.base.module.Node;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proof;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.base.module.Section;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.base.module.Subsection;
import org.qedeq.kernel.base.module.UsedByList;
import org.qedeq.kernel.base.module.VariableList;
import org.qedeq.kernel.bo.QedeqBo;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelNodeBo;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.service.latex.LatexContentException;
import org.qedeq.kernel.bo.service.utf8.Latex2Utf8Parser;
import org.qedeq.kernel.bo.service.utf8.ReferenceFinder;
import org.qedeq.kernel.common.ModuleAddress;
import org.qedeq.kernel.common.ModuleContext;
import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.dto.module.NodeVo;
import org.qedeq.kernel.visitor.QedeqNumbers;

public class Qedeq2Utf8Visitor
extends ControlVisitor
implements ReferenceFinder {
    private static final Class CLASS = Qedeq2Utf8Visitor.class;
    private AbstractOutput printer;
    private String language;
    private final boolean info;
    private String id;
    private String title;
    private String subContext = "";
    private int maxColumns;
    private boolean addWarnings;
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";

    public Qedeq2Utf8Visitor(Plugin plugin, KernelQedeqBo prop, boolean info, int maximumColumn, boolean addWarnings) {
        super(plugin, prop);
        this.info = info;
        this.maxColumns = maximumColumn;
        this.addWarnings = addWarnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateUtf8(AbstractOutput printer, String language, String level) throws SourceFileExceptionList, IOException {
        this.printer = printer;
        this.printer.setColumns(this.maxColumns);
        this.language = language == null ? "en" : language;
        this.init();
        try {
            this.traverse();
        }
        finally {
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
        }
    }

    protected void init() {
        this.id = null;
        this.title = null;
        this.subContext = "";
    }

    public String[] getSupportedLanguages(QedeqBo prop) {
        if (!prop.isLoaded()) {
            return new String[0];
        }
        LatexList list = prop.getQedeq().getHeader().getTitle();
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).getLanguage();
        }
        return result;
    }

    public final void visitEnter(Qedeq qedeq) {
        if (this.printer instanceof TextOutput) {
            this.printer.println("================================================================================");
            this.printer.println("UTF-8-file     " + ((TextOutput)this.printer).getName());
            this.printer.println("Generated from " + this.getQedeqBo().getModuleAddress());
            this.printer.println("Generated at   " + DateUtility.getTimestamp());
            this.printer.println("================================================================================");
            this.printer.println();
            this.printer.println("If the characters of this document don't display correctly try opening this");
            this.printer.println("document within a webbrowser and if necessary change the encoding to");
            this.printer.println("Unicode (UTF-8)");
            this.printer.println();
            this.printer.println("Permission is granted to copy, distribute and/or modify this document");
            this.printer.println("under the terms of the GNU Free Documentation License, Version 1.2");
            this.printer.println("or any later version published by the Free Software Foundation;");
            this.printer.println("with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.");
            this.printer.println();
            this.printer.println();
            this.printer.println();
        }
    }

    public final void visitLeave(Qedeq qedeq) {
        this.printer.println();
    }

    public void visitEnter(Header header) {
        LatexList tit = header.getTitle();
        this.underlineBig(this.getLatexListEntry("getTitle()", tit));
        this.printer.println();
        AuthorList authors = this.getQedeqBo().getQedeq().getHeader().getAuthorList();
        StringBuffer authorList = new StringBuffer();
        for (int i = 0; i < authors.size(); ++i) {
            if (i > 0) {
                authorList.append("    \n");
                this.printer.println(", ");
            }
            Author author = authors.get(i);
            String name = author.getName().getLatex().trim();
            this.printer.print(name);
            authorList.append("    " + name);
            String email = author.getEmail();
            if (email == null || email.trim().length() <= 0) continue;
            authorList.append(" <" + email + ">");
        }
        this.printer.println();
        this.printer.println();
        String url = this.getQedeqBo().getUrl();
        if (url != null && url.length() > 0) {
            this.printer.println();
            if ("de".equals(this.language)) {
                this.printer.println("Die Quelle f\u00fcr dieses Dokument ist hier zu finden:");
            } else {
                if (!"en".equals(this.language)) {
                    this.printer.println("%%% TODO unknown language: " + this.language);
                }
                this.printer.println("The source for this document can be found here:");
            }
            this.printer.println();
            this.printer.println(url);
            this.printer.println();
        }
        this.printer.println();
        if ("de".equals(this.language)) {
            this.printer.println("Die vorliegende Publikation ist urheberrechtlich gesch\u00fctzt.");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("Copyright by the authors. All rights reserved.");
        }
        String email = header.getEmail();
        if (email != null && email.length() > 0) {
            this.printer.println();
            this.printer.println();
            if ("de".equals(this.language)) {
                this.printer.println("Bei Fragen, Anregungen oder Bitte um Aufnahme in die Liste der abh\u00e4ngigen Module schicken Sie bitte eine EMail an die Adresse " + email);
                this.printer.println();
                this.printer.println();
                this.printer.println("Die Autoren dieses Dokuments sind:");
                this.printer.println();
                this.printer.println(authorList);
            } else {
                if (!"en".equals(this.language)) {
                    this.printer.println("%%% TODO unknown language: " + this.language);
                }
                this.printer.println("If you have any questions, suggestions or want to add something to the list of modules that use this one, please send an email to the address " + email);
                this.printer.println();
                this.printer.println();
                this.printer.println("The authors of this document are:");
                this.printer.println(authorList);
            }
            this.printer.println();
        }
        this.printer.println();
        this.printer.println();
    }

    private String getUrl(ModuleAddress address, Specification specification) {
        LocationList list = specification.getLocationList();
        if (list == null || list.size() <= 0) {
            return "";
        }
        try {
            return address.getModulePaths(specification)[0].getUrl();
        }
        catch (IOException e) {
            return "";
        }
    }

    public void visitEnter(Chapter chapter) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        if (numbers.isChapterNumbering()) {
            if ("de".equals(this.language)) {
                this.printer.println("Kapitel " + numbers.getChapterNumber() + " ");
            } else {
                this.printer.println("Chapter " + numbers.getChapterNumber() + " ");
            }
            this.printer.println();
            this.printer.println();
        }
        this.underlineBig(this.getLatexListEntry("getTitle()", chapter.getTitle()));
        this.printer.println();
        if (chapter.getIntroduction() != null) {
            this.printer.append(this.getLatexListEntry("getIntroduction()", chapter.getIntroduction()));
            this.printer.println();
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitLeave(Header header) {
        this.printer.println();
        this.printer.println("___________________________________________________");
        this.printer.println();
        this.printer.println();
    }

    public void visitLeave(Chapter chapter) {
        this.printer.println();
        this.printer.println("___________________________________________________");
        this.printer.println();
        this.printer.println();
    }

    public void visitEnter(Section section) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        StringBuffer buffer = new StringBuffer();
        if (numbers.isChapterNumbering()) {
            buffer.append(numbers.getChapterNumber());
        }
        if (numbers.isSectionNumbering()) {
            if (buffer.length() > 0) {
                buffer.append(".");
            }
            buffer.append(numbers.getSectionNumber());
        }
        if (buffer.length() > 0 && section.getTitle() != null) {
            buffer.append(" ");
        }
        buffer.append(this.getLatexListEntry("getTitle()", section.getTitle()));
        this.underline(buffer.toString());
        this.printer.println();
        if (section.getIntroduction() != null) {
            this.printer.append(this.getLatexListEntry("getIntroduction()", section.getIntroduction()));
            this.printer.println();
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitLeave(Section section) {
        this.printer.println();
    }

    public void visitEnter(Subsection subsection) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        StringBuffer buffer = new StringBuffer();
        if (numbers.isChapterNumbering()) {
            buffer.append(numbers.getChapterNumber());
        }
        if (numbers.isSectionNumbering()) {
            if (buffer.length() > 0) {
                buffer.append(".");
            }
            buffer.append(numbers.getSectionNumber());
        }
        if (buffer.length() > 0) {
            buffer.append(".");
        }
        buffer.append(numbers.getSubsectionNumber());
        if (buffer.length() > 0 && subsection.getTitle() != null) {
            buffer.append(" ");
        }
        if (subsection.getTitle() != null) {
            this.printer.print(buffer.toString());
            this.printer.print(this.getLatexListEntry("getTitle()", subsection.getTitle()));
        }
        if (subsection.getId() != null && this.info) {
            this.printer.print("  [" + subsection.getId() + "]");
        }
        if (subsection.getTitle() != null) {
            this.printer.println();
            this.printer.println();
        }
        this.printer.append(this.getLatexListEntry("getLatex()", subsection.getLatex()));
        this.printer.println();
        this.printer.println();
    }

    public void visitEnter(Node node) {
        if (node.getPrecedingText() != null) {
            this.printer.append(this.getLatexListEntry("getPrecedingText()", node.getPrecedingText()));
            this.printer.println();
            this.printer.println();
        }
        this.id = node.getId();
        this.title = null;
        if (node.getTitle() != null) {
            this.title = this.getLatexListEntry("getTitle()", node.getTitle());
        }
    }

    public void visitLeave(Node node) {
        if (node.getSucceedingText() != null) {
            this.printer.append(this.getLatexListEntry("getSucceedingText()", node.getSucceedingText()));
            this.printer.println();
            this.printer.println();
        }
        this.printer.println();
    }

    public void visitEnter(Axiom axiom) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        this.printer.print("Axiom " + numbers.getAxiomNumber());
        this.printer.print(" ");
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        this.printer.print("     ");
        this.printFormula(axiom.getFormula().getElement());
        this.printer.println();
        if (axiom.getDescription() != null) {
            this.printer.append(this.getLatexListEntry("getDescription()", axiom.getDescription()));
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitEnter(Proposition proposition) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        this.printer.print("Proposition " + numbers.getPropositionNumber());
        this.printer.print(" ");
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        this.printTopFormula(proposition.getFormula().getElement(), this.id);
        this.printer.println();
        if (proposition.getDescription() != null) {
            this.printer.append(this.getLatexListEntry("getDescription()", proposition.getDescription()));
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitEnter(Proof proof) {
        if ("de".equals(this.language)) {
            this.printer.println("Beweis:");
        } else {
            this.printer.println("Proof:");
        }
        this.printer.append(this.getLatexListEntry("getNonFormalProof()", proof.getNonFormalProof()));
        this.printer.println();
        this.printer.println("q.e.d.");
        this.printer.println();
    }

    public void visitEnter(PredicateDefinition definition) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        StringBuffer buffer = new StringBuffer();
        if (definition.getFormula() == null) {
            if ("de".equals(this.language)) {
                buffer.append("initiale ");
            } else {
                buffer.append("initial ");
            }
        }
        buffer.append("Definition " + (numbers.getPredicateDefinitionNumber() + numbers.getFunctionDefinitionNumber()));
        this.printer.print(buffer.toString());
        this.printer.print(" ");
        StringBuffer define = new StringBuffer(this.getUtf8(definition.getLatexPattern()));
        VariableList list = definition.getVariableList();
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Trace.trace(CLASS, (Object)this, "printPredicateDefinition", "replacing!");
                StringUtility.replace(define, "#" + (i + 1), this.getUtf8(list.get(i)));
            }
        }
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        if (definition.getFormula() != null) {
            define.append("  :\u2194  ");
            define.append(this.getUtf8(definition.getFormula().getElement()));
        }
        Trace.param(CLASS, (Object)this, "printPredicateDefinition", "define", define);
        this.printer.print("     ");
        this.printer.println(define.toString());
        this.printer.println();
        if (definition.getDescription() != null) {
            this.printer.append(this.getLatexListEntry("getDescription()", definition.getDescription()));
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitEnter(FunctionDefinition definition) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        StringBuffer buffer = new StringBuffer();
        if (definition.getTerm() == null) {
            if ("de".equals(this.language)) {
                buffer.append("initiale ");
            } else {
                buffer.append("initial ");
            }
        }
        buffer.append("Definition " + (numbers.getPredicateDefinitionNumber() + numbers.getFunctionDefinitionNumber()));
        this.printer.print(buffer.toString());
        this.printer.print(" ");
        StringBuffer define = new StringBuffer(this.getUtf8(definition.getLatexPattern()));
        VariableList list = definition.getVariableList();
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Trace.trace(CLASS, (Object)this, "printFunctionDefinition", "replacing!");
                StringUtility.replace(define, "#" + (i + 1), this.getUtf8(list.get(i)));
            }
        }
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        if (definition.getTerm() != null) {
            define.append("  \u2254  ");
            define.append(this.getUtf8(definition.getTerm().getElement()));
        }
        Trace.param(CLASS, (Object)this, "printFunctionDefinition", "define", define);
        this.printer.print("     ");
        this.printer.println(define);
        this.printer.println();
        if (definition.getDescription() != null) {
            this.printer.println(this.getLatexListEntry("getDescription()", definition.getDescription()));
            this.printer.println();
        }
    }

    public void visitLeave(FunctionDefinition definition) {
    }

    public void visitEnter(Rule rule) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        if ("de".equals(this.language)) {
            this.printer.print("Regel");
        } else {
            this.printer.print("Rule");
        }
        this.printer.print(" " + numbers.getRuleNumber());
        this.printer.print(" ");
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        if (rule.getDescription() != null) {
            this.printer.append(this.getLatexListEntry("getDescription()", rule.getDescription()));
            this.printer.println();
            this.printer.println();
        }
        if (rule.getProofList() != null) {
            for (int i = 0; i < rule.getProofList().size(); ++i) {
                if ("de".equals(this.language)) {
                    this.printer.println("Beweis:");
                } else {
                    this.printer.println("Proof:");
                }
                this.printer.append(this.getLatexListEntry("getProofList().get(" + i + ")", rule.getProofList().get(i).getNonFormalProof()));
                this.printer.println();
                this.printer.println("q.e.d.");
                this.printer.println();
            }
        }
    }

    public void visitEnter(LinkList linkList) {
        if (linkList.size() <= 0) {
            return;
        }
        if ("de".equals(this.language)) {
            this.printer.println("Basierend auf: ");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("Based on: ");
        }
        for (int i = 0; i < linkList.size(); ++i) {
            if (linkList.get(i) == null) continue;
            this.printer.print(" \\ref{" + linkList.get(i) + "}");
        }
        this.printer.println();
    }

    public void visitEnter(LiteratureItemList list) {
        this.printer.println();
        this.printer.println();
        if ("de".equals(this.language)) {
            this.underlineBig("Literaturverzeichnis");
        } else {
            this.underlineBig("Bibliography");
        }
        this.printer.println();
        this.printer.println();
        ImportList imports = this.getQedeqBo().getQedeq().getHeader().getImportList();
        if (imports != null && imports.size() > 0) {
            this.printer.println();
            this.printer.println();
            if ("de".equals(this.language)) {
                this.printer.println("Benutzte andere QEDEQ-Module:");
            } else {
                this.printer.println("Used other QEDEQ modules:");
            }
            this.printer.println();
            for (int i = 0; i < imports.size(); ++i) {
                Import imp = imports.get(i);
                this.printer.print("[" + imp.getLabel() + "] ");
                Specification spec = imp.getSpecification();
                this.printer.print(spec.getName());
                if (spec.getLocationList() != null && spec.getLocationList().size() > 0 && spec.getLocationList().get(0).getLocation().length() > 0) {
                    this.printer.print("  ");
                    this.printer.print(this.getUrl(this.getQedeqBo().getModuleAddress(), spec));
                }
                this.printer.println();
            }
            this.printer.println();
            this.printer.println();
            if ("de".equals(this.language)) {
                this.printer.println("Andere Referenzen:");
            } else {
                this.printer.println("Other references:");
            }
            this.printer.println();
        }
    }

    public void visitLeave(LiteratureItemList list) {
        UsedByList usedby = this.getQedeqBo().getQedeq().getHeader().getUsedByList();
        if (usedby != null && usedby.size() > 0) {
            this.printer.println();
            this.printer.println();
            if ("de".equals(this.language)) {
                this.printer.println("QEDEQ-Module, welche dieses hier verwenden:");
            } else {
                this.printer.println("QEDEQ modules that use this one:");
            }
            for (int i = 0; i < usedby.size(); ++i) {
                Specification spec = usedby.get(i);
                this.printer.print(spec.getName());
                String url = this.getUrl(this.getQedeqBo().getModuleAddress(), spec);
                if (url != null && url.length() > 0) {
                    this.printer.print("  ");
                    this.printer.print(url);
                }
                this.printer.println();
            }
            this.printer.println();
            this.printer.println();
        }
        this.printer.println();
    }

    public void visitEnter(LiteratureItem item) {
        this.printer.print("[" + item.getLabel() + "] ");
        this.printer.println(this.getLatexListEntry("getItem()", item.getItem()));
        this.printer.println();
    }

    private void printTopFormula(Element element, String mainLabel) {
        if (!element.isList() || !element.getList().getOperator().equals("AND")) {
            this.printer.print("     ");
            this.printFormula(element);
            return;
        }
        ElementList list = element.getList();
        for (int i = 0; i < list.size(); ++i) {
            String label = "";
            if (list.size() >= ALPHABET.length() * ALPHABET.length()) {
                label = "" + (i + 1);
            } else {
                if (list.size() > ALPHABET.length()) {
                    int div = i / ALPHABET.length();
                    label = "" + ALPHABET.charAt(div);
                }
                label = label + ALPHABET.charAt(i % ALPHABET.length());
            }
            this.printer.println("  (" + label + ")  " + this.getUtf8(list.getElement(i)));
        }
    }

    private void printFormula(Element element) {
        this.printer.println(this.getUtf8(element));
    }

    private String getUtf8(Element element) {
        return this.getUtf8(this.getQedeqBo().getElement2Latex().getLatex(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLatexListEntry(String method, LatexList list) {
        if (list == null) {
            return "";
        }
        if (method.length() > 0) {
            this.subContext = method;
        }
        try {
            int i;
            for (i = 0; i < list.size(); ++i) {
                if (!this.language.equals(list.get(i).getLanguage())) continue;
                if (method.length() > 0) {
                    this.subContext = method + ".get(" + i + ")";
                }
                String string = this.getUtf8(list.get(i));
                return string;
            }
            for (i = 0; i < list.size(); ++i) {
                if (list.get(i).getLanguage() != null) continue;
                if (method.length() > 0) {
                    this.subContext = method + ".get(" + i + ")";
                }
                String string = this.getUtf8(list.get(i));
                return string;
            }
            i = 0;
            if (i < list.size()) {
                if (method.length() > 0) {
                    this.subContext = method + ".get(" + i + ")";
                }
                String string = "MISSING! OTHER: " + this.getUtf8(list.get(i));
                return string;
            }
            String string = "MISSING!";
            return string;
        }
        finally {
            if (method.length() > 0) {
                this.subContext = "";
            }
        }
    }

    private ModuleContext getCurrentContext(SourcePosition startDelta, SourcePosition endDelta) {
        if (this.subContext.length() == 0) {
            return super.getCurrentContext();
        }
        ModuleContext c = new ModuleContext(super.getCurrentContext().getModuleLocation(), super.getCurrentContext().getLocationWithinModule() + "." + this.subContext, startDelta, endDelta);
        return c;
    }

    public void addWarning(int code, String msg, SourcePosition startDelta, SourcePosition endDelta) {
        Trace.param(CLASS, (Object)this, "addWarning", "msg", msg);
        if (this.addWarnings) {
            this.addWarning(new LatexContentException(code, msg, this.getCurrentContext(startDelta, endDelta)));
        }
    }

    private String getUtf8(Latex latex) {
        if (latex == null || latex.getLatex() == null) {
            return "";
        }
        return this.getUtf8(latex.getLatex());
    }

    private String getUtf8(String latex) {
        if (latex == null) {
            return "";
        }
        return Latex2Utf8Parser.transform(this, latex, this.maxColumns);
    }

    private void underlineBig(String text) {
        this.printer.println(text);
        for (int i = 0; i < text.length(); ++i) {
            this.printer.print("\u2550");
        }
        this.printer.println();
    }

    private void underline(String text) {
        this.printer.println(text);
        for (int i = 0; i < text.length(); ++i) {
            this.printer.print("\u2015");
        }
        this.printer.println();
    }

    public String getReferenceLink(String reference, String subReference, SourcePosition startPosition, SourcePosition endPosition) {
        KernelNodeBo kNode;
        KernelQedeqBo refModule;
        String method = "getExternalReference(SourcePosition, SourcePosition, String, String)";
        String moduleLabel = "";
        String localLabel = reference;
        int dot = reference.indexOf(".");
        if (dot >= 0) {
            moduleLabel = reference.substring(0, dot);
            localLabel = reference.substring(dot + 1);
        }
        String fix = "";
        if (subReference != null && subReference.length() > 0) {
            fix = fix + " (" + subReference + ")";
        }
        KernelQedeqBo module = this.getQedeqBo();
        if (moduleLabel.length() == 0) {
            refModule = module.getKernelRequiredModules().getKernelQedeqBo(localLabel);
            if (refModule != null) {
                moduleLabel = localLabel;
                localLabel = "";
                module = refModule;
                return "[" + moduleLabel + "]";
            }
        } else {
            refModule = module.getKernelRequiredModules().getKernelQedeqBo(moduleLabel);
            if (refModule == null) {
                module = refModule;
                Trace.info(CLASS, this, "getExternalReference(SourcePosition, SourcePosition, String, String)", "module not found for " + moduleLabel);
                this.addWarning(80010, "parsing of \"\\qref{\" failed: module not found for " + reference, startPosition, endPosition);
                return moduleLabel + "?." + localLabel + fix;
            }
            module = refModule;
        }
        if (moduleLabel.length() > 0) {
            fix = fix + " [" + moduleLabel + "]";
        }
        if ((kNode = module.getLabels().getNode(localLabel)) != null) {
            return this.getNodeDisplay(kNode) + fix;
        }
        Trace.info(CLASS, this, "getExternalReference(SourcePosition, SourcePosition, String, String)", "node not found for " + reference);
        this.addWarning(80010, "parsing of \"\\qref{\" failed: node not found for " + reference, startPosition, endPosition);
        return localLabel + "?" + fix;
    }

    private String getNodeDisplay(KernelNodeBo kNode) {
        String display = "";
        QedeqNumbers data = kNode.getNumbers();
        NodeVo node = kNode.getNodeVo();
        if (node.getNodeType() instanceof Axiom) {
            display = "de".equals(this.language) ? "Axiom" : "axiom";
            display = display + " " + data.getAxiomNumber();
        } else if (node.getNodeType() instanceof Proposition) {
            display = "de".equals(this.language) ? "Proposition" : "proposition";
            display = display + " " + data.getPropositionNumber();
        } else if (node.getNodeType() instanceof FunctionDefinition) {
            display = "de".equals(this.language) ? "Definition" : "definition";
            display = display + " " + (data.getPredicateDefinitionNumber() + data.getFunctionDefinitionNumber());
        } else if (node.getNodeType() instanceof PredicateDefinition) {
            display = "de".equals(this.language) ? "Definition" : "definition";
            display = display + " " + (data.getPredicateDefinitionNumber() + data.getFunctionDefinitionNumber());
        } else if (node.getNodeType() instanceof Rule) {
            display = "de".equals(this.language) ? "Regel" : "rule";
            display = display + " " + data.getRuleNumber();
        } else {
            display = "de".equals(this.language) ? "Unbekannt " + node.getId() : "unknown " + node.getId();
        }
        return display;
    }
}

