/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.utf8;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.TextOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.context.KernelContext;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.bo.service.utf8.Qedeq2Utf8Visitor;
import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.common.SourceFileExceptionList;

public class Qedeq2Utf8Executor
implements PluginExecutor {
    private static final Class CLASS = Qedeq2Utf8Executor.class;
    private TextOutput printer;
    private File destination;
    private final Qedeq2Utf8Visitor visitor;
    private int maxColumns;
    private String[] languages;
    private int run = 0;

    public Qedeq2Utf8Executor(Plugin plugin, KernelQedeqBo prop, Map parameters) {
        String infoString = null;
        String maxColumnsString = "0";
        if (parameters != null) {
            infoString = (String)parameters.get("info");
            if (infoString == null) {
                infoString = "false";
            }
            if ((maxColumnsString = (String)parameters.get("maximumColumn")) == null || maxColumnsString.length() == 0) {
                maxColumnsString = "80";
            }
        }
        boolean info = "true".equalsIgnoreCase(infoString);
        this.maxColumns = 0;
        try {
            this.maxColumns = Integer.parseInt(maxColumnsString.trim());
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.visitor = new Qedeq2Utf8Visitor(plugin, prop, info, this.maxColumns, true);
    }

    public Object executePlugin() {
        String method = "executePlugin()";
        String ref = "\"" + IoUtility.easyUrl(this.visitor.getQedeqBo().getUrl()) + "\"";
        try {
            QedeqLog.getInstance().logRequest("Generate UTF-8 from " + ref);
            this.languages = this.visitor.getSupportedLanguages(this.visitor.getQedeqBo());
            this.run = 0;
            while (this.run < this.languages.length) {
                String result = this.generateUtf8(this.languages[this.run], "1");
                if (this.languages[this.run] != null) {
                    QedeqLog.getInstance().logSuccessfulReply("UTF-8 for language \"" + this.languages[this.run] + "\" was generated from " + ref + " into \"" + result + "\"");
                } else {
                    QedeqLog.getInstance().logSuccessfulReply("UTF-8 for default language was generated from " + ref + " into \"" + result + "\"");
                }
                ++this.run;
            }
        }
        catch (SourceFileExceptionList e) {
            String msg = "Generation failed for " + ref;
            Trace.fatal(CLASS, this, "executePlugin()", msg, e);
            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
        }
        catch (IOException e) {
            String msg = "Generation failed for " + ref;
            Trace.fatal(CLASS, this, "executePlugin()", msg, e);
            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "executePlugin()", "unexpected problem", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", "unexpected problem: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateUtf8(String language, String level) throws SourceFileExceptionList, IOException {
        String txt;
        try {
            KernelContext.getInstance().loadRequiredModules(this.visitor.getQedeqBo().getModuleAddress());
            KernelContext.getInstance().checkModule(this.visitor.getQedeqBo().getModuleAddress());
        }
        catch (Exception e) {
            Trace.trace(CLASS, "generateUtf8(KernelQedeqBo, String, String)", e);
        }
        String lan = "en";
        if (language != null) {
            lan = language;
        }
        if ((txt = this.visitor.getQedeqBo().getModuleAddress().getFileName()).toLowerCase(Locale.US).endsWith(".xml")) {
            txt = txt.substring(0, txt.length() - 4);
        }
        if (lan != null && lan.length() > 0) {
            txt = txt + "_" + lan;
        }
        this.destination = new File(KernelContext.getInstance().getConfig().getGenerationDirectory(), txt + ".txt").getCanonicalFile();
        this.printer = new TextOutput(this.visitor.getQedeqBo().getName(), new FileOutputStream(this.destination), "UTF-8");
        try {
            this.visitor.generateUtf8(this.printer, lan, level);
        }
        finally {
            if (this.printer != null) {
                this.printer.flush();
                this.printer.close();
            }
        }
        if (this.printer != null && this.printer.checkError()) {
            throw this.printer.getError();
        }
        return this.destination.toString();
    }

    public String getExecutionActionDescription() {
        if (this.languages != null && this.run < this.languages.length) {
            return this.languages[this.run] + " " + this.visitor.getExecutionActionDescription();
        }
        if (this.languages != null && this.languages.length > 0) {
            return this.languages[this.languages.length] + " " + this.visitor.getExecutionActionDescription();
        }
        return "unknown";
    }

    public double getExecutionPercentage() {
        return this.visitor.getExecutionPercentage() / (double)this.languages.length * (double)(this.run + 1);
    }
}

