/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.utf8;

import org.qedeq.base.io.TextInput;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.parser.MementoTextInput;

public final class LatexTextParser {
    private static final Class CLASS = LatexTextParser.class;
    private static final String SPECIALCHARACTERS = "(),{}\\~%$&";
    private MementoTextInput input;
    private StringBuffer output;

    public static final String transform(String input) {
        LatexTextParser parser = new LatexTextParser(input);
        return parser.parse();
    }

    private LatexTextParser(String input) {
        this.input = new MementoTextInput(new TextInput(input));
        this.output = new StringBuffer();
    }

    private String parse() {
        while (!this.eof()) {
            String token = this.readToken();
            if ("\\begin".equals(token)) {
                String curly = this.readCurlyBraceContents();
                if ("eqnarray".equals(curly)) {
                    this.printMathTillEnd(curly);
                    continue;
                }
                if ("eqnarray*".equals(curly)) {
                    this.printMathTillEnd(curly);
                    continue;
                }
                if ("equation".equals(curly)) {
                    this.printMathTillEnd(curly);
                    continue;
                }
                if ("equation*".equals(curly)) {
                    this.printMathTillEnd(curly);
                    continue;
                }
                this.print(token + "{" + curly + "}");
                continue;
            }
            if ("$$".equals(token)) {
                this.println();
                this.println("<MATH>");
                this.printMathTillToken(token);
                this.println("\\,</MATH>");
                this.println();
                continue;
            }
            if ("$".equals(token)) {
                this.print("<MATH>");
                this.printMathTillToken(token);
                this.print("\\,</MATH>");
                continue;
            }
            this.print(token);
        }
        return this.output.toString();
    }

    private void printMathTillEnd(String curly) {
        StringBuffer buffer = new StringBuffer();
        while (true) {
            String item;
            if ("\\end".equals(item = this.readToken())) {
                String curly2 = this.readCurlyBraceContents();
                if (curly.equals(curly2)) break;
                buffer.append(item + "{" + curly2 + "}");
                continue;
            }
            buffer.append(item);
        }
        this.printMath(buffer);
    }

    private void printMathTillToken(String token) {
        String item;
        StringBuffer buffer = new StringBuffer();
        while (!token.equals(item = this.readToken())) {
            buffer.append(item);
        }
        this.printMath(buffer);
    }

    private void printMath(StringBuffer buffer) {
        this.print(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String readToken() {
        String method = "readToken()";
        Trace.begin(CLASS, this, "readToken()");
        StringBuffer token = new StringBuffer();
        try {
            block8: do {
                if (this.eof()) {
                    if (token.length() > 0) break;
                    token = null;
                    break;
                }
                int c = this.getChar();
                if (Character.isDigit((char)c)) {
                    token.append((char)this.readChar());
                    if (!Character.isDigit((char)this.getChar())) break;
                    continue;
                }
                if (Character.isLetter((char)c)) {
                    token.append((char)this.readChar());
                    if (!Character.isLetter((char)this.getChar())) break;
                    continue;
                }
                if (SPECIALCHARACTERS.indexOf(c) >= 0) {
                    switch (c) {
                        case 37: 
                        case 38: 
                        case 123: 
                        case 125: 
                        case 126: {
                            token.append((char)this.readChar());
                            break;
                        }
                        case 36: {
                            token.append((char)this.readChar());
                            if (36 != this.getChar()) break block8;
                            continue block8;
                        }
                        case 92: {
                            String t = this.readBackslashToken();
                            token.append(t);
                            if (95 != this.getChar() && 94 != this.getChar()) break block8;
                            token.append((char)this.readChar());
                            continue block8;
                        }
                        default: {
                            this.readChar();
                            token.append((char)c);
                            break;
                        }
                    }
                    break;
                }
                token.append((char)this.readChar());
                if (95 != this.getChar() && 94 != this.getChar()) break;
                token.append((char)this.readChar());
            } while (!this.eof());
            Trace.param(CLASS, (Object)this, "readToken()", "Read token", token);
            String string = token != null ? token.toString() : null;
            return string;
        }
        finally {
            Trace.end(CLASS, this, "readToken()");
        }
    }

    private String readBackslashToken() {
        String method = "readBackslashToken()";
        Trace.begin(CLASS, this, "readBackslashToken()");
        if (this.getChar() != 92) {
            throw new IllegalArgumentException("\\ expected");
        }
        this.readChar();
        if (this.eof()) {
            Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", null);
            Trace.end(CLASS, this, "readBackslashToken()");
            return null;
        }
        if (!Character.isLetter((char)this.getChar())) {
            Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", (char)this.getChar());
            Trace.end(CLASS, this, "readBackslashToken()");
            return "\\" + (char)this.readChar();
        }
        StringBuffer buffer = new StringBuffer("\\");
        do {
            buffer.append((char)this.readChar());
        } while (!this.eof() && Character.isLetter((char)this.getChar()));
        Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", buffer.toString());
        Trace.end(CLASS, this, "readBackslashToken()");
        return buffer.toString();
    }

    private String readCurlyBraceContents() {
        String first = this.readToken();
        if (!"{".equals(first)) {
            throw new IllegalArgumentException("\"{\" expected, but was: \"" + first + "\"");
        }
        StringBuffer buffer = new StringBuffer();
        int level = 1;
        while (level > 0) {
            String next = this.readToken();
            if ("{".equals(next)) {
                ++level;
            } else if ("}".equals(next)) {
                --level;
            }
            if (level <= 0) break;
            buffer.append(next);
        }
        return buffer.toString();
    }

    private final void print(String line) {
        this.output.append(line);
    }

    private final void println() {
        this.println("");
    }

    private final void println(String line) {
        this.print(line);
        this.print("\n");
    }

    public final String getToken() {
        this.markPosition();
        String result = this.readToken();
        this.rewindPosition();
        return result;
    }

    protected final void markPosition() {
        this.input.markPosition();
    }

    protected final long rewindPosition() {
        return this.input.rewindPosition();
    }

    protected final void clearMark() {
        this.input.clearMark();
    }

    protected long getPosition() {
        return this.input.getPosition();
    }

    protected final int getChar() {
        return this.input.getChar();
    }

    protected final int readChar() {
        return this.input.read();
    }

    public final boolean eof() {
        return this.input.isEmpty();
    }

    public final int getRewindStackSize() {
        return this.input.getRewindStackSize();
    }
}

