/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.Formula;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.base.module.Term;
import org.qedeq.kernel.base.module.VariableList;
import org.qedeq.kernel.bo.logic.FormulaChecker;
import org.qedeq.kernel.bo.logic.wf.Function;
import org.qedeq.kernel.bo.logic.wf.LogicalCheckExceptionList;
import org.qedeq.kernel.bo.logic.wf.Predicate;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.service.CheckRequiredModuleException;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.bo.service.ModuleConstantsExistenceChecker;
import org.qedeq.kernel.common.IllegalModuleDataException;
import org.qedeq.kernel.common.LogicalState;
import org.qedeq.kernel.common.ModuleDataException;
import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.dto.list.ElementSet;

public final class QedeqBoFormalLogicChecker
extends ControlVisitor
implements Plugin {
    private static final Class CLASS = QedeqBoFormalLogicChecker.class;
    private ModuleConstantsExistenceChecker existence;

    private QedeqBoFormalLogicChecker(KernelQedeqBo prop) {
        super(prop);
    }

    public static void check(DefaultKernelQedeqBo prop) throws SourceFileExceptionList {
        if (prop.isChecked()) {
            return;
        }
        if (!prop.hasLoadedRequiredModules()) {
            throw new IllegalStateException("QEDEQ module has not loaded with required files: " + prop);
        }
        prop.setLogicalProgressState(LogicalState.STATE_EXTERNAL_CHECKING);
        KernelModuleReferenceList list = (KernelModuleReferenceList)prop.getRequiredModules();
        QedeqBoFormalLogicChecker checker = new QedeqBoFormalLogicChecker(prop);
        for (int i = 0; i < list.size(); ++i) {
            try {
                Trace.trace(CLASS, (Object)"check(DefaultQedeqBo)", "checking label", list.getLabel(i));
                QedeqBoFormalLogicChecker.check((DefaultKernelQedeqBo)list.getKernelQedeqBo(i));
                continue;
            }
            catch (SourceFileExceptionList e) {
                CheckRequiredModuleException md = new CheckRequiredModuleException(11231, "import check failed: " + list.getQedeqBo(i).getModuleAddress(), list.getModuleContext(i));
                SourceFileExceptionList sfl = prop.createSourceFileExceptionList(checker, md);
                prop.setLogicalFailureState(LogicalState.STATE_EXTERNAL_CHECKING_FAILED, sfl);
                throw e;
            }
        }
        prop.setLogicalProgressState(LogicalState.STATE_INTERNAL_CHECKING);
        try {
            checker.traverse();
        }
        catch (SourceFileExceptionList sfl) {
            prop.setLogicalFailureState(LogicalState.STATE_INTERNAL_CHECKING_FAILED, sfl);
            throw sfl;
        }
        prop.setChecked(checker.existence);
    }

    public String getPluginId() {
        return CLASS.getName();
    }

    public String getPluginName() {
        return "Verifier";
    }

    public String getPluginDescription() {
        return "checks mathematical correctness";
    }

    public void traverse() throws SourceFileExceptionList {
        try {
            this.existence = new ModuleConstantsExistenceChecker(this.getQedeqBo());
        }
        catch (ModuleDataException me) {
            this.addError(me);
            throw this.getErrorList();
        }
        super.traverse();
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = axiom.getFormula();
            LogicalCheckExceptionList list = FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        Predicate predicate = new Predicate(definition.getName(), definition.getArgumentNumber());
        if (this.existence.predicateExists(predicate)) {
            this.addError(new IllegalModuleDataException(40400, "predicate was already defined for this argument number: " + predicate, this.getCurrentContext()));
        }
        if (definition.getFormula() != null) {
            Formula formula = definition.getFormula();
            VariableList variableList = definition.getVariableList();
            int size = variableList == null ? 0 : variableList.size();
            ElementSet free = FormulaChecker.getFreeSubjectVariables(formula.getElement());
            for (int i = 0; i < size; ++i) {
                this.setLocationWithinModule(context + ".getVariableList().get(" + i + ")");
                if (!FormulaChecker.isSubjectVariable(variableList.get(i))) {
                    this.addError(new IllegalModuleDataException(40500, "a subject variable was expected here, but we found: " + variableList.get(i), this.getCurrentContext()));
                }
                if (free.contains(variableList.get(i))) continue;
                this.addError(new IllegalModuleDataException(40510, "subject variable doesn't occur free in formula or term: " + variableList.get(i), this.getCurrentContext()));
            }
            this.setLocationWithinModule(context);
            if (size != free.size()) {
                this.addError(new IllegalModuleDataException(40520, "number of subject variables in definition not equal to number of free subject variables of formula or term", this.getCurrentContext()));
            }
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            LogicalCheckExceptionList list = FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        }
        this.existence.add(definition);
        if ("2".equals(predicate.getArguments()) && "equal".equals(predicate.getName())) {
            this.existence.setIdentityOperatorDefined(predicate.getName(), (DefaultKernelQedeqBo)this.getQedeqBo(), this.getCurrentContext());
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        Function function = new Function(definition.getName(), definition.getArgumentNumber());
        if (this.existence.functionExists(function)) {
            this.addError(new IllegalModuleDataException(40400, "function was already defined for this argument number: " + function, this.getCurrentContext()));
        }
        if (definition.getTerm() != null) {
            Term term = definition.getTerm();
            VariableList variableList = definition.getVariableList();
            int size = variableList == null ? 0 : variableList.size();
            ElementSet free = FormulaChecker.getFreeSubjectVariables(term.getElement());
            for (int i = 0; i < size; ++i) {
                this.setLocationWithinModule(context + ".getVariableList().get(" + i + ")");
                if (!FormulaChecker.isSubjectVariable(variableList.get(i))) {
                    this.addError(new IllegalModuleDataException(40500, "a subject variable was expected here, but we found: " + variableList.get(i), this.getCurrentContext()));
                }
                if (free.contains(variableList.get(i))) continue;
                this.addError(new IllegalModuleDataException(40510, "subject variable doesn't occur free in formula or term: " + variableList.get(i), this.getCurrentContext()));
            }
            this.setLocationWithinModule(context);
            if (size != free.size()) {
                this.addError(new IllegalModuleDataException(40520, "number of subject variables in definition not equal to number of free subject variables of formula or term", this.getCurrentContext()));
            }
            this.setLocationWithinModule(context + ".getTerm().getElement()");
            LogicalCheckExceptionList list = FormulaChecker.checkTerm(term.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        }
        this.existence.add(definition);
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (proposition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = proposition.getFormula();
            LogicalCheckExceptionList list = FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(Proposition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        if (rule == null) {
            return;
        }
        if (rule.getName() != null && "SET_DEFINION_BY_FORMULA".equals(rule.getName())) {
            this.existence.setClassOperatorModule((DefaultKernelQedeqBo)this.getQedeqBo(), this.getCurrentContext());
        }
        this.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.setBlocked(false);
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }
}

