/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.qedeq.kernel.bo.module.PluginBo;
import org.qedeq.kernel.bo.module.PluginResults;
import org.qedeq.kernel.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.common.SourceFileExceptionList;

public class PluginResultManager {
    private final Map plugins = new HashMap();

    synchronized PluginBo[] getPlugins() {
        return this.plugins.keySet().toArray(new PluginBo[0]);
    }

    public void removeAllResults() {
        this.plugins.clear();
    }

    public synchronized void setResult(PluginBo plugin, SourceFileExceptionList errors, SourceFileExceptionList warnings) {
        PluginResults results = (PluginResults)this.plugins.get(plugin);
        if (results == null) {
            results = new PluginResults();
            this.plugins.put(plugin, results);
        }
        results.clear();
        results.addErrors(errors);
        results.addWarnings(warnings);
    }

    public synchronized void addResult(Plugin plugin, SourceFileExceptionList errors, SourceFileExceptionList warnings) {
        PluginResults results = (PluginResults)this.plugins.get(plugin);
        if (results == null) {
            results = new PluginResults();
            this.plugins.put(plugin, results);
        }
        results.addErrors(errors);
        results.addWarnings(warnings);
    }

    public SourceFileExceptionList getAllErrors() {
        DefaultSourceFileExceptionList errors = new DefaultSourceFileExceptionList();
        Iterator iterator = this.plugins.keySet().iterator();
        while (iterator.hasNext()) {
            errors.add(((PluginResults)this.plugins.get(iterator.next())).getErrors());
        }
        return errors;
    }

    public SourceFileExceptionList getAllWarnings() {
        DefaultSourceFileExceptionList warnings = new DefaultSourceFileExceptionList();
        Iterator iterator = this.plugins.keySet().iterator();
        while (iterator.hasNext()) {
            warnings.add(((PluginResults)this.plugins.get(iterator.next())).getWarnings());
        }
        return warnings;
    }

    public synchronized String getPluginStateDescription() {
        StringBuffer text = new StringBuffer();
        Iterator iterator = this.plugins.keySet().iterator();
        while (iterator.hasNext()) {
            if (text.length() > 0) {
                text.append(", ");
            }
            PluginBo key = (PluginBo)iterator.next();
            PluginResults result = (PluginResults)this.plugins.get(key);
            text.append(key.getPluginName());
            text.append(" ");
            if (result.hasErrors() && result.hasWarnings()) {
                text.append("has errors and warnings");
                continue;
            }
            if (result.hasErrors()) {
                text.append("has errors");
                continue;
            }
            if (result.hasWarnings()) {
                text.append("has warnings");
                continue;
            }
            text.append("successful");
        }
        return text.toString();
    }
}

