/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.Import;
import org.qedeq.kernel.base.module.Node;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.Element2Latex;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.ModuleLabels;
import org.qedeq.kernel.common.ModuleDataException;
import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.dto.module.NodeVo;

public final class ModuleLabelsCreator
extends ControlVisitor {
    private static final Class CLASS = ModuleLabelsCreator.class;
    private ModuleLabels labels;
    private Element2Latex converter;

    public ModuleLabelsCreator(Plugin plugin, KernelQedeqBo prop) {
        super(plugin, prop);
    }

    public void visitEnter(Import imp) {
        try {
            this.labels.addLabel(this.getCurrentContext(), imp.getLabel());
        }
        catch (ModuleDataException me) {
            this.addError(me);
            Trace.trace(CLASS, (Object)this, "visitEnter(Import)", (Throwable)me);
        }
    }

    public void visitEnter(Axiom axiom) {
        this.setBlocked(true);
    }

    public void visitEnter(Proposition proposition) {
        this.setBlocked(true);
    }

    public void visitEnter(FunctionDefinition funcDef) {
        this.setBlocked(true);
        this.converter.addFunction(funcDef, this.getCurrentContext());
    }

    public void visitEnter(PredicateDefinition predDef) {
        this.setBlocked(true);
        this.converter.addPredicate(predDef, this.getCurrentContext());
    }

    public void visitEnter(Rule rule) {
        this.setBlocked(true);
    }

    public void visitLeave(Node node) {
        try {
            this.labels.addNode(this.getCurrentContext(), (NodeVo)node, this.getQedeqBo(), this.getCurrentNumbers());
        }
        catch (ModuleDataException me) {
            this.addError(me);
            Trace.trace(CLASS, (Object)this, "visitEnter(Node)", (Throwable)me);
        }
        this.setBlocked(false);
    }

    public void createLabels() throws SourceFileExceptionList {
        if (this.labels == null) {
            this.labels = new ModuleLabels();
            this.converter = new Element2Latex();
            this.traverse();
        }
    }

    public ModuleLabels getLabels() {
        return this.labels;
    }

    public Element2Latex getConverter() {
        return this.converter;
    }
}

