/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.bo.ModuleReferenceList;
import org.qedeq.kernel.bo.logic.wf.Function;
import org.qedeq.kernel.bo.logic.wf.Predicate;
import org.qedeq.kernel.bo.module.DefaultExistenceChecker;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.ModuleConstantsExistenceCheckerInterface;
import org.qedeq.kernel.bo.service.ClassOperatorAlreadyExistsException;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.bo.service.IdentityOperatorAlreadyExistsException;
import org.qedeq.kernel.common.ModuleContext;
import org.qedeq.kernel.common.ModuleDataException;

public class ModuleConstantsExistenceChecker
extends DefaultExistenceChecker
implements ModuleConstantsExistenceCheckerInterface {
    private final KernelQedeqBo prop;
    private KernelQedeqBo classOperatorModule;
    private KernelQedeqBo identityOperatorModule;

    public ModuleConstantsExistenceChecker(KernelQedeqBo prop) throws ModuleDataException {
        this.prop = prop;
        this.init();
    }

    public final void init() throws ModuleDataException {
        this.clear();
        ModuleReferenceList list = this.prop.getRequiredModules();
        for (int i = 0; i < list.size(); ++i) {
            DefaultKernelQedeqBo bo = (DefaultKernelQedeqBo)list.getQedeqBo(i);
            if (bo.getExistenceChecker().identityOperatorExists()) {
                String identityOperator = list.getLabel(i) + "." + bo.getExistenceChecker().getIdentityOperator();
                this.setIdentityOperatorDefined(identityOperator, bo.getExistenceChecker().getIdentityOperatorModule(), list.getModuleContext(i));
            }
            if (!bo.getExistenceChecker().classOperatorExists()) continue;
            this.setClassOperatorModule(bo.getExistenceChecker().getClassOperatorModule(), list.getModuleContext(i));
        }
    }

    public boolean predicateExists(Predicate predicate) {
        String name = predicate.getName();
        String arguments = predicate.getArguments();
        int external = name.indexOf(46);
        if (external < 0) {
            return super.predicateExists(predicate);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        DefaultKernelQedeqBo newProp = (DefaultKernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return false;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().predicateExists(new Predicate(shortName, arguments));
    }

    public boolean functionExists(Function function) {
        String name = function.getName();
        String arguments = function.getArguments();
        int external = name.indexOf(".");
        if (external < 0) {
            return super.functionExists(function);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        DefaultKernelQedeqBo newProp = (DefaultKernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return false;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().functionExists(new Function(shortName, arguments));
    }

    public PredicateDefinition get(Predicate predicate) {
        String name = predicate.getName();
        String arguments = predicate.getArguments();
        int external = name.indexOf(46);
        if (external < 0) {
            return super.get(predicate);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        DefaultKernelQedeqBo newProp = (DefaultKernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return null;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().get(new Predicate(shortName, arguments));
    }

    public FunctionDefinition get(Function function) {
        String name = function.getName();
        String arguments = function.getArguments();
        int external = name.indexOf(".");
        if (external < 0) {
            return super.get(function);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        DefaultKernelQedeqBo newProp = (DefaultKernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return null;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().get(new Function(shortName, arguments));
    }

    public KernelQedeqBo getQedeq(Function function) {
        String name = function.getName();
        String arguments = function.getArguments();
        int external = name.indexOf(".");
        if (external < 0) {
            if (this.functionExists(function)) {
                return this.prop;
            }
            return null;
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        DefaultKernelQedeqBo newProp = (DefaultKernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return newProp;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().getQedeq(new Function(shortName, arguments));
    }

    public KernelQedeqBo getQedeq(Predicate predicate) {
        String name = predicate.getName();
        String arguments = predicate.getArguments();
        int external = name.indexOf(".");
        if (external < 0) {
            if (this.predicateExists(predicate)) {
                return this.prop;
            }
            return null;
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        DefaultKernelQedeqBo newProp = (DefaultKernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return newProp;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().getQedeq(new Predicate(shortName, arguments));
    }

    public boolean classOperatorExists() {
        return this.classOperatorModule != null;
    }

    public void setIdentityOperatorDefined(String identityOperator, KernelQedeqBo identityOperatorModule, ModuleContext context) throws IdentityOperatorAlreadyExistsException {
        if (this.identityOperatorModule != null && identityOperatorModule != null) {
            if (!this.identityOperatorModule.equals(identityOperatorModule)) {
                throw new IdentityOperatorAlreadyExistsException(123476, "identity operator already defined with " + this.getIdentityOperator(), context);
            }
        } else {
            this.identityOperatorModule = identityOperatorModule;
            super.setIdentityOperatorDefined(identityOperator);
        }
    }

    public KernelQedeqBo getClassOperatorModule() {
        return this.classOperatorModule;
    }

    public KernelQedeqBo getIdentityOperatorModule() {
        return this.identityOperatorModule;
    }

    public void setClassOperatorModule(KernelQedeqBo classOperatorModule, ModuleContext context) throws ClassOperatorAlreadyExistsException {
        if (this.classOperatorModule != null && classOperatorModule != null) {
            if (!this.classOperatorModule.equals(classOperatorModule)) {
                throw new ClassOperatorAlreadyExistsException(123478, "class operator already defined within " + this.classOperatorModule.getUrl(), context);
            }
        } else {
            this.classOperatorModule = classOperatorModule;
        }
    }
}

