/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.HashMap;
import java.util.Map;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.bo.service.LoadDirectlyRequiredModules;
import org.qedeq.kernel.bo.service.LoadRequiredModuleException;
import org.qedeq.kernel.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.common.DependencyState;
import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.common.SourceFileException;
import org.qedeq.kernel.common.SourceFileExceptionList;

public final class LoadRequiredModules {
    private static final Class CLASS = LoadRequiredModules.class;
    private final Map loadingRequiredInProgress = new HashMap();

    private LoadRequiredModules() {
    }

    public static void loadRequired(Plugin plugin, DefaultKernelQedeqBo prop) throws SourceFileExceptionList {
        if (prop.getDependencyState().areAllRequiredLoaded()) {
            return;
        }
        new LoadRequiredModules().loadAllRequired(plugin, prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllRequired(Plugin plugin, DefaultKernelQedeqBo prop) throws SourceFileExceptionList {
        String method = "loadRequired(DefaultQedeqBo)";
        Trace.param(CLASS, (Object)this, "loadRequired(DefaultQedeqBo)", "prop.getModuleAddress", prop.getModuleAddress());
        DefaultKernelQedeqBo defaultKernelQedeqBo = prop;
        synchronized (defaultKernelQedeqBo) {
            if (prop.getDependencyState().areAllRequiredLoaded()) {
                return;
            }
            if (!prop.isLoaded()) {
                throw new IllegalArgumentException("Programming error BO must be loaded!");
            }
            if (this.loadingRequiredInProgress.containsKey(prop)) {
                throw new IllegalStateException("Programming error: must not be marked!");
            }
            prop.setDependencyProgressState(DependencyState.STATE_LOADING_REQUIRED_MODULES);
            this.loadingRequiredInProgress.put(prop, prop);
        }
        SourceFileExceptionList sfl = null;
        LoadDirectlyRequiredModules loader = new LoadDirectlyRequiredModules(plugin, prop);
        KernelModuleReferenceList required = null;
        try {
            required = loader.load();
            sfl = loader.getErrorList();
        }
        catch (DefaultSourceFileExceptionList e) {
            sfl = e;
        }
        if (sfl == null) {
            for (int i = 0; i < required.size(); ++i) {
                Trace.trace(CLASS, (Object)this, "loadRequired(DefaultQedeqBo)", "loading required modules of " + prop.getUrl());
                DefaultKernelQedeqBo current = null;
                current = (DefaultKernelQedeqBo)required.getKernelQedeqBo(i);
                if (this.loadingRequiredInProgress.containsKey(current)) {
                    LoadRequiredModuleException me = new LoadRequiredModuleException(12, "recursive import of modules is forbidden, label \"" + required.getLabel(i) + "\"", required.getModuleContext(i));
                    SourceFileException sf = prop.createSourceFileException(plugin, me);
                    if (sfl == null) {
                        sfl = new DefaultSourceFileExceptionList(sf);
                        continue;
                    }
                    sfl.add(sf);
                    continue;
                }
                try {
                    this.loadAllRequired(plugin, current);
                    continue;
                }
                catch (SourceFileExceptionList e) {
                    LoadRequiredModuleException me = new LoadRequiredModuleException(13, "import of module \"" + required.getLabel(i) + "\" failed: " + e.get(0).getMessage(), required.getModuleContext(i));
                    SourceFileException sf = prop.createSourceFileException(plugin, me);
                    if (sfl == null) {
                        sfl = new DefaultSourceFileExceptionList(sf);
                        continue;
                    }
                    sfl.add(sf);
                }
            }
        }
        DefaultKernelQedeqBo defaultKernelQedeqBo2 = prop;
        synchronized (defaultKernelQedeqBo2) {
            this.loadingRequiredInProgress.remove(prop);
            if (prop.getDependencyState().areAllRequiredLoaded()) {
                return;
            }
            if (sfl != null) {
                prop.setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, sfl);
                throw sfl;
            }
            prop.setLoadedRequiredModules(required);
            prop.getElement2Latex().setModuleReferences(required);
        }
    }
}

