/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import org.qedeq.base.io.SourceArea;
import org.qedeq.base.io.SourcePosition;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.bo.ModuleReferenceList;
import org.qedeq.kernel.bo.module.Element2Latex;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.ModuleConstantsExistenceCheckerInterface;
import org.qedeq.kernel.bo.module.ModuleLabels;
import org.qedeq.kernel.bo.module.QedeqFileDao;
import org.qedeq.kernel.bo.service.ModuleConstantsExistenceChecker;
import org.qedeq.kernel.bo.service.StateManager;
import org.qedeq.kernel.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.common.DependencyState;
import org.qedeq.kernel.common.LoadingState;
import org.qedeq.kernel.common.LogicalState;
import org.qedeq.kernel.common.ModuleAddress;
import org.qedeq.kernel.common.ModuleContext;
import org.qedeq.kernel.common.ModuleDataException;
import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.common.SourceFileException;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.dto.module.QedeqVo;

public class DefaultKernelQedeqBo
implements KernelQedeqBo {
    private static final Class CLASS = DefaultKernelQedeqBo.class;
    private final InternalKernelServices services;
    private final ModuleAddress address;
    private QedeqVo qedeq;
    private KernelModuleReferenceList required;
    private KernelModuleReferenceList dependent;
    private ModuleConstantsExistenceCheckerInterface checker;
    private ModuleLabels labels;
    private Element2Latex converter;
    private QedeqFileDao loader;
    private final StateManager stateManager;

    public DefaultKernelQedeqBo(InternalKernelServices services, ModuleAddress address) {
        this.services = services;
        this.address = address;
        if (address == null) {
            throw new NullPointerException("ModuleAddress must not be null");
        }
        this.required = new KernelModuleReferenceList();
        this.dependent = new KernelModuleReferenceList();
        this.stateManager = new StateManager(this);
    }

    public void setQedeqFileDao(QedeqFileDao loader) {
        this.loader = loader;
    }

    public QedeqFileDao getLoader() {
        return this.loader;
    }

    public boolean hasBasicFailures() {
        return this.stateManager.hasBasicFailures();
    }

    public boolean hasErrors() {
        return this.stateManager.hasErrors();
    }

    public boolean hasWarnings() {
        return this.stateManager.hasWarnings();
    }

    public ModuleAddress getModuleAddress() {
        return this.address;
    }

    public InternalKernelServices getKernelServices() {
        return this.services;
    }

    public void setLoadingCompleteness(int completeness) {
        this.stateManager.setLoadingCompleteness(completeness);
    }

    public int getLoadingCompleteness() {
        return this.stateManager.getLoadingCompleteness();
    }

    public void delete() {
        this.stateManager.delete();
    }

    public void setLoadingProgressState(LoadingState state) {
        this.stateManager.setLoadingProgressState(state);
    }

    public void setLoadingFailureState(LoadingState state, SourceFileExceptionList e) {
        this.stateManager.setLoadingFailureState(state, e);
    }

    public LoadingState getLoadingState() {
        return this.stateManager.getLoadingState();
    }

    public boolean isLoaded() {
        return this.stateManager.isLoaded();
    }

    public void setLoaded(QedeqVo qedeq, ModuleLabels labels, Element2Latex converter) {
        this.stateManager.setLoaded(qedeq, labels);
        this.converter = converter;
    }

    public Qedeq getQedeq() {
        return this.qedeq;
    }

    public Element2Latex getElement2Latex() {
        return this.converter;
    }

    public void setDependencyProgressState(DependencyState state) {
        this.stateManager.setDependencyProgressState(state);
    }

    public void setDependencyFailureState(DependencyState state, SourceFileExceptionList e) {
        this.stateManager.setDependencyFailureState(state, e);
    }

    public DependencyState getDependencyState() {
        return this.stateManager.getDependencyState();
    }

    public void setLoadedRequiredModules(KernelModuleReferenceList list) {
        this.stateManager.setLoadedRequiredModules(list);
    }

    public ModuleReferenceList getRequiredModules() {
        return this.getKernelRequiredModules();
    }

    public KernelModuleReferenceList getKernelRequiredModules() {
        return this.required;
    }

    public boolean hasLoadedRequiredModules() {
        return this.stateManager.hasLoadedRequiredModules();
    }

    public KernelModuleReferenceList getDependentModules() {
        return this.dependent;
    }

    public void setChecked(ModuleConstantsExistenceChecker checker) {
        this.stateManager.setChecked(checker);
    }

    public boolean isChecked() {
        return this.stateManager.isChecked();
    }

    public void setLogicalProgressState(LogicalState state) {
        this.stateManager.setLogicalProgressState(state);
    }

    public void setLogicalFailureState(LogicalState state, SourceFileExceptionList e) {
        this.stateManager.setLogicalFailureState(state, e);
    }

    public LogicalState getLogicalState() {
        return this.stateManager.getLogicalState();
    }

    public SourceFileExceptionList getErrors() {
        return this.stateManager.getErrors();
    }

    public SourceFileExceptionList getWarnings() {
        return this.stateManager.getWarnings();
    }

    public String getStateDescription() {
        return this.stateManager.getStateDescription();
    }

    public String getName() {
        if (this.address == null) {
            return "null";
        }
        return this.address.getName();
    }

    public String getRuleVersion() {
        if (this.address == null || this.qedeq == null || this.qedeq.getHeader() == null || this.qedeq.getHeader().getSpecification() == null || this.qedeq.getHeader().getSpecification().getRuleVersion() == null) {
            return "";
        }
        return this.qedeq.getHeader().getSpecification().getRuleVersion();
    }

    public String getUrl() {
        if (this.address == null) {
            return null;
        }
        return this.address.getUrl();
    }

    public void setLabels(ModuleLabels labels) {
        this.labels = labels;
    }

    public ModuleLabels getLabels() {
        return this.labels;
    }

    public SourceFileExceptionList createSourceFileExceptionList(Plugin plugin, ModuleDataException exception) {
        SourceArea referenceArea = null;
        if (exception.getReferenceContext() != null) {
            referenceArea = this.createSourceArea(this.qedeq, exception.getReferenceContext());
        }
        SourceFileException e = new SourceFileException(plugin, exception, this.createSourceArea(this.qedeq, exception.getContext()), referenceArea);
        DefaultSourceFileExceptionList list = new DefaultSourceFileExceptionList(e);
        return list;
    }

    public SourceFileExceptionList createSourceFileExceptionList(Plugin plugin, ModuleDataException exception, Qedeq qedeq) {
        SourceFileException e = new SourceFileException(plugin, exception, this.createSourceArea(qedeq, exception.getContext()), this.createSourceArea(qedeq, exception.getReferenceContext()));
        DefaultSourceFileExceptionList list = new DefaultSourceFileExceptionList(e);
        return list;
    }

    public SourceFileException createSourceFileException(Plugin plugin, ModuleDataException exception) {
        SourceArea area = this.createSourceArea(this.qedeq, exception.getContext());
        SourceArea referenceArea = null;
        if (exception.getReferenceContext() != null) {
            referenceArea = this.createSourceArea(this.qedeq, exception.getReferenceContext());
        }
        SourceFileException e = new SourceFileException(plugin, exception, area, referenceArea);
        return e;
    }

    public SourceArea createSourceArea(Qedeq qedeq, ModuleContext context) {
        String method = "createSourceArea(Qedeq, ModuleContext)";
        SourceArea area = null;
        try {
            area = this.loader.createSourceArea(qedeq, context);
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, "createSourceArea(Qedeq, ModuleContext)", "loader couldn't create context: " + context, e);
        }
        if (area == null) {
            Trace.fatal(CLASS, "createSourceArea", "loader coudn't create context: " + context, new NullPointerException());
            area = new SourceArea(this.getModuleAddress().getUrl(), SourcePosition.BEGIN, SourcePosition.BEGIN);
        }
        return area;
    }

    public void setQedeqVo(QedeqVo qedeq) {
        this.qedeq = qedeq;
    }

    protected StateManager getStateManager() {
        return this.stateManager;
    }

    public ModuleConstantsExistenceCheckerInterface getExistenceChecker() {
        return this.checker;
    }

    protected void setExistenceChecker(ModuleConstantsExistenceCheckerInterface checker) {
        this.checker = checker;
    }

    public int hashCode() {
        return this.getModuleAddress() == null ? 0 : this.getModuleAddress().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultKernelQedeqBo) {
            return EqualsUtility.equals(((DefaultKernelQedeqBo)obj).getModuleAddress(), this.getModuleAddress());
        }
        return false;
    }

    public String toString() {
        return this.address.getUrl();
    }

    public void addPluginErrorsAndWarnings(Plugin plugin, SourceFileExceptionList errors, SourceFileExceptionList warnings) {
        this.stateManager.addPluginResults(plugin, errors, warnings);
    }

    public void clearAllPluginErrorsAndWarnings() {
        this.stateManager.removeAllPluginResults();
    }
}

