/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.module;

import java.util.HashMap;
import java.util.Map;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.bo.logic.wf.ExistenceChecker;
import org.qedeq.kernel.bo.logic.wf.Function;
import org.qedeq.kernel.bo.logic.wf.Predicate;

public class DefaultExistenceChecker
implements ExistenceChecker {
    private static final Class CLASS = DefaultExistenceChecker.class;
    private final Map predicateDefinitions = new HashMap();
    private final Map functionDefinitions = new HashMap();
    private boolean setDefinitionByFormula;
    private String identityOperator;

    public DefaultExistenceChecker() {
        this.clear();
    }

    public void clear() {
        Trace.trace(CLASS, (Object)this, "setClassOperatorExists", "clear");
        this.predicateDefinitions.clear();
        this.functionDefinitions.clear();
        this.identityOperator = null;
        this.setDefinitionByFormula = false;
    }

    public boolean predicateExists(Predicate predicate) {
        PredicateDefinition definition = (PredicateDefinition)this.predicateDefinitions.get(predicate);
        return null != definition;
    }

    public boolean predicateExists(String name, int arguments) {
        Predicate predicate = new Predicate(name, "" + arguments);
        return this.predicateExists(predicate);
    }

    public void add(PredicateDefinition definition) {
        Predicate predicate = new Predicate(definition.getName(), definition.getArgumentNumber());
        if (this.predicateDefinitions.get(predicate) != null) {
            throw new IllegalArgumentException("predicate was already defined for this argument number: " + predicate);
        }
        this.predicateDefinitions.put(predicate, definition);
    }

    public PredicateDefinition get(Predicate predicate) {
        return (PredicateDefinition)this.predicateDefinitions.get(predicate);
    }

    public PredicateDefinition getPredicate(String name, int arguments) {
        Predicate predicate = new Predicate(name, "" + arguments);
        return this.get(predicate);
    }

    public boolean functionExists(Function function) {
        FunctionDefinition definition = (FunctionDefinition)this.functionDefinitions.get(function);
        return null != definition;
    }

    public boolean functionExists(String name, int arguments) {
        Function function = new Function(name, "" + arguments);
        return this.functionExists(function);
    }

    public void add(FunctionDefinition definition) {
        Function function = new Function(definition.getName(), definition.getArgumentNumber());
        if (this.functionDefinitions.get(function) != null) {
            throw new IllegalArgumentException("function was already defined for this argument number: " + function);
        }
        this.functionDefinitions.put(function, definition);
    }

    public FunctionDefinition get(Function function) {
        return (FunctionDefinition)this.functionDefinitions.get(function);
    }

    public FunctionDefinition getFunction(String name, int arguments) {
        Function function = new Function(name, "" + arguments);
        return this.get(function);
    }

    public boolean classOperatorExists() {
        return this.setDefinitionByFormula;
    }

    public boolean identityOperatorExists() {
        return this.identityOperator != null;
    }

    public String getIdentityOperator() {
        return this.identityOperator;
    }

    public void setIdentityOperatorDefined(String identityOperator) {
        Trace.param(CLASS, (Object)this, "setIdentityOperatorDefined", "identityOperator", identityOperator);
        this.identityOperator = identityOperator;
    }
}

