/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.module;

import org.qedeq.base.io.SourceArea;
import org.qedeq.base.io.SourcePosition;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.RuntimeVisitorException;
import org.qedeq.kernel.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.common.ModuleContext;
import org.qedeq.kernel.common.ModuleDataException;
import org.qedeq.kernel.common.Plugin;
import org.qedeq.kernel.common.SourceFileException;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.visitor.QedeqNotNullTraverser;
import org.qedeq.kernel.visitor.QedeqNumbers;

public abstract class ControlVisitor
extends AbstractModuleVisitor {
    private final Plugin plugin;
    private final KernelQedeqBo prop;
    private final QedeqNotNullTraverser traverser;
    private DefaultSourceFileExceptionList errorList;
    private DefaultSourceFileExceptionList warningList;

    protected ControlVisitor(KernelQedeqBo prop) {
        this.prop = prop;
        this.plugin = (Plugin)((Object)this);
        this.traverser = new QedeqNotNullTraverser(prop.getModuleAddress(), this);
    }

    protected ControlVisitor(Plugin plugin, KernelQedeqBo prop) {
        this.plugin = plugin;
        this.prop = prop;
        this.traverser = new QedeqNotNullTraverser(prop.getModuleAddress(), this);
    }

    public KernelQedeqBo getQedeqBo() {
        return this.prop;
    }

    public void traverse() throws SourceFileExceptionList {
        if (this.getQedeqBo().getQedeq() == null) {
            this.addWarning(new SourceFileException(this.getPlugin(), 90500, "QEDEQ module couldn't be loaded.", new IllegalArgumentException(), new SourceArea(this.getQedeqBo().getModuleAddress().getUrl(), SourcePosition.BEGIN, SourcePosition.BEGIN), null));
            return;
        }
        try {
            this.traverser.accept(this.getQedeqBo().getQedeq());
        }
        catch (ModuleDataException me) {
            this.addError(me);
        }
        catch (RuntimeException e) {
            this.addError(new RuntimeVisitorException(this.getCurrentContext(), e));
        }
        if (this.errorList != null) {
            throw this.errorList;
        }
    }

    public ModuleContext getCurrentContext() {
        return this.traverser.getCurrentContext();
    }

    protected void addError(ModuleDataException me) {
        this.addError(this.prop.createSourceFileException(this.getPlugin(), me));
    }

    protected void addError(SourceFileException sf) {
        if (this.errorList == null) {
            this.errorList = new DefaultSourceFileExceptionList(sf);
        } else {
            this.errorList.add(sf);
        }
    }

    public SourceFileExceptionList getErrorList() {
        return this.errorList;
    }

    protected void addWarning(ModuleDataException me) {
        this.addWarning(this.prop.createSourceFileException(this.getPlugin(), me));
    }

    protected void addWarning(SourceFileException sf) {
        if (this.warningList == null) {
            this.warningList = new DefaultSourceFileExceptionList(sf);
        } else {
            this.warningList.add(sf);
        }
    }

    public SourceFileExceptionList getWarningList() {
        return this.warningList;
    }

    protected void setBlocked(boolean blocked) {
        this.traverser.setBlocked(blocked);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getExecutionActionDescription() {
        return this.traverser.getVisitAction();
    }

    public double getExecutionPercentage() {
        return this.traverser.getVisitPercentage();
    }

    public QedeqNumbers getCurrentNumbers() {
        return this.traverser.getCurrentNumbers();
    }
}

