/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.model;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.kernel.bo.logic.model.Entity;
import org.qedeq.kernel.bo.logic.model.Model;
import org.qedeq.kernel.bo.logic.model.SubjectVariable;
import org.qedeq.kernel.bo.logic.model.SubjectVariableAllocation;

public final class SubjectVariableInterpreter {
    private List subjectVariableAllocations;
    private Model model;

    public SubjectVariableInterpreter(Model model) {
        this.model = model;
        this.subjectVariableAllocations = new ArrayList();
    }

    public synchronized boolean next() {
        boolean next = true;
        for (int i = this.subjectVariableAllocations.size() - 1; i >= -1; --i) {
            if (i < 0) {
                next = false;
                break;
            }
            SubjectVariableAllocation allocation = (SubjectVariableAllocation)this.subjectVariableAllocations.get(i);
            if (allocation.getValue() + 1 < this.model.getEntitiesSize()) {
                allocation.increaseNumber();
                break;
            }
            allocation.resetNumber();
        }
        return next;
    }

    public synchronized void addSubjectVariable(SubjectVariable var) {
        this.subjectVariableAllocations.add(new SubjectVariableAllocation(var));
    }

    public synchronized void forceAddSubjectVariable(SubjectVariable var, int value) {
        this.subjectVariableAllocations.add(new SubjectVariableAllocation(var, value));
    }

    public synchronized void forceRemoveSubjectVariable(SubjectVariable var) {
        int index = this.getIndex(var);
        if (index < 0) {
            throw new RuntimeException("variable does not exist: " + var);
        }
        SubjectVariableAllocation current = (SubjectVariableAllocation)this.subjectVariableAllocations.get(index);
        if (!current.isFixed()) {
            throw new RuntimeException("trying to remove not fixed allocation: " + current);
        }
        this.subjectVariableAllocations.remove(index);
    }

    public synchronized void removeSubjectVariable(SubjectVariable var) {
        int index = this.getIndex(var);
        if (index < 0) {
            throw new RuntimeException("variable does not exist: " + var);
        }
        SubjectVariableAllocation current = (SubjectVariableAllocation)this.subjectVariableAllocations.get(index);
        if (current.isFixed()) {
            throw new RuntimeException("trying to remove fixed allocation: " + current);
        }
        this.subjectVariableAllocations.remove(index);
    }

    private synchronized int getSubjectVariableSelection(SubjectVariable var) {
        int selection = 0;
        int index = this.getIndex(var);
        if (index >= 0) {
            selection = ((SubjectVariableAllocation)this.subjectVariableAllocations.get(index)).getValue();
        } else {
            this.addSubjectVariable(var);
        }
        return selection;
    }

    public synchronized Entity getEntity(SubjectVariable var) {
        return this.model.getEntity(this.getSubjectVariableSelection(var));
    }

    private int getIndex(SubjectVariable var) {
        SubjectVariableAllocation current;
        int index = -1;
        for (index = this.subjectVariableAllocations.size() - 1; index >= 0 && !var.equals((current = (SubjectVariableAllocation)this.subjectVariableAllocations.get(index)).getVariable()); --index) {
        }
        return index;
    }

    public synchronized void increaseSubjectVariableSelection(SubjectVariable var) {
        ((SubjectVariableAllocation)this.subjectVariableAllocations.get(this.getIndex(var))).increaseNumber();
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("subject variables {");
        for (int i = 0; i < this.subjectVariableAllocations.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            SubjectVariableAllocation var = (SubjectVariableAllocation)this.subjectVariableAllocations.get(i);
            buffer.append(var.getVariable());
            buffer.append("=");
            buffer.append(this.model.getEntity(var.getValue()));
        }
        buffer.append("}");
        return buffer.toString();
    }

    public synchronized void clear() {
        this.subjectVariableAllocations.clear();
    }
}

