/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.model;

import org.qedeq.kernel.bo.logic.model.DynamicModel;
import org.qedeq.kernel.bo.logic.model.Entity;
import org.qedeq.kernel.bo.logic.model.Function;
import org.qedeq.kernel.bo.logic.model.Predicate;
import org.qedeq.kernel.bo.logic.model.PredicateConstant;

public final class SixDynamicModel
extends DynamicModel {
    private static final Class CLASS = SixDynamicModel.class;
    public static final Entity EMPTY = new Entity(0, "{}", "{} or empty set");
    public static final Entity ZERO_ONE = new Entity(1, "1", "1");
    public static final Entity ZERO_TWO = new Entity(2, "2", "2");
    public static final Entity ONE_ONE = new Entity(3, "{1}", "{1}");
    public static final Entity ONE_TWO = new Entity(4, "{2}", "{2}");
    public static final Entity TWO_ONE_TWO = new Entity(5, "{1, 2}", "{1, 2}");
    public static final Function FUNCTION_EMPTY = Function.createConstant(EMPTY);
    public static final Function FUNCTION_ZERO_ONE = Function.createConstant(ZERO_ONE);
    public static final Function FUNCTION_ZERO_TWO = Function.createConstant(ZERO_TWO);
    public static final Function FUNCTION_ONE_ONE = Function.createConstant(ONE_ONE);
    public static final Function FUNCTION_ONE_TWO = Function.createConstant(ONE_TWO);
    public static final Function FUNCTION_TWO_ONE_TWO = Function.createConstant(TWO_ONE_TWO);
    public static final Predicate IS_EMPTY = Predicate.isEntity(EMPTY);
    public static final Predicate IS_ZERO_ONE = Predicate.isEntity(ZERO_ONE);
    public static final Predicate IS_ZERO_TWO = Predicate.isEntity(ZERO_TWO);
    public static final Predicate IS_ONE_ONE = Predicate.isEntity(ONE_ONE);
    public static final Predicate IS_ONE_TWO = Predicate.isEntity(ONE_TWO);
    public static final Predicate IS_TWO_ONE_TWO = Predicate.isEntity(TWO_ONE_TWO);
    public static final Predicate NOT_IS_ONE_TWO = Predicate.not(IS_ONE_TWO);
    private final Function functionModulo3 = new Function(0, 99, "% 3", "modulo 3"){

        public Entity map(Entity[] entities) {
            int result = 0;
            for (int i = 0; i < entities.length; ++i) {
                result += entities[i].getValue() % 3;
            }
            return SixDynamicModel.this.getEntity(result %= 3);
        }
    };
    private final Function functionPlus1Modulo3 = new Function(0, 99, "+1 % 3", "plus 1 modulo 3"){

        public Entity map(Entity[] entities) {
            int result = 1;
            for (int i = 0; i < entities.length; ++i) {
                result += entities[i].getValue() % 3;
            }
            return SixDynamicModel.this.getEntity(result %= 3);
        }
    };

    public SixDynamicModel() {
        super("six elements");
        this.addEntity(EMPTY);
        this.addEntity(ZERO_ONE);
        this.addEntity(ZERO_TWO);
        this.addEntity(ONE_ONE);
        this.addEntity(ONE_TWO);
        this.addEntity(TWO_ONE_TWO);
        this.addFunction(0, FUNCTION_EMPTY);
        this.addFunction(0, FUNCTION_ZERO_ONE);
        this.addFunction(0, FUNCTION_ZERO_TWO);
        this.addFunction(0, FUNCTION_ONE_ONE);
        this.addFunction(0, FUNCTION_ONE_TWO);
        this.addFunction(0, FUNCTION_TWO_ONE_TWO);
        this.addFunction(1, FUNCTION_EMPTY);
        this.addFunction(1, FUNCTION_ZERO_ONE);
        this.addFunction(1, this.functionModulo3);
        this.addFunction(1, this.functionPlus1Modulo3);
        this.addFunction(2, FUNCTION_EMPTY);
        this.addFunction(2, FUNCTION_ZERO_ONE);
        this.addFunction(2, this.functionModulo3);
        this.addFunction(2, this.functionPlus1Modulo3);
        this.addPredicate(0, FALSE);
        this.addPredicate(0, TRUE);
        this.addPredicate(1, FALSE);
        this.addPredicate(1, TRUE);
        this.addPredicate(1, EVEN);
        this.addPredicate(1, IS_EMPTY);
        this.addPredicate(1, IS_ZERO_ONE);
        this.addPredicate(1, IS_ZERO_TWO);
        this.addPredicate(1, IS_ONE_ONE);
        this.addPredicate(1, IS_TWO_ONE_TWO);
        this.addPredicate(2, FALSE);
        this.addPredicate(2, TRUE);
        this.addPredicate(2, EVEN);
        this.addPredicate(2, LESS);
        this.addPredicate(2, EQUAL);
        this.addPredicate(2, IS_EMPTY);
        this.addPredicate(2, IS_ZERO_ONE);
        this.addPredicate(2, IS_ZERO_TWO);
        this.addPredicate(2, IS_ONE_ONE);
        this.addPredicate(2, IS_ONE_TWO);
        this.addPredicateConstant(new PredicateConstant("in", 2), new Predicate(2, 2, "in", "isSet"){

            public boolean calculate(Entity[] entities) {
                boolean result = false;
                int a = entities[0].getValue();
                int b = entities[1].getValue();
                if (a == 1 && (b == 3 || b == 5)) {
                    result = true;
                }
                if (a == 2 && (b == 4 || b == 5)) {
                    result = true;
                }
                return result;
            }
        });
    }

    public String getDescription() {
        return "This model has six entities: {}, {1}, {2}, {{1}}, {{2}} and {1, 2}.";
    }

    public Entity comprehension(Entity[] array) {
        Entity result = EMPTY;
        block5: for (int i = 0; i < array.length; ++i) {
            switch (array[i].getValue()) {
                case 0: 
                case 3: 
                case 4: 
                case 5: {
                    continue block5;
                }
                case 1: {
                    if (result.getValue() == 5) continue block5;
                    if (result.getValue() == 0) {
                        result = ONE_ONE;
                        continue block5;
                    }
                    if (result.getValue() != 4) continue block5;
                    result = TWO_ONE_TWO;
                    continue block5;
                }
                case 2: {
                    if (result.getValue() == 5) continue block5;
                    if (result.getValue() == 0) {
                        result = ONE_TWO;
                        continue block5;
                    }
                    if (result.getValue() != 4) continue block5;
                    result = TWO_ONE_TWO;
                    continue block5;
                }
                default: {
                    throw new RuntimeException("unknown value for entity " + array[i]);
                }
            }
        }
        return result;
    }
}

