/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic;

import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.base.list.Atom;
import org.qedeq.kernel.base.list.Element;
import org.qedeq.kernel.base.list.ElementList;
import org.qedeq.kernel.bo.logic.wf.ElementCheckException;
import org.qedeq.kernel.bo.logic.wf.EverythingExists;
import org.qedeq.kernel.bo.logic.wf.ExistenceChecker;
import org.qedeq.kernel.bo.logic.wf.FormulaBasicErrors;
import org.qedeq.kernel.bo.logic.wf.FormulaCheckException;
import org.qedeq.kernel.bo.logic.wf.LogicalCheckExceptionList;
import org.qedeq.kernel.bo.logic.wf.Operators;
import org.qedeq.kernel.bo.logic.wf.TermCheckException;
import org.qedeq.kernel.common.ModuleContext;
import org.qedeq.kernel.dto.list.ElementSet;

public final class FormulaChecker
implements Operators,
FormulaBasicErrors {
    private static final Class CLASS = FormulaChecker.class;
    private final ModuleContext currentContext;
    private final ExistenceChecker existenceChecker;
    private final LogicalCheckExceptionList exceptions;

    private FormulaChecker(ModuleContext context, ExistenceChecker existenceChecker) {
        this.existenceChecker = existenceChecker;
        if (existenceChecker.identityOperatorExists() && !existenceChecker.predicateExists(existenceChecker.getIdentityOperator(), 2)) {
            throw new IllegalArgumentException("identy predicate should exist, but it doesn't");
        }
        this.currentContext = new ModuleContext(context);
        this.exceptions = new LogicalCheckExceptionList();
    }

    public static final LogicalCheckExceptionList checkFormula(Element element, ModuleContext context, ExistenceChecker existenceChecker) {
        FormulaChecker checker = new FormulaChecker(context, existenceChecker);
        checker.checkFormula(element);
        return checker.exceptions;
    }

    public static final LogicalCheckExceptionList checkFormula(Element element, ModuleContext context) {
        return FormulaChecker.checkFormula(element, context, EverythingExists.getInstance());
    }

    public static final LogicalCheckExceptionList checkTerm(Element element, ModuleContext context, ExistenceChecker existenceChecker) {
        FormulaChecker checker = new FormulaChecker(context, existenceChecker);
        checker.checkTerm(element);
        return checker.exceptions;
    }

    public static final LogicalCheckExceptionList checkTerm(Element element, ModuleContext context) {
        return FormulaChecker.checkTerm(element, context, EverythingExists.getInstance());
    }

    private final void checkFormula(Element element) {
        String method = "checkFormula";
        Trace.begin(CLASS, this, "checkFormula");
        Trace.param(CLASS, (Object)this, "checkFormula", "element", element);
        String context = this.getCurrentContext().getLocationWithinModule();
        Trace.param(CLASS, (Object)this, "checkFormula", "context", context);
        if (!this.checkList(element)) {
            return;
        }
        ElementList list = element.getList();
        String listContext = context + ".getList()";
        this.setLocationWithinModule(listContext);
        String operator = list.getOperator();
        if (operator.equals("AND") || operator.equals("OR") || operator.equals("IMPL") || operator.equals("EQUI")) {
            Trace.trace(CLASS, (Object)this, "checkFormula", "one of (and, or, implication, equivalence) operator found");
            if (list.size() <= 1) {
                this.handleFormulaCheckException(30740, "more than one argument expected for the operator \"" + operator + "\"", element, this.getCurrentContext());
                return;
            }
            if (operator.equals("IMPL") && list.size() != 2) {
                this.handleFormulaCheckException(30760, "exactly two or three arguments expected\"" + operator + "\"", element, this.getCurrentContext());
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                this.setLocationWithinModule(listContext + ".getElement(" + i + ")");
                this.checkFormula(list.getElement(i));
            }
            this.setLocationWithinModule(listContext);
            this.checkFreeAndBoundDisjunct(0, list);
        } else if (operator.equals("NOT")) {
            Trace.trace(CLASS, (Object)this, "checkFormula", "negation operator found");
            this.setLocationWithinModule(listContext);
            if (list.size() != 1) {
                this.handleFormulaCheckException(30710, "exactly one argument expected for the operator \"" + operator + "\"", element, this.getCurrentContext());
                return;
            }
            this.setLocationWithinModule(listContext + ".getElement(0)");
            this.checkFormula(list.getElement(0));
        } else if (operator.equals("PREDVAR") || operator.equals("PREDCON")) {
            Trace.trace(CLASS, (Object)this, "checkFormula", "predicate operator found");
            this.setLocationWithinModule(listContext);
            if (list.size() < 1) {
                this.handleFormulaCheckException(30720, "at least one argument expected for \"" + operator + "\"", element, this.getCurrentContext());
                return;
            }
            this.setLocationWithinModule(listContext + ".getElement(0)");
            if (!this.checkAtomFirst(list.getElement(0))) {
                return;
            }
            for (int i = 1; i < list.size(); ++i) {
                this.setLocationWithinModule(listContext + ".getElement(" + i + ")");
                this.checkTerm(list.getElement(i));
            }
            this.setLocationWithinModule(listContext);
            this.checkFreeAndBoundDisjunct(1, list);
            if ("PREDCON".equals(operator) && !this.existenceChecker.predicateExists(list.getElement(0).getAtom().getString(), list.size() - 1)) {
                this.handleFormulaCheckException(30590, "this predicate constant is unknown (at least for this argument number): \"" + list.getElement(0).getAtom().getString() + "\" [" + (list.size() - 1) + "]", element, this.getCurrentContext());
            }
        } else if (operator.equals("EXISTS") || operator.equals("EXISTSU") || operator.equals("FORALL")) {
            Trace.trace(CLASS, (Object)this, "checkFormula", "quantifier found");
            this.setLocationWithinModule(context);
            this.checkQuantifier(element);
        } else {
            this.setLocationWithinModule(listContext + ".getOperator()");
            this.handleFormulaCheckException(30530, "this logical operator is unknown: \"" + operator + "\"", element, this.getCurrentContext());
        }
        this.setLocationWithinModule(context);
        Trace.end(CLASS, this, "checkFormula");
    }

    private void checkQuantifier(Element element) {
        String method = "checkQuantifier";
        Trace.begin(CLASS, this, "checkQuantifier");
        Trace.param(CLASS, (Object)this, "checkQuantifier", "element", element);
        String context = this.getCurrentContext().getLocationWithinModule();
        Trace.param(CLASS, (Object)this, "checkQuantifier", "context", context);
        this.checkList(element);
        ElementList list = element.getList();
        String listContext = context + ".getList()";
        this.setLocationWithinModule(listContext);
        String operator = list.getOperator();
        if (!operator.equals("EXISTS") && operator.equals("EXISTSU") && operator.equals("FORALL")) {
            throw new IllegalArgumentException("quantifier element expected but found: " + ((Object)element).toString());
        }
        if (list.size() < 2 || list.size() > 3) {
            this.handleFormulaCheckException(30750, "exactly two or three arguments expected", element, this.getCurrentContext());
            return;
        }
        if (operator.equals("EXISTSU") && !this.existenceChecker.identityOperatorExists()) {
            this.setLocationWithinModule(listContext + ".getOperator()");
            this.handleFormulaCheckException(30570, "the equality predicate was not yet defined", element, this.getCurrentContext());
        }
        this.setLocationWithinModule(listContext + ".getElement(" + 0 + ")");
        this.checkSubjectVariable(list.getElement(0));
        this.setLocationWithinModule(listContext + ".getElement(" + 1 + ")");
        this.checkFormula(list.getElement(1));
        this.setLocationWithinModule(listContext);
        if (FormulaChecker.getBoundSubjectVariables(list.getElement(1)).contains(list.getElement(0))) {
            this.handleFormulaCheckException(30550, "subject variable is already bound in sub formula", list.getElement(1), this.getCurrentContext());
        }
        if (list.size() > 3) {
            this.handleFormulaCheckException(30750, "exactly two or three arguments expected", list, this.getCurrentContext());
            return;
        }
        if (list.size() > 2) {
            this.setLocationWithinModule(listContext + ".getElement(" + 2 + ")");
            this.checkFormula(list.getElement(2));
            this.setLocationWithinModule(listContext);
            if (FormulaChecker.getBoundSubjectVariables(list.getElement(2)).contains(list.getElement(0))) {
                this.handleFormulaCheckException(30550, "subject variable is already bound in sub formula", list.getElement(2), this.getCurrentContext());
                return;
            }
            this.setLocationWithinModule(listContext);
            this.checkFreeAndBoundDisjunct(1, list);
        }
        this.setLocationWithinModule(context);
        Trace.end(CLASS, this, "checkQuantifier");
    }

    private void checkTerm(Element element) {
        String method = "checkTerm";
        Trace.begin(CLASS, this, "checkTerm");
        Trace.param(CLASS, (Object)this, "checkTerm", "element", element);
        String context = this.getCurrentContext().getLocationWithinModule();
        Trace.param(CLASS, (Object)this, "checkTerm", "context", context);
        if (!this.checkList(element)) {
            return;
        }
        ElementList list = element.getList();
        String listContext = context + ".getList()";
        this.setLocationWithinModule(listContext);
        String operator = list.getOperator();
        if (operator.equals("VAR")) {
            this.checkSubjectVariable(element);
        } else if (operator.equals("FUNCON") || operator.equals("FUNVAR")) {
            if (operator.equals("FUNCON") && list.size() < 1) {
                this.handleTermCheckException(30720, "at least one argument expected for ", element, this.getCurrentContext());
                return;
            }
            if (operator.equals("FUNVAR") && list.size() < 2) {
                this.handleTermCheckException(30740, "more than one argument expected for the operator ", element, this.getCurrentContext());
                return;
            }
            this.setLocationWithinModule(listContext + ".getElement(0)");
            if (!this.checkAtomFirst(list.getElement(0))) {
                return;
            }
            this.setLocationWithinModule(listContext);
            for (int i = 1; i < list.size(); ++i) {
                this.setLocationWithinModule(listContext + ".getElement(" + i + ")");
                this.checkTerm(list.getElement(i));
            }
            this.setLocationWithinModule(listContext);
            this.checkFreeAndBoundDisjunct(1, list);
            this.setLocationWithinModule(listContext);
            if ("FUNCON".equals(operator) && !this.existenceChecker.functionExists(list.getElement(0).getAtom().getString(), list.size() - 1)) {
                this.handleFormulaCheckException(30690, "this function constant is unknown (at least for this argument number): \"" + list.getElement(0).getAtom().getString() + "\"", element, this.getCurrentContext());
            }
        } else if (operator.equals("CLASS")) {
            if (list.size() != 2) {
                this.handleTermCheckException(30760, "exactly two or three arguments expected", element, this.getCurrentContext());
                return;
            }
            this.setLocationWithinModule(listContext + ".getElement(" + 0 + ")");
            if (!FormulaChecker.isSubjectVariable(list.getElement(0))) {
                this.handleTermCheckException(30540, "subject variable expected", element, this.getCurrentContext());
            }
            this.setLocationWithinModule(listContext + ".getElement(" + 1 + ")");
            this.checkFormula(list.getElement(1));
            this.setLocationWithinModule(listContext);
            if (!this.existenceChecker.classOperatorExists()) {
                this.handleFormulaCheckException(30680, "the class operator is still undefined", element, this.getCurrentContext());
            }
            this.setLocationWithinModule(listContext + ".getElement(" + 0 + ")");
            if (FormulaChecker.getBoundSubjectVariables(list.getElement(1)).contains(list.getElement(0))) {
                this.handleTermCheckException(30550, "subject variable is already bound in sub formula", list.getElement(0), this.getCurrentContext());
            }
        } else {
            this.setLocationWithinModule(listContext + ".getOperator()");
            this.handleTermCheckException(30620, "unknown term operator: \"" + operator + "\"", element, this.getCurrentContext());
        }
        this.setLocationWithinModule(context);
        Trace.end(CLASS, this, "checkTerm");
    }

    private void checkFreeAndBoundDisjunct(int start, ElementList list) {
        String context = this.getCurrentContext().getLocationWithinModule();
        ElementSet free = new ElementSet();
        ElementSet bound = new ElementSet();
        for (int i = start; i < list.size(); ++i) {
            ElementSet interFree;
            this.setLocationWithinModule(context + ".getElement(" + i + ")");
            ElementSet newFree = FormulaChecker.getFreeSubjectVariables(list.getElement(i));
            ElementSet newBound = FormulaChecker.getBoundSubjectVariables(list.getElement(i));
            ElementSet interBound = newFree.newIntersection(bound);
            if (!interBound.isEmpty()) {
                this.handleFormulaCheckException(30780, "these free variables were already bound in previous formulas: " + interBound, list.getElement(i), this.getCurrentContext());
            }
            if (!(interFree = newBound.newIntersection(free)).isEmpty()) {
                this.handleFormulaCheckException(30770, "these bound variables are already free in previous formulas: " + interFree, list.getElement(i), this.getCurrentContext());
            }
            bound.union(newBound);
            free.union(newFree);
        }
        this.setLocationWithinModule(context);
    }

    public static final boolean isSubjectVariable(Element element) {
        if (element == null || !element.isList() || element.getList() == null) {
            return false;
        }
        ElementList list = element.getList();
        if (list.getOperator().equals("VAR")) {
            if (list.size() != 1) {
                return false;
            }
            Element first = element.getList().getElement(0);
            if (first == null || !first.isAtom() || first.getAtom() == null) {
                return false;
            }
            Atom atom = first.getAtom();
            return atom.getString() != null && atom.getAtom().getString() != null && atom.getString().length() != 0;
        }
        return false;
    }

    private boolean checkSubjectVariable(Element element) {
        String context = this.getCurrentContext().getLocationWithinModule();
        if (!this.checkList(element)) {
            return false;
        }
        this.setLocationWithinModule(context + ".getList()");
        if (element.getList().getOperator().equals("VAR")) {
            if (element.getList().size() != 1) {
                this.handleFormulaCheckException(30710, "exactly one argument expected for the operator ", element.getList(), this.getCurrentContext());
                return false;
            }
            this.setLocationWithinModule(context + ".getList().getElement(0)");
            if (this.checkAtomFirst(element.getList().getElement(0))) {
                return false;
            }
        } else {
            this.setLocationWithinModule(context + ".getList().getOperator()");
            this.handleFormulaCheckException(30540, "subject variable expected", element, this.getCurrentContext());
            return false;
        }
        this.setLocationWithinModule(context);
        return true;
    }

    public static final ElementSet getFreeSubjectVariables(Element element) {
        ElementSet free = new ElementSet();
        if (FormulaChecker.isSubjectVariable(element)) {
            free.add(element);
        } else if (element.isList()) {
            ElementList list = element.getList();
            String operator = list.getOperator();
            if (operator.equals("EXISTS") || operator.equals("EXISTSU") || operator.equals("FORALL") || operator.equals("CLASS")) {
                for (int i = 1; i < list.size(); ++i) {
                    free.union(FormulaChecker.getFreeSubjectVariables(list.getElement(i)));
                }
                free.remove(list.getElement(0));
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    free.union(FormulaChecker.getFreeSubjectVariables(list.getElement(i)));
                }
            }
        }
        return free;
    }

    public static final ElementSet getBoundSubjectVariables(Element element) {
        ElementSet bound;
        block4: {
            bound = new ElementSet();
            if (!element.isList()) break block4;
            ElementList list = element.getList();
            String operator = list.getOperator();
            if (operator.equals("EXISTS") || operator.equals("EXISTSU") || operator.equals("FORALL") || operator.equals("CLASS")) {
                bound.add(list.getElement(0));
                for (int i = 1; i < list.size(); ++i) {
                    bound.union(FormulaChecker.getBoundSubjectVariables(list.getElement(i)));
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    bound.union(FormulaChecker.getBoundSubjectVariables(list.getElement(i)));
                }
            }
        }
        return bound;
    }

    private boolean checkList(Element element) {
        String context = this.getCurrentContext().getLocationWithinModule();
        if (element == null) {
            this.handleElementCheckException(30400, "element must not be null", null, this.getCurrentContext());
            return false;
        }
        if (!element.isList()) {
            this.handleElementCheckException(30470, "an atom is no formula", element, this.getCurrentContext());
            return false;
        }
        ElementList list = element.getList();
        this.setLocationWithinModule(context + ".getList()");
        if (list == null) {
            this.handleElementCheckException(30420, "list must not be null", element, this.getCurrentContext());
            return false;
        }
        String operator = list.getOperator();
        this.setLocationWithinModule(context + ".getList().getOperator()");
        if (operator == null) {
            this.handleElementCheckException(30450, "operator content must not be null", element, this.getCurrentContext());
            return false;
        }
        if (operator.length() == 0) {
            this.handleElementCheckException(30460, "operator content must not be empty\"" + operator + "\"", element, this.getCurrentContext());
            return false;
        }
        this.setLocationWithinModule(context);
        return true;
    }

    private boolean checkAtomFirst(Element element) {
        String context = this.getCurrentContext().getLocationWithinModule();
        if (element == null) {
            this.handleElementCheckException(30400, "element must not be null", null, this.getCurrentContext());
            return false;
        }
        if (!element.isAtom()) {
            this.handleElementCheckException(30730, "first argument must be an atom", element, this.getCurrentContext());
            return false;
        }
        Atom atom = element.getAtom();
        this.setLocationWithinModule(context + ".getAtom()");
        if (atom == null) {
            this.handleElementCheckException(30410, "atom must not be null", element, this.getCurrentContext());
            return false;
        }
        if (atom.getString() == null) {
            this.handleElementCheckException(30430, "atom content must not be null", element, this.getCurrentContext());
            return false;
        }
        if (atom.getString().length() == 0) {
            this.handleElementCheckException(30440, "atom content must not be empty", element, this.getCurrentContext());
            return false;
        }
        this.setLocationWithinModule(context);
        return true;
    }

    private void handleFormulaCheckException(int code, String msg, Element element, ModuleContext context) {
        FormulaCheckException ex = new FormulaCheckException(code, msg, element, context);
        this.exceptions.add(ex);
    }

    private void handleTermCheckException(int code, String msg, Element element, ModuleContext context) {
        TermCheckException ex = new TermCheckException(code, msg, element, context);
        this.exceptions.add(ex);
    }

    private void handleElementCheckException(int code, String msg, Element element, ModuleContext context) {
        ElementCheckException ex = new ElementCheckException(code, msg, element, context);
        this.exceptions.add(ex);
    }

    protected void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    protected final ModuleContext getCurrentContext() {
        return this.currentContext;
    }
}

