/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;

public final class ResourceLoaderUtility {
    private static final Class CLASS = ResourceLoaderUtility.class;

    private ResourceLoaderUtility() {
    }

    public static Class loadClass(String name) throws ClassNotFoundException {
        return ResourceLoaderUtility.loadClass(name, null);
    }

    public static URL getResourceUrl(String name) {
        return ResourceLoaderUtility.getResourceUrl(name, ResourceLoaderUtility.class.getClassLoader());
    }

    public static InputStream getResourceAsStream(String name) {
        return ResourceLoaderUtility.getResourceAsStream(name, null);
    }

    public static Class loadClass(String name, ClassLoader callerClassLoader) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader loader = ResourceLoaderUtility.getContextClassLoader();
            if (loader != null) {
                clazz = loader.loadClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = callerClassLoader != null ? callerClassLoader.loadClass(name) : Class.forName(name);
        }
        return clazz;
    }

    public static URL getResourceUrl(String name, ClassLoader callerClassLoader) {
        ResourceLoaderUtility.checkResourceName(name);
        URL url = null;
        ClassLoader loader = ResourceLoaderUtility.getContextClassLoader();
        if (loader != null) {
            url = loader.getResource(name);
        }
        if (url == null) {
            url = callerClassLoader != null ? callerClassLoader.getResource(name) : ClassLoader.getSystemResource(name);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String name, ClassLoader callerClassLoader) {
        ResourceLoaderUtility.checkResourceName(name);
        InputStream stream = null;
        ClassLoader loader = ResourceLoaderUtility.getContextClassLoader();
        if (loader != null) {
            stream = loader.getResourceAsStream(name);
        }
        if (stream == null) {
            stream = callerClassLoader != null ? callerClassLoader.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name);
        }
        return stream;
    }

    public static ClassLoader getContextClassLoader() {
        try {
            Method method = Thread.class.getMethod("getContextClassLoader", null);
            return (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
        }
        catch (RuntimeException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static void checkResourceName(String name) {
        if (name != null && name.startsWith("/")) {
            Trace.info(CLASS, "ClassLoaderUtility", "checkResourceName", "resource name not portable: " + name);
        }
    }

    public static File getResourceFile(File startDirectory, String resourceDirectoryName, String resourceName) {
        File resourceDir = new File(startDirectory, resourceDirectoryName);
        File resource = new File(resourceDir, resourceName);
        if (!resource.exists()) {
            URL url = ResourceLoaderUtility.getResourceUrl(resourceDirectoryName + "/" + resourceName);
            if (url == null) {
                Trace.info(ResourceLoaderUtility.class, "getResourceUrlAndMakeLocalCopy", "URL not found for: " + resourceDirectoryName + "/" + resourceName);
                return null;
            }
            try {
                if (!resourceDir.exists() && !resourceDir.mkdirs()) {
                    Trace.info(ResourceLoaderUtility.class, "getResourceUrlAndMakeLocalCopy", "creation failed: " + resourceDir);
                }
                IoUtility.saveFile(url, resource);
            }
            catch (IOException e) {
                Trace.fatal(ResourceLoaderUtility.class, "getResourceUrlAndMakeLocalCopy", "resource can not be saved", e);
            }
        }
        return resource;
    }
}

