/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.lang.SystemUtils;

public final class IoUtility {
    static /* synthetic */ Class class$java$lang$Object;

    private IoUtility() {
    }

    public static String getDefaultEncoding() {
        return SystemUtils.FILE_ENCODING;
    }

    public static String getWorkingEncoding(String encoding) {
        if (encoding != null) {
            try {
                if (Charset.isSupported(encoding) && Charset.forName(encoding).canEncode()) {
                    return encoding;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        System.err.println("not supported encoding: " + encoding);
        return "ISO-8859-1";
    }

    public static String loadFile(String filename, String encoding) throws IOException {
        StringBuffer buffer = new StringBuffer();
        IoUtility.loadFile(filename, buffer, encoding);
        return buffer.toString();
    }

    public static void loadFile(String filename, StringBuffer buffer, String encoding) throws IOException {
        IoUtility.loadFile(new File(filename), buffer, encoding);
    }

    public static void loadStream(InputStream in, StringBuffer buffer) throws IOException {
        int c;
        buffer.setLength(0);
        while ((c = in.read()) >= 0) {
            buffer.append((char)c);
        }
    }

    public static String loadStreamWithoutException(InputStream in, int maxLength) {
        if (in == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.setLength(0);
        try {
            int c;
            int counter = 0;
            while (counter++ < maxLength && (c = in.read()) >= 0) {
                buffer.append((char)c);
            }
        }
        catch (IOException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return buffer.toString();
    }

    public static void loadReader(Reader in, StringBuffer buffer) throws IOException {
        int c;
        buffer.setLength(0);
        while ((c = in.read()) >= 0) {
            buffer.append((char)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFile(File file, StringBuffer buffer) throws IOException {
        int size = (int)file.length();
        char[] data = new char[size];
        buffer.setLength(0);
        FileReader in = null;
        try {
            in = new FileReader(file);
            for (int charsread = 0; charsread < size; charsread += in.read(data, charsread, size - charsread)) {
            }
        }
        catch (Throwable throwable) {
            IoUtility.close(in);
            throw throwable;
        }
        IoUtility.close(in);
        buffer.insert(0, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFile(File file, StringBuffer buffer, String encoding) throws IOException {
        buffer.setLength((int)file.length());
        buffer.setLength(0);
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        char[] data = new char[10240];
        try {
            int charsread = 0;
            while (0 < (charsread = in.read(data, 0, data.length))) {
                buffer.append(data, 0, charsread);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] loadFileBinary(File file) throws IOException {
        int size = (int)file.length();
        FileInputStream in = new FileInputStream(file);
        try {
            int read;
            byte[] data = new byte[size];
            for (int charsread = 0; charsread < size; charsread += read) {
                read = in.read(data, charsread, size - charsread);
                if (read != -1) continue;
                byte[] result = new byte[charsread];
                System.arraycopy(data, 0, result, 0, charsread);
                byte[] byArray = result;
                return byArray;
            }
            in.close();
            byte[] byArray = data;
            return byArray;
        }
        finally {
            IoUtility.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFile(URL url, StringBuffer buffer) throws IOException {
        InputStream in = null;
        BufferedReader dis = null;
        try {
            int i;
            in = url.openStream();
            dis = new BufferedReader(new InputStreamReader(in));
            while ((i = dis.read()) != -1) {
                buffer.append((char)i);
            }
        }
        catch (Throwable throwable) {
            IoUtility.close(in);
            IoUtility.close(dis);
            throw throwable;
        }
        IoUtility.close(in);
        IoUtility.close(dis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFile(URL url, StringBuffer buffer, String encoding) throws IOException {
        InputStream in = null;
        BufferedReader dis = null;
        try {
            int i;
            in = url.openStream();
            dis = new BufferedReader(new InputStreamReader(in, encoding));
            while ((i = dis.read()) != -1) {
                buffer.append((char)i);
            }
        }
        catch (Throwable throwable) {
            IoUtility.close(in);
            IoUtility.close(dis);
            throw throwable;
        }
        IoUtility.close(in);
        IoUtility.close(dis);
    }

    public static void saveFile(URL url, File file) throws IOException {
        IoUtility.saveFile(url.openStream(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(InputStream in, File file) throws IOException {
        FileOutputStream out = null;
        try {
            int length;
            out = new FileOutputStream(file);
            byte[] data = new byte[8192];
            while ((length = in.read(data)) != -1) {
                out.write(data, 0, length);
            }
        }
        finally {
            IoUtility.close(in);
            IoUtility.close(out);
        }
    }

    public static final Reader stringToReader(String data) {
        try {
            return new InputStreamReader(new ByteArrayInputStream(data.getBytes("ISO-8859-1")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveFile(String filename, String text) throws IOException {
        IoUtility.saveFile(new File(filename), text);
    }

    public static void saveFile(String filename, StringBuffer text) throws IOException {
        IoUtility.saveFile(new File(filename), text.toString());
    }

    public static void saveFile(File file, StringBuffer text) throws IOException {
        IoUtility.saveFile(file, text.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(File file, String text) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(file));
            out.write(text);
        }
        catch (Throwable throwable) {
            IoUtility.close(out);
            throw throwable;
        }
        IoUtility.close(out);
    }

    public static void saveFile(File file, StringBuffer text, String encoding) throws IOException {
        IoUtility.saveFile(file, text.toString(), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(File file, String text, String encoding) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
        try {
            out.write(text);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFileBinary(File file, byte[] data) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            out.write(data);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        if (from.getCanonicalFile().equals(to.getCanonicalFile())) {
            return;
        }
        IoUtility.createNecessaryDirectories(to);
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int length;
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            byte[] data = new byte[8192];
            while ((length = in.read(data)) != -1) {
                out.write(data, 0, length);
            }
        }
        catch (Throwable throwable) {
            IoUtility.close(in);
            IoUtility.close(out);
            throw throwable;
        }
        IoUtility.close(in);
        IoUtility.close(out);
    }

    public static void copy(String sourceLocation, String targetLocation) throws IOException {
        IoUtility.copyDirectory(new File(sourceLocation), new File(targetLocation));
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                IoUtility.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            IoUtility.copyFile(sourceLocation, targetLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareFilesBinary(File from, File with) throws IOException {
        boolean bl;
        if (from == null && with == null) {
            return true;
        }
        if (from == null || with == null) {
            return false;
        }
        if (from.getAbsoluteFile().equals(with.getAbsoluteFile())) {
            return true;
        }
        if (from.length() != with.length()) {
            return false;
        }
        byte[] dataOne = new byte[8192];
        byte[] dataTwo = new byte[8192];
        FileInputStream one = null;
        FileInputStream two = null;
        try {
            int length;
            one = new FileInputStream(from);
            two = new FileInputStream(with);
            while ((length = one.read(dataOne)) != -1) {
                if (length == two.read(dataTwo)) break block9;
                bl = false;
            }
        }
        catch (Throwable throwable) {
            IoUtility.close(one);
            IoUtility.close(two);
            throw throwable;
        }
        {
            block9: {
                IoUtility.close(one);
                IoUtility.close(two);
                return bl;
            }
            if (Arrays.equals(dataOne, dataTwo)) continue;
            boolean bl2 = false;
            IoUtility.close(one);
            IoUtility.close(two);
            return bl2;
        }
        boolean bl3 = true;
        IoUtility.close(one);
        IoUtility.close(two);
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareTextFiles(File from, File with, String encoding) throws IOException {
        if (from == null && with == null) {
            return true;
        }
        if (from == null || with == null) {
            return false;
        }
        if (from.getAbsoluteFile().equals(with.getAbsoluteFile())) {
            return true;
        }
        one = null;
        two = null;
        fromIn = null;
        withIn = null;
        try {
            fromIn = new FileInputStream(from);
            one = new BufferedReader(new InputStreamReader((InputStream)fromIn, encoding));
            withIn = new FileInputStream(with);
            two = new BufferedReader(new InputStreamReader((InputStream)withIn, encoding));
            crOne = false;
            crTwo = false;
            while (true) {
                block11: {
                    if ((readOne = one.read()) != (readTwo = two.read())) break block11;
                    if (readOne >= 0) continue;
                    ** GOTO lbl-1000
                }
                crOne = readOne == 13;
                v0 = crTwo = readTwo == 13;
                if (crOne) {
                    readOne = one.read();
                }
                if (crTwo) {
                    readTwo = two.read();
                }
                if (crOne && readOne != 10 && IoUtility.isCr(readTwo)) {
                    readTwo = two.read();
                }
                if (crTwo && readTwo != 10 && IoUtility.isCr(readOne)) {
                    readOne = one.read();
                }
                if (readOne != readTwo && !IoUtility.isCr(readOne) && !IoUtility.isCr(readTwo)) break;
            }
            var11_11 = false;
        }
        catch (Throwable var12_12) {
            IoUtility.close(fromIn);
            IoUtility.close(one);
            IoUtility.close(two);
            IoUtility.close(withIn);
            throw var12_12;
        }
        IoUtility.close(fromIn);
        IoUtility.close(one);
        IoUtility.close(two);
        IoUtility.close(withIn);
        return var11_11;
lbl-1000:
        // 1 sources

        {
            var9_9 = true;
        }
        IoUtility.close(fromIn);
        IoUtility.close(one);
        IoUtility.close(two);
        IoUtility.close(withIn);
        return var9_9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareTextFiles(File from, File with, int startAtLine, String encoding) throws IOException {
        if (from == null && with == null) {
            return true;
        }
        if (from == null || with == null) {
            return false;
        }
        if (from.getAbsoluteFile().equals(with.getAbsoluteFile())) {
            return true;
        }
        one = null;
        two = null;
        fromIn = null;
        withIn = null;
        try {
            fromIn = new FileInputStream(from);
            one = new BufferedReader(new InputStreamReader((InputStream)fromIn, encoding));
            withIn = new FileInputStream(with);
            two = new BufferedReader(new InputStreamReader((InputStream)withIn, encoding));
            pos = 0;
            while (true) {
                lineOne = one.readLine();
                lineTwo = two.readLine();
                if (lineOne != null) continue;
                if (lineTwo != null) {
                    var11_12 = false;
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (Throwable var12_14) {
            IoUtility.close(fromIn);
            IoUtility.close(one);
            IoUtility.close(two);
            IoUtility.close(withIn);
            throw var12_14;
        }
        IoUtility.close(fromIn);
        IoUtility.close(one);
        IoUtility.close(two);
        IoUtility.close(withIn);
        return var11_12;
        {
            if (pos++ < startAtLine || lineOne.equals(lineTwo)) ** continue;
            var11_13 = false;
        }
        IoUtility.close(fromIn);
        IoUtility.close(one);
        IoUtility.close(two);
        IoUtility.close(withIn);
        return var11_13;
lbl-1000:
        // 1 sources

        {
            var9_10 = true;
        }
        IoUtility.close(fromIn);
        IoUtility.close(one);
        IoUtility.close(two);
        IoUtility.close(withIn);
        return var9_10;
    }

    private static boolean isCr(int c) {
        return c == 10 || c == 13 || c == 133 || c == 12 || c == 8232 || c == 8233;
    }

    public static boolean deleteDir(File directory, boolean deleteDir) {
        File candir;
        try {
            candir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!candir.equals(directory.getAbsoluteFile())) {
            return false;
        }
        boolean success = true;
        File[] files = candir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                boolean deleted = file.delete();
                if (!deleted && file.isDirectory()) {
                    deleted = IoUtility.deleteDir(file, true);
                }
                success = success && deleted;
            }
        }
        if (deleteDir) {
            return directory.delete();
        }
        return success;
    }

    public static boolean deleteDir(File directory, FileFilter filter) {
        File candir;
        try {
            candir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!candir.equals(directory.getAbsoluteFile())) {
            return false;
        }
        boolean success = true;
        File[] files = candir.listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                boolean deleted = file.delete();
                if (!deleted && file.isDirectory()) {
                    deleted = IoUtility.deleteDir(file, true);
                }
                success = success && deleted;
            }
        }
        return success;
    }

    public static void printAllSystemProperties() {
        Properties sysprops = System.getProperties();
        Enumeration<?> e = sysprops.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = sysprops.getProperty(key);
            System.out.println(key + "=" + value);
        }
    }

    public static File getUserHomeDirectory() {
        return new File((String)System.getProperties().get("user.home"));
    }

    public static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static File toFile(String path) {
        try {
            return new File(URLDecoder.decode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toUrlString(File file) {
        try {
            return file.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createNecessaryDirectories(File file) throws IOException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
            if (!file.getParentFile().exists()) {
                throw new IOException("creation of directory failed: " + file.getParent());
            }
        }
    }

    public static final String createRelativePath(File orgin, File next) {
        try {
            if (orgin.equals(next)) {
                return "";
            }
            try {
                String nex;
                String org = orgin.getCanonicalPath().replace('\\', '/');
                if (!org.endsWith("/")) {
                    org = org + '/';
                }
                if (!(nex = next.getCanonicalPath().replace('\\', '/')).endsWith("/")) {
                    nex = nex + '/';
                }
                if (org.equals(nex)) {
                    return "";
                }
                int i = -1;
                int j = 0;
                while (0 <= (i = org.indexOf("/", j)) && i >= 0 && nex.length() > i && org.substring(j, i).equals(nex.substring(j, i))) {
                    j = i + 1;
                }
                if (j > 0) {
                    i = j;
                    StringBuffer result = new StringBuffer(nex.length());
                    while (0 <= (i = org.indexOf("/", i))) {
                        ++i;
                        result.append("../");
                    }
                    result.append(nex.substring(j, nex.length() - 1));
                    return result.toString();
                }
                return nex.substring(0, nex.length() - 1);
            }
            catch (RuntimeException e) {
                return next.toString();
            }
        }
        catch (IOException e) {
            return new File(orgin, next.getPath()).getPath();
        }
    }

    public static void waitln() {
        System.out.println("\n..press <return> to continue");
        try {
            new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final File getStartDirectory(String application) {
        File startDirectory;
        if (IoUtility.isWebStarted()) {
            String userHome = System.getProperty("user.home", ".");
            startDirectory = new File(new File(userHome), "." + application);
        } else {
            startDirectory = new File(".");
        }
        return startDirectory;
    }

    public static final boolean isWebStarted() {
        String webStart = (String)System.getProperties().get("javawebstart.version");
        return webStart != null;
    }

    public static Properties loadProperties(URL url) throws IOException {
        Properties newprops = new Properties();
        InputStream in = url.openStream();
        newprops.load(in);
        in.close();
        return newprops;
    }

    public static Object getFieldContent(Object obj, String name) {
        Field field;
        try {
            field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            return field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldContentSuper(Object obj, String name) {
        Field field = null;
        try {
            Class<?> cl = obj.getClass();
            while (!(class$java$lang$Object == null ? IoUtility.class$("java.lang.Object") : class$java$lang$Object).equals(cl)) {
                try {
                    field = cl.getDeclaredField(name);
                    break;
                }
                catch (NoSuchFieldException ex) {
                    cl = cl.getSuperclass();
                }
            }
            if (field == null) {
                throw new NullPointerException("field not found: " + name);
            }
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        try {
            return field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldContent(Object obj, String name, Object value) {
        Field field;
        try {
            field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(int ms) {
        Object monitor;
        Object object = monitor = new Object();
        synchronized (object) {
            try {
                monitor.wait(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static int[] getJavaVersion() {
        String version = System.getProperty("java.version");
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        while (tokenizer.hasMoreElements()) {
            String sub = tokenizer.nextToken();
            for (int i = 0; i < sub.length(); ++i) {
                if (Character.isDigit(sub.charAt(i))) continue;
                sub = sub.substring(0, i);
                break;
            }
            try {
                numbers.add(new Integer(Integer.parseInt(sub)));
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        if (numbers.size() == 0) {
            return null;
        }
        int[] result = new int[numbers.size()];
        for (int i = 0; i < numbers.size(); ++i) {
            result[i] = (Integer)numbers.get(i);
        }
        return result;
    }

    public static String easyUrl(String url) {
        String result = url;
        try {
            URL u = new URL(url);
            if (u.getProtocol().equalsIgnoreCase("file")) {
                return IoUtility.toFile(u.getFile()).getCanonicalPath();
            }
        }
        catch (RuntimeException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String[][] getSortedSystemProperties() {
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(System.getProperties());
        String[][] rowData = new String[map.size()][2];
        int rowNum = 0;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            rowData[rowNum][0] = (String)entry.getKey();
            rowData[rowNum][1] = (String)entry.getValue();
            ++rowNum;
        }
        return rowData;
    }
}

